/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.DialogEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigHelper;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.papyrus.infra.nattable.celleditor.AbstractPapyrusStyledTextCellEditor;
import org.eclipse.papyrus.infra.nattable.converter.StringResolutionProblemPapyrusConverter;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.CrossAxisWrapper;
import org.eclipse.papyrus.infra.widgets.editors.StringEditorWithCompletionWrapper;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.papyrus.uml.nattable.editor.SingleReferenceValueCellEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.util.UMLReferenceConverter;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLReferenceTextWithCompletionCellEditor
extends AbstractPapyrusStyledTextCellEditor {
    private StringEditorWithCompletionWrapper textCompletion = null;
    private INameResolutionHelper helper;
    private IPapyrusConverter parser;
    private boolean isMultiValued = false;
    protected SingleReferenceValueCellEditor singleReferenceValueCellEditor;

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider, boolean commitOnUpDown, boolean moveSelectionOnEnter) {
        super(table, axisElement, elementProvider, commitOnUpDown, moveSelectionOnEnter);
    }

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider, boolean commitOnUpDown) {
        super(table, axisElement, elementProvider, commitOnUpDown);
    }

    public UMLReferenceTextWithCompletionCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        super(table, axisElement, elementProvider);
    }

    public void setIsMultiValued(boolean isMultivalued) {
        this.isMultiValued = isMultivalued;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        CrossAxisWrapper<EObject, EStructuralFeature> editedElement = UMLTableUtils.getRealEditedObject(this.layerCell, this.elementProvider);
        EObject element = (EObject)editedElement.getFirstAxis();
        boolean useSimpleDialog = true;
        Control control = null;
        if (!(element instanceof NamedElement) || ((NamedElement)element).getNamespace() != null) {
            this.helper = this.createNameResolutionHelper();
            this.parser = new StringResolutionProblemPapyrusConverter((IPapyrusConverter)new UMLReferenceConverter(this.helper, this.isMultiValued));
            this.setPapyrusConverter(this.parser);
            Object displayValue = null;
            displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, originalCanonicalValue) : originalCanonicalValue;
            if (displayValue.toString().isEmpty() && this.layerCell.getDataValue() != null) {
                this.helper = null;
                this.parser = null;
                this.setPapyrusConverter(this.parser);
            } else {
                useSimpleDialog = false;
            }
        }
        if (useSimpleDialog) {
            this.displayConverter = null;
            this.singleReferenceValueCellEditor = new SingleReferenceValueCellEditor(this.axisElement, this.elementProvider){

                public Control activateCell(Composite parent, Object originalCanonicalValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
                    this.parent = parent;
                    this.layerCell = cell;
                    this.configRegistry = configRegistry;
                    List configLabels = cell.getConfigLabels().getLabels();
                    this.displayConverter = UMLReferenceTextWithCompletionCellEditor.this.displayConverter;
                    this.dataValidator = (IDataValidator)configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", configLabels);
                    this.conversionEditErrorHandler = EditConfigHelper.getEditErrorHandler((IConfigRegistry)configRegistry, (ConfigAttribute)EditConfigAttributes.CONVERSION_ERROR_HANDLER, (List)configLabels);
                    this.validationEditErrorHandler = EditConfigHelper.getEditErrorHandler((IConfigRegistry)configRegistry, (ConfigAttribute)EditConfigAttributes.VALIDATION_ERROR_HANDLER, (List)configLabels);
                    this.dialog = this.createDialogInstance();
                    this.setCanonicalValue(originalCanonicalValue);
                    return null;
                }
            };
            control = this.singleReferenceValueCellEditor.activateCell(parent, originalCanonicalValue, EditModeEnum.DIALOG, (ICellEditHandler)new DialogEditHandler(), this.layerCell, this.configRegistry);
            if (this.singleReferenceValueCellEditor.open() == 0) {
                this.setCanonicalValue(this.singleReferenceValueCellEditor.getEditorValue());
                this.commit(SelectionLayer.MoveDirectionEnum.NONE);
            } else {
                this.singleReferenceValueCellEditor.close();
            }
        } else {
            control = super.activateCell(parent, originalCanonicalValue);
        }
        return control;
    }

    private void setPapyrusConverter(IPapyrusConverter parser) {
        if (this.displayConverter instanceof ISetPapyrusConverter) {
            ((ISetPapyrusConverter)this.displayConverter).setPapyrusConverter(parser);
        }
    }

    protected StyledText createStyledText(Composite parent, int style) {
        this.textCompletion = new StringEditorWithCompletionWrapper(parent, this.parser);
        return this.textCompletion.getTextViewer().getTextWidget();
    }

    public void keyPressed(KeyEvent event) {
        if (!this.isMultiValued || !this.textCompletion.isContentAssistOpened()) {
            super.keyPressed(event);
        }
    }

    protected INameResolutionHelper createNameResolutionHelper() {
        CrossAxisWrapper<EObject, EStructuralFeature> editedElement = UMLTableUtils.getRealEditedObject(this.layerCell, this.elementProvider);
        EObject element = (EObject)editedElement.getFirstAxis();
        Element scope = element instanceof Element ? (Element)element : UMLUtil.getBaseElement((EObject)element);
        NameResolutionHelper helper = null;
        EStructuralFeature feature = (EStructuralFeature)editedElement.getSecondAxis();
        EClassifier eType = feature.getEType();
        if (eType instanceof EClass) {
            helper = new NameResolutionHelper(scope, (EClass)eType);
        }
        return helper;
    }

    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        Object canonnicalValue = super.getCanonicalValue(conversionErrorHandler);
        if (canonnicalValue instanceof Collection) {
            return canonnicalValue;
        }
        if (this.isMultiValued) {
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.add(canonnicalValue);
            return coll;
        }
        return canonnicalValue;
    }

    public Object getEditorValue() {
        Object result = null;
        if (this.singleReferenceValueCellEditor != null) {
            result = this.singleReferenceValueCellEditor.getEditorValue();
        }
        return result != null ? result : super.getEditorValue();
    }

    public void close() {
        if (this.textCompletion != null && this.textCompletion.getTextWidget() != null && !this.textCompletion.getTextWidget().isDisposed()) {
            this.textCompletion.getTextWidget().dispose();
        }
        super.close();
    }

    protected EObject getEditedEObject() {
        return null;
    }
}

