/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.cdt.internal.ui.compare.CMergeViewer;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionInput;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.ReplaceEdit;

class CMacroCompareViewer
extends CMergeViewer {
    private static final RGB CHANGE_COLOR = new RGB(212, 212, 212);
    private final ReplaceEditsHighlighter fLeftHighlighter;
    private final ReplaceEditsHighlighter fRightHighlighter;
    private Color fChangeBackground;
    private TextViewer fLeftViewer;
    private TextViewer fRightViewer;
    private TextViewer fTopViewer;
    private int fViewerIndex;
    private CMacroExpansionInput fInput;
    private int fStepIndex;
    private int fPrefixLength;

    public CMacroCompareViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(parent, styles, mp);
        this.fChangeBackground = new Color((Device)parent.getDisplay(), CHANGE_COLOR);
        this.fLeftHighlighter = new ReplaceEditsHighlighter(this.fChangeBackground, true);
        this.fRightHighlighter = new ReplaceEditsHighlighter(this.fChangeBackground, false);
        this.fViewerIndex = 0;
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        if (this.fLeftViewer != null) {
            this.fLeftViewer.removeTextPresentationListener((ITextPresentationListener)this.fLeftHighlighter);
        }
        if (this.fRightViewer != null) {
            this.fRightViewer.removeTextPresentationListener((ITextPresentationListener)this.fRightHighlighter);
        }
        this.fChangeBackground.dispose();
        super.handleDispose(event);
    }

    protected IToolBarManager getToolBarManager(Composite parent) {
        return null;
    }

    @Override
    protected void configureTextViewer(TextViewer textViewer) {
        super.configureTextViewer(textViewer);
        switch (this.fViewerIndex++) {
            case 0: {
                this.fTopViewer = textViewer;
                this.fTopViewer.getTextWidget().setFont(JFaceResources.getFont((String)CMergeViewer.class.getName()));
                break;
            }
            case 1: {
                this.fLeftViewer = textViewer;
                this.fLeftViewer.getTextWidget().setFont(JFaceResources.getFont((String)CMergeViewer.class.getName()));
                this.fLeftViewer.addTextPresentationListener((ITextPresentationListener)this.fLeftHighlighter);
                break;
            }
            case 2: {
                this.fRightViewer = textViewer;
                this.fRightViewer.getTextWidget().setFont(JFaceResources.getFont((String)CMergeViewer.class.getName()));
                this.fRightViewer.addTextPresentationListener((ITextPresentationListener)this.fRightHighlighter);
            }
        }
    }

    protected ITokenComparator createTokenComparator(String line) {
        return new NullTokenComparator();
    }

    public void setMacroExpansionInput(CMacroExpansionInput input) {
        this.fInput = input;
        this.fPrefixLength = 0;
    }

    public void setInput(Object input) {
        boolean redraw = true;
        if (this.fLeftViewer != null && this.fRightViewer != null) {
            redraw = false;
            this.fLeftViewer.setRedraw(false);
            this.fRightViewer.setRedraw(false);
        }
        ReplaceEdit[] edits = null;
        try {
            if (this.fInput != null) {
                MacroExpansionExplorer.IMacroExpansionStep step = this.fStepIndex < this.fInput.fExplorer.getExpansionStepCount() ? this.fInput.fExplorer.getExpansionStep(this.fStepIndex) : this.fInput.fExplorer.getFullExpansion();
                edits = step.getReplacements();
                this.fLeftHighlighter.setReplaceEdits(this.fPrefixLength, edits);
                this.fRightHighlighter.setReplaceEdits(this.fPrefixLength, edits);
            }
            super.setInput(input);
        }
        finally {
            if (!redraw && this.fLeftViewer != null && this.fRightViewer != null) {
                this.fLeftViewer.setRedraw(true);
                this.fRightViewer.setRedraw(true);
            }
        }
        if (edits != null && edits.length > 0 && this.fLeftViewer != null && this.fRightViewer != null) {
            int firstDiffOffset = this.fPrefixLength + edits[0].getOffset();
            this.fLeftViewer.revealRange(firstDiffOffset, edits[0].getLength());
            this.fRightViewer.revealRange(firstDiffOffset, edits[0].getText().length());
        }
    }

    public void setMacroExpansionStep(int index) {
        this.fStepIndex = index;
    }

    private static class NullTokenComparator
    implements ITokenComparator {
        private NullTokenComparator() {
        }

        public int getTokenLength(int index) {
            return 0;
        }

        public int getTokenStart(int index) {
            return 0;
        }

        public int getRangeCount() {
            return 0;
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            return true;
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return true;
        }
    }

    private class ReplaceEditsHighlighter
    implements ITextPresentationListener {
        private boolean fBefore;
        private int[] fStarts;
        private int[] fLengths;
        private Color fBackground;

        public ReplaceEditsHighlighter(Color background, boolean before) {
            this.fBackground = background;
            this.fBefore = before;
        }

        public void setReplaceEdits(int prefixLength, ReplaceEdit[] edits) {
            this.fStarts = new int[edits.length];
            this.fLengths = new int[edits.length];
            int delta = 0;
            int i = 0;
            while (i < edits.length) {
                ReplaceEdit edit = edits[i];
                this.fStarts[i] = prefixLength + edit.getOffset() + delta;
                int n = this.fLengths[i] = this.fBefore ? edit.getLength() : edit.getText().length();
                if (!this.fBefore) {
                    delta += edit.getText().length() - edit.getLength();
                }
                ++i;
            }
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            int i = 0;
            while (i < this.fStarts.length) {
                textPresentation.mergeStyleRange(new StyleRange(this.fStarts[i], this.fLengths[i], null, this.fBackground));
                ++i;
            }
        }
    }
}

