/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CUILabelProvider
extends LabelProvider
implements IColorProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    protected CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private ArrayList<ILabelDecorator> fLabelDecorators = null;
    private int fImageFlags;
    private long fTextFlags;
    private Color fInactiveColor;

    public CUILabelProvider() {
        this(1L, 1);
    }

    public CUILabelProvider(long textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        if (this.fLabelDecorators == null) {
            this.fLabelDecorators = new ArrayList(2);
        }
        this.fLabelDecorators.add(decorator);
    }

    public final void setTextFlags(long textFlags) {
        this.fTextFlags = textFlags;
    }

    public final void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final long getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object element) {
        return this.getImageFlags();
    }

    protected long evaluateTextFlags(Object element) {
        return this.getTextFlags();
    }

    protected Image decorateImage(Image image, Object element) {
        if (this.fLabelDecorators != null && image != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                image = decorator.decorateImage(image, element);
                ++i;
            }
        }
        return image;
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        if (result == null && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getImage(element);
        }
        return this.decorateImage(result, element);
    }

    protected String decorateText(String text, Object element) {
        if (this.fLabelDecorators != null && text.length() > 0) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                text = decorator.decorateText(text, element);
                ++i;
            }
        }
        return text;
    }

    public String getText(Object element) {
        String result = CElementLabels.getTextLabel(element, this.evaluateTextFlags(element));
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        return this.decorateText(result, element);
    }

    public StyledString getStyledText(Object element) {
        String decorated;
        StyledString string = CElementLabels.getStyledTextLabel(element, this.evaluateTextFlags(element) | 0x100000000L);
        if (string.length() == 0 && element instanceof IStorage) {
            string = new StyledString(this.fStorageLabelProvider.getText(element));
        }
        if ((decorated = this.decorateText(string.getString(), element)) != null) {
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.DECORATIONS_STYLER, (StyledString)string);
        }
        return string;
    }

    public void dispose() {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.dispose();
                ++i;
            }
            this.fLabelDecorators = null;
        }
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.addListener(listener);
                ++i;
            }
        }
        super.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fLabelDecorators != null) {
            int i = 0;
            while (i < this.fLabelDecorators.size()) {
                ILabelDecorator decorator = this.fLabelDecorators.get(i);
                decorator.removeListener(listener);
                ++i;
            }
        }
        super.removeListener(listener);
    }

    public static ILabelDecorator[] getDecorators(boolean errortick, ILabelDecorator extra) {
        if (errortick) {
            if (extra == null) {
                return new ILabelDecorator[0];
            }
            return new ILabelDecorator[]{extra};
        }
        if (extra != null) {
            return new ILabelDecorator[]{extra};
        }
        return null;
    }

    public Color getForeground(Object element) {
        ISourceReference sref;
        if (element instanceof ISourceReference && !(sref = (ISourceReference)element).isActive()) {
            if (this.fInactiveColor == null && Display.getCurrent() != null) {
                this.fInactiveColor = CUIPlugin.getStandardDisplay().getSystemColor(16);
            }
            return this.fInactiveColor;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

