/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.check;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.xtend.typesystem.emf.check.CheckEValidatorAdapter;
import org.eclipse.xtend.typesystem.emf.check.CheckFileWithContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckRegistry {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String EXTENSION_POINT_ID = "org.eclipse.xtend.typesystem.emf.checks";
    private static final String NS_URI_ATTR_ID = "nsURI";
    private static final String CHECK_FILE_ATTR_ID = "checkFile";
    private static final String CHECK_FILE_PATH_ATTR_ID = "path";
    private static final String OVERRIDE_ATTR_ID = "override";
    private static final String REFERENCED_META_MODEL = "referencedMetaModel";
    private static CheckRegistry INSTANCE;

    private CheckRegistry() {
        this.registerExtensions();
    }

    public static CheckRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CheckRegistry();
        }
        return INSTANCE;
    }

    public void registerCheckFile(EPackage ePackage, String checkFileName, boolean isWrapExistingValidator, List<String> referencedEPackageNsURIs) {
        EValidator validator;
        CheckEValidatorAdapter extxptValidator = isWrapExistingValidator ? ((validator = EValidator.Registry.INSTANCE.getEValidator(ePackage)) instanceof CheckEValidatorAdapter ? (CheckEValidatorAdapter)validator : new CheckEValidatorAdapter(ePackage, validator)) : new CheckEValidatorAdapter(ePackage);
        CheckFileWithContext checkFile = new CheckFileWithContext(checkFileName);
        for (String referencedEPackageNsURI : referencedEPackageNsURIs) {
            checkFile.addImportedEPackageNsUri(referencedEPackageNsURI);
        }
        extxptValidator.addCheckFile(checkFile);
        EValidator.Registry.INSTANCE.put((Object)ePackage, (Object)extxptValidator);
    }

    private void registerExtensions() {
        try {
            IConfigurationElement[] metaModels;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_ID);
            IConfigurationElement[] iConfigurationElementArray = metaModels = extensionPoint.getConfigurationElements();
            int n = metaModels.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement metaModel = iConfigurationElementArray[n2];
                try {
                    IConfigurationElement[] checkFiles;
                    String nsURI = metaModel.getAttribute(NS_URI_ATTR_ID);
                    EPackage ePackage = this.findEPackage(nsURI);
                    boolean isWrapExistingValidator = !"true".equals(metaModel.getAttribute(OVERRIDE_ATTR_ID));
                    IConfigurationElement[] iConfigurationElementArray2 = checkFiles = metaModel.getChildren(CHECK_FILE_ATTR_ID);
                    int n3 = checkFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement checkFile = iConfigurationElementArray2[n4];
                        try {
                            String checkFileName = checkFile.getAttribute(CHECK_FILE_PATH_ATTR_ID);
                            ArrayList<String> referencedEPackageNsURIs = new ArrayList<String>();
                            IConfigurationElement[] iConfigurationElementArray3 = checkFile.getChildren(REFERENCED_META_MODEL);
                            int n5 = iConfigurationElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement referencedMetaModel = iConfigurationElementArray3[n6];
                                String refNsURI = referencedMetaModel.getAttribute(NS_URI_ATTR_ID);
                                referencedEPackageNsURIs.add(refNsURI);
                                ++n6;
                            }
                            this.registerCheckFile(ePackage, checkFileName, isWrapExistingValidator, referencedEPackageNsURIs);
                        }
                        catch (Exception exc) {
                            this.log.error((Object)exc);
                        }
                        ++n4;
                    }
                }
                catch (Exception exc) {
                    this.log.error((Object)exc);
                }
                ++n2;
            }
        }
        catch (Exception exc) {
            this.log.error((Object)exc);
        }
    }

    private EPackage findEPackage(String nsURI) {
        Object registryEntry = EPackage.Registry.INSTANCE.get((Object)nsURI);
        if (registryEntry == null) {
            throw new IllegalArgumentException("EPackage with URI " + nsURI + " not found in EPackage.Registry.INSTANCE");
        }
        if (registryEntry instanceof EPackage) {
            return (EPackage)registryEntry;
        }
        if (registryEntry instanceof EPackage.Descriptor) {
            return ((EPackage.Descriptor)registryEntry).getEPackage();
        }
        throw new IllegalArgumentException("Wrong type in Ecore.Registry");
    }
}

