/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTPortKindEnum;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.drop.CreateRTPortAndDisplayCommand;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.BorderMarchIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.LinearIterator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractProtocolToRTPortDropStrategy
extends TransactionalDropStrategy {
    private static final String EMPTY_STRING = "";

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        EObject targetElement;
        List<Classifier> handledDroppedObjects;
        DropObjectsRequest dropReq;
        Command command = null;
        if (request instanceof DropObjectsRequest && (dropReq = this.getDropObjectsRequest(request)) != null && this.canHandleRequest(handledDroppedObjects = this.getDroppedProtocol((Request)dropReq), targetElement = this.getTargetSemanticElement(targetEditPart)) && this.canHandleDropPosition(dropReq.getLocation())) {
            Point location = dropReq.getLocation();
            if (handledDroppedObjects.size() == 1) {
                command = this.getCreateAndDropObjectCommand((EObject)handledDroppedObjects.get(0), (Classifier)targetElement, location, targetEditPart);
            } else {
                ILocationIterator locationIterator;
                CompoundCommand compound = new CompoundCommand();
                int stride = IRTPortEditPart.getDefaultSize((boolean)false).width * 8 / 3;
                if (this.getRTPortKind().isExternal()) {
                    IFigure iFigure = ((IGraphicalEditPart)targetEditPart).getFigure();
                    Rectangle bounds = iFigure.getBounds().getCopy();
                    iFigure.translateToAbsolute((Translatable)bounds);
                    locationIterator = BorderMarchIterator.from(location, bounds);
                } else {
                    locationIterator = LinearIterator.from(location);
                }
                for (EObject eObject : handledDroppedObjects) {
                    Command createPort = this.getCreateAndDropObjectCommand(eObject, (Classifier)targetElement, location, targetEditPart);
                    if (createPort != null) {
                        compound.add(createPort);
                        location = locationIterator.next(stride);
                    }
                    command = compound;
                }
            }
        }
        return command;
    }

    protected Command getCreateAndDropObjectCommand(EObject droppedObject, Classifier targetClassifier, Point location, EditPart targetEditPart) {
        CreateRTPortAndDisplayCommand command = new CreateRTPortAndDisplayCommand(targetClassifier, "org.eclipse.papyrusrt.umlrt.core.RTPort", UMLPackage.eINSTANCE.getNamespace_OwnedMember(), droppedObject, location, targetEditPart);
        command.setRTPortName(this.getName(droppedObject));
        command.setRTPortKind(this.getRTPortKind());
        return new ICommandProxy((ICommand)command);
    }

    protected String getName(EObject droppedObject) {
        String elementName;
        String name = EMPTY_STRING;
        if (droppedObject instanceof NamedElement && (elementName = ((NamedElement)droppedObject).getName()).length() > 0) {
            name = String.valueOf(Character.toLowerCase(elementName.charAt(0))) + elementName.substring(1);
        }
        return name;
    }

    protected boolean canHandleDropPosition(Point point) {
        return true;
    }

    protected List<Classifier> getDroppedProtocol(Request req) {
        List droppedObjects = this.getSourceEObjects(req);
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        if (droppedObjects != null) {
            for (EObject droppedObject : droppedObjects) {
                if (!(droppedObject instanceof Classifier) || !ProtocolUtils.isProtocol((EObject)droppedObject).booleanValue()) continue;
                result.add((Classifier)droppedObject);
            }
        }
        return result;
    }

    protected boolean canHandleRequest(List<Classifier> droppedObjects, EObject targetElement) {
        boolean result = false;
        if (!droppedObjects.isEmpty()) {
            result = targetElement instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)targetElement)) && droppedObjects.size() > 0;
        }
        return result;
    }

    protected abstract RTPortKindEnum getRTPortKind();
}

