/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.DiagramEdgesSyncFeature;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.sync.UMLRTSyncRegistry;

public abstract class UMLRTDiagramEdgesSyncFeature<M extends EObject, N extends EObject>
extends DiagramEdgesSyncFeature<M, N, EditPart> {
    private final Map<N, N> lastKnownMatch = new MapMaker().weakKeys().weakValues().makeMap();

    public UMLRTDiagramEdgesSyncFeature(SyncBucket<M, EditPart, Notification> bucket) {
        super(bucket);
    }

    protected abstract Class<? extends UMLRTSyncRegistry<N>> getNestedSyncRegistryType();

    protected UMLRTSyncRegistry<N> getNestedSyncRegistry() {
        return (UMLRTSyncRegistry)super.getNestedSyncRegistry();
    }

    protected abstract SyncBucket<N, EditPart, Notification> createNestedSyncBucket(N var1, EditPart var2);

    protected abstract Iterable<? extends N> getModelContents(M var1);

    protected boolean match(EObject sourceModel, EObject targetModel) {
        UMLRTSyncRegistry<N> nestedRegistry = this.getNestedSyncRegistry();
        EObject matched = nestedRegistry.getRedefinedElement((EObject)nestedRegistry.getModelType().cast(targetModel));
        return sourceModel.eResource() == null ? this.lastKnownMatch.get(targetModel) == sourceModel : matched == sourceModel;
    }

    protected EObject getTargetModel(SyncItem<M, EditPart> from, SyncItem<M, EditPart> to, EObject sourceModel) {
        EObject result = sourceModel;
        for (EObject target : this.getModelContents(this.getModelOf((EditPart)to.getBackend()))) {
            if (!this.match(sourceModel, target)) continue;
            result = target;
            break;
        }
        return result;
    }

    protected Command onTargetAdded(SyncItem<M, EditPart> from, EObject source, SyncItem<M, EditPart> to, EditPart target) {
        EObject masterNested;
        UMLRTSyncRegistry<N> nestedRegistry = this.getNestedSyncRegistry();
        EObject nested = nestedRegistry.getModelOf(target);
        EObject eObject = masterNested = nested == null ? null : nestedRegistry.getRedefinedElement(nested);
        if (masterNested != null) {
            SyncItem master = this.getMaster();
            for (EditPart next : this.getContents((EditPart)master.getBackend())) {
                EObject matchNested = nestedRegistry.getModelOf(next);
                if (matchNested != masterNested) continue;
                this.lastKnownMatch.put(nested, masterNested);
                SyncBucket<EObject, EditPart, Notification> bucket = nestedRegistry.getBucket(masterNested);
                if (bucket == null) {
                    bucket = this.createNestedSyncBucket(masterNested, next);
                    nestedRegistry.register(bucket);
                }
                bucket.add((Object)target);
                break;
            }
        }
        return null;
    }

    protected Command onTargetRemoved(SyncItem<M, EditPart> to, EditPart target) {
        EObject masterNested;
        UMLRTSyncRegistry<N> nestedRegistry = this.getNestedSyncRegistry();
        EObject nested = nestedRegistry.getModelOf(target);
        EObject eObject = masterNested = nested == null ? null : nestedRegistry.getRedefinedElement(nested);
        if (masterNested != null) {
            SyncItem master = this.getMaster();
            for (EditPart next : this.getContents((EditPart)master.getBackend())) {
                EObject matchNested = nestedRegistry.getModelOf(next);
                if (matchNested != masterNested) continue;
                SyncBucket bucket = nestedRegistry.getBucket(masterNested);
                if (bucket == null) break;
                bucket.remove((Object)target);
                break;
            }
        }
        return null;
    }
}

