/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures.IStackedFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.css.RGBColor;

public class DrawFigureUtils {
    public static void paintStack(IStackedFigure figure, Graphics graphics) {
        if (figure instanceof NodeFigure && figure instanceof IRoundedRectangleFigure) {
            Rectangle bounds = ((NodeFigure)figure).getBounds();
            Rectangle clip = bounds.getCopy();
            IRoundedRectangleFigure roundedFigure = (IRoundedRectangleFigure)figure;
            int nl = figure.getLayerNumber();
            Offsets o = DrawFigureUtils.getOffsets(figure);
            Rectangle layer = new Rectangle(0, 0, bounds.width - o.xDelta, bounds.height - o.yDelta);
            int i = nl;
            while (i >= 0) {
                layer.setLocation(bounds.x, bounds.y);
                layer.translate(DrawFigureUtils.getTranslation(i, o));
                graphics.pushState();
                Rectangle clipRectangle = graphics.getClip(clip).getUnion(layer).expand(1, 1);
                graphics.setClip(clipRectangle.getCopy());
                int rx = 0;
                int ry = 0;
                if (roundedFigure.getCornerDimensions().width > o.xDelta) {
                    rx = roundedFigure.getCornerDimensions().width - o.xDelta;
                }
                if (roundedFigure.getCornerDimensions().height > 0) {
                    ry = roundedFigure.getCornerDimensions().height - o.yDelta;
                }
                if (i == 0) {
                    graphics.setBackgroundColor(figure.getLayerColor());
                    graphics.fillRoundRectangle(layer, rx, ry);
                    DrawFigureUtils.replicateBackground((NodeFigure)figure, graphics, layer);
                }
                graphics.popState();
                graphics.setLineWidth(figure.getLayerLineWidth());
                graphics.drawRoundRectangle(layer, rx, ry);
                --i;
            }
        }
    }

    public static void replicateBackground(NodeFigure figure, Graphics graphics, Rectangle layer) {
        if (figure.isUsingGradient()) {
            DrawFigureUtils.replicateGradient(figure, graphics, layer);
        } else {
            graphics.setBackgroundColor(figure.getBackgroundColor());
        }
    }

    public static void replicateGradient(NodeFigure figure, Graphics graphics, Rectangle rectangle) {
        if (figure instanceof NodeFigure) {
            DrawFigureUtils.fillGradient(DrawFigureUtils.getColor(figure.getGradientColor2()), DrawFigureUtils.getColor(figure.getGradientColor1()), graphics, rectangle, figure.getGradientStyle() == 0);
        }
    }

    public static Color getColor(int integerColor) {
        return ColorRegistry.getInstance().getColor(Integer.valueOf(integerColor));
    }

    public static void fillGradient(Color gradiantColor1, Color gradientColor2, Graphics graphics, Rectangle rectangle, boolean style) {
        graphics.setForegroundColor(gradiantColor1);
        graphics.setBackgroundColor(gradientColor2);
        graphics.fillGradient(rectangle.getCopy(), style);
    }

    public static void paintPattern(IRoundedRectangleFigure figure, Graphics graphics, String patternPath) {
        Image hashImage = Activator.getPluginIconImage((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)patternPath);
        int imageWidth = hashImage.getBounds().width;
        int imageHeight = hashImage.getBounds().height;
        Offsets o = DrawFigureUtils.getOffsets(figure);
        int horizontalTimes = (figure.getBounds().width() - o.xDelta) / imageWidth + 1;
        int verticalTimes = (figure.getBounds().height() - o.yDelta) / imageHeight + 1;
        Point origin = new Point(figure.getBounds().getLocation());
        Rectangle clipRectangle = figure.getBounds().getCopy();
        int verticalTime = 0;
        while (verticalTime < verticalTimes) {
            int horizontalTime = 0;
            while (horizontalTime < horizontalTimes) {
                graphics.pushState();
                graphics.getClip(clipRectangle);
                clipRectangle.width -= o.xDelta;
                clipRectangle.height -= o.yDelta;
                clipRectangle.translate(DrawFigureUtils.getTranslation(0, o));
                graphics.setClip(clipRectangle);
                graphics.drawImage(hashImage, origin);
                graphics.popState();
                origin.translate(imageWidth, 0);
                ++horizontalTime;
            }
            origin.setX(figure.getBounds().getLocation().x());
            origin.translate(0, imageHeight);
            ++verticalTime;
        }
    }

    public static Color getColorFromString(String stringColor) {
        Color color = null;
        if (stringColor != null && !"-1".equals(stringColor)) {
            RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)stringColor);
            if (rgbColor != null) {
                try {
                    int red = Integer.parseInt(rgbColor.getRed().toString());
                    int green = Integer.parseInt(rgbColor.getGreen().toString());
                    int blue = Integer.parseInt(rgbColor.getBlue().toString());
                    color = ColorRegistry.getInstance().getColor(new RGB(red, green, blue));
                }
                catch (NumberFormatException e) {
                    Activator.log.error("name label color not well set: " + stringColor, (Throwable)e);
                }
            }
            if (color == null) {
                try {
                    color = ColorRegistry.getInstance().getColor(Integer.valueOf(stringColor));
                }
                catch (NumberFormatException e) {
                    Activator.log.error("Shadow Color not well set", (Throwable)e);
                }
            }
        }
        return color;
    }

    protected static Offsets getOffsets(Object figure) {
        Offsets o = new Offsets();
        if (figure instanceof IStackedFigure) {
            o.xOffSet = (int)Math.round(((IStackedFigure)figure).getXOffSet());
            o.yOffSet = (int)Math.round(((IStackedFigure)figure).getYOffSet());
            o.xDelta = Math.abs(o.xOffSet) + 1;
            o.yDelta = Math.abs(o.yOffSet) + 1;
            o.nl = ((IStackedFigure)figure).getLayerNumber();
        } else {
            o.xOffSet = 0;
            o.yOffSet = 0;
            o.xDelta = 0;
            o.yDelta = 0;
            o.nl = 0;
        }
        return o;
    }

    protected static Point getTranslation(int index, Offsets o) {
        Point translation = new Point(index * o.xOffSet, (o.nl - index) * o.yOffSet);
        return translation;
    }

    public static class Offsets {
        protected int xOffSet;
        protected int yOffSet;
        protected int xDelta;
        protected int yDelta;
        protected int nl;
    }
}

