/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.meta.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.meta.metaData.MdAlgorithm;
import org.eclipse.elk.core.meta.metaData.MdBundle;
import org.eclipse.elk.core.meta.metaData.MdBundleMember;
import org.eclipse.elk.core.meta.metaData.MdCategory;
import org.eclipse.elk.core.meta.metaData.MdGraphFeature;
import org.eclipse.elk.core.meta.metaData.MdGroup;
import org.eclipse.elk.core.meta.metaData.MdGroupOrOption;
import org.eclipse.elk.core.meta.metaData.MdModel;
import org.eclipse.elk.core.meta.metaData.MdOption;
import org.eclipse.elk.core.meta.metaData.MdOptionDependency;
import org.eclipse.elk.core.meta.metaData.MdOptionSupport;
import org.eclipse.elk.core.meta.metaData.MdOptionTargetType;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class MetaDataJvmModelInferrer
extends AbstractModelInferrer {
    @Inject
    @Extension
    private JvmTypesBuilder _jvmTypesBuilder;
    @Inject
    @Extension
    private Primitives _primitives;

    protected void _infer(final MdModel model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        MdBundle _bundle;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean _or = false;
        String _name = model.getName();
        boolean bl = _tripleEquals = _name == null;
        _or = _tripleEquals ? true : (_tripleEquals_1 = (_bundle = model.getBundle()) == null);
        if (_or) {
            return;
        }
        final MdBundle bundle = model.getBundle();
        String _qualifiedTargetClass = this.getQualifiedTargetClass(bundle);
        JvmGenericType _class = this._jvmTypesBuilder.toClass((EObject)bundle, _qualifiedTargetClass);
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                EList _superTypes = it.getSuperTypes();
                JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
                String _documentation = MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)model);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, _documentation);
                String _documentation_1 = MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)bundle);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _documentation_1);
                EList<MdBundleMember> _members = bundle.getMembers();
                Iterable _allOptionDefinitions = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(_members);
                for (MdOption property : _allOptionDefinitions) {
                    XExpression _upperBound;
                    boolean _tripleNotEquals_2;
                    XExpression _lowerBound;
                    boolean _tripleNotEquals_1;
                    boolean _tripleNotEquals;
                    JvmField constant = MetaDataJvmModelInferrer.this.toOptionConstant(property);
                    XExpression _defaultValue = property.getDefaultValue();
                    boolean bl = _tripleNotEquals = _defaultValue != null;
                    if (_tripleNotEquals) {
                        EList _members_1 = it.getMembers();
                        JvmField _optionDefault = MetaDataJvmModelInferrer.this.toOptionDefault(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_optionDefault);
                    }
                    boolean bl2 = _tripleNotEquals_1 = (_lowerBound = property.getLowerBound()) != null;
                    if (_tripleNotEquals_1) {
                        EList _members_2 = it.getMembers();
                        JvmField _optionLowerBound = MetaDataJvmModelInferrer.this.toOptionLowerBound(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_2, (Object)_optionLowerBound);
                    }
                    boolean bl3 = _tripleNotEquals_2 = (_upperBound = property.getUpperBound()) != null;
                    if (_tripleNotEquals_2) {
                        EList _members_3 = it.getMembers();
                        JvmField _optionUpperBound = MetaDataJvmModelInferrer.this.toOptionUpperBound(property);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_3, (Object)_optionUpperBound);
                    }
                    EList _members_4 = it.getMembers();
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_4, (Object)constant);
                }
                EList<MdBundleMember> _members_1 = bundle.getMembers();
                Iterable _allOptionDefinitions_1 = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(_members_1);
                for (MdOption property_1 : _allOptionDefinitions_1) {
                    EList<MdOptionDependency> _dependencies = property_1.getDependencies();
                    for (MdOptionDependency dependency : _dependencies) {
                        boolean _tripleNotEquals;
                        XExpression _value = dependency.getValue();
                        boolean bl = _tripleNotEquals = _value != null;
                        if (!_tripleNotEquals) continue;
                        EList _members_2 = it.getMembers();
                        JvmField _dependencyValue = MetaDataJvmModelInferrer.this.toDependencyValue(dependency);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_2, (Object)_dependencyValue);
                    }
                }
                EList _members_3 = it.getMembers();
                JvmTypeReference _typeRef_1 = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]);
                Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

                    public void apply(JvmOperation it) {
                        EList _parameters = it.getParameters();
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]);
                        JvmFormalParameter _parameter = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)bundle, "registry", _typeRef);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _registerLayoutOptions = MetaDataJvmModelInferrer.this.registerLayoutOptions(bundle);
                                _builder.append((Object)_registerLayoutOptions, "");
                                _builder.newLineIfNotEmpty();
                                StringConcatenationClient _registerLayoutCategories = MetaDataJvmModelInferrer.this.registerLayoutCategories(bundle);
                                _builder.append((Object)_registerLayoutCategories, "");
                                _builder.newLineIfNotEmpty();
                                StringConcatenationClient _registerLayoutAlgorithms = MetaDataJvmModelInferrer.this.registerLayoutAlgorithms(bundle);
                                _builder.append((Object)_registerLayoutAlgorithms, "");
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmOperation _method = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)bundle, "apply", _typeRef_1, (Procedures.Procedure1)_function);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_3, (Object)_method);
            }
        };
        acceptor.accept((JvmDeclaredType)_class, (Procedures.Procedure1)_function);
        EList<MdBundleMember> _members = bundle.getMembers();
        Iterable _filter = Iterables.filter(_members, MdAlgorithm.class);
        for (MdAlgorithm algorithm : _filter) {
            this.inferAlgorithm(algorithm, acceptor, isPreIndexingPhase);
        }
    }

    private JvmField toOptionConstant(final MdOption option) {
        JvmTypeReference _typeRef;
        String _constantName = this.getConstantName(option);
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                boolean _isDeprecated = option.isDeprecated();
                it.setDeprecated(_isDeprecated);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        JvmTypeReference _typeRef;
                        _builder.append((Object)"new ");
                        _builder.append(Property.class, "");
                        _builder.append((Object)"<");
                        JvmTypeReference _elvis = null;
                        JvmTypeReference _type = option.getType();
                        JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(_type);
                        _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                        _builder.append((Object)_elvis, "");
                        _builder.append((Object)">(");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"        ");
                        String _qualifiedName = MetaDataJvmModelInferrer.this.getQualifiedName(option);
                        String _codeString = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName);
                        _builder.append((Object)_codeString, "        ");
                        boolean _hasDefaultOrBounds = MetaDataJvmModelInferrer.this.hasDefaultOrBounds(option);
                        if (_hasDefaultOrBounds) {
                            boolean _tripleNotEquals_2;
                            boolean _tripleNotEquals_1;
                            boolean _tripleNotEquals;
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _defaultValue = option.getDefaultValue();
                            boolean bl = _tripleNotEquals = _defaultValue != null;
                            if (_tripleNotEquals) {
                                String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                                _builder.append((Object)_defaultConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _lowerBound = option.getLowerBound();
                            boolean bl2 = _tripleNotEquals_1 = _lowerBound != null;
                            if (_tripleNotEquals_1) {
                                String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                                _builder.append((Object)_lowerBoundConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                            _builder.append((Object)",");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"        ");
                            XExpression _upperBound = option.getUpperBound();
                            boolean bl3 = _tripleNotEquals_2 = _upperBound != null;
                            if (_tripleNotEquals_2) {
                                String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                                _builder.append((Object)_upperBoundConstantName, "        ");
                            } else {
                                _builder.append((Object)"null");
                            }
                        }
                        _builder.append((Object)")");
                    }
                };
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
                String _description = option.getDescription();
                String _trimLines = MetaDataJvmModelInferrer.this.trimLines(_description);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _trimLines);
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, _constantName, _typeRef_1, (Procedures.Procedure1)_function);
    }

    private boolean hasDefaultOrBounds(MdOption option) {
        XExpression _upperBound;
        boolean _tripleNotEquals_2;
        XExpression _lowerBound;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _or = false;
        boolean _or_1 = false;
        XExpression _defaultValue = option.getDefaultValue();
        boolean bl = _tripleNotEquals = _defaultValue != null;
        _or_1 = _tripleNotEquals ? true : (_tripleNotEquals_1 = (_lowerBound = option.getLowerBound()) != null);
        _or = _or_1 ? true : (_tripleNotEquals_2 = (_upperBound = option.getUpperBound()) != null);
        return _or;
    }

    private JvmField toOptionDefault(final MdOption option) {
        JvmTypeReference _typeRef;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_type);
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        String _defaultConstantName = this.getDefaultConstantName(option);
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                XExpression _defaultValue = option.getDefaultValue();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _defaultValue);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Default value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append((Object)_constantName, "");
                _builder.append((Object)"}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, _defaultConstantName, optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toOptionLowerBound(final MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(_type);
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        String _lowerBoundConstantName = this.getLowerBoundConstantName(option);
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                XExpression _lowerBound = option.getLowerBound();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _lowerBound);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Lower bound value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append((Object)_constantName, "");
                _builder.append((Object)"}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, _lowerBoundConstantName, optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toOptionUpperBound(final MdOption option) {
        JvmTypeReference _wildcard;
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = option.getType();
        JvmTypeReference _asWrapperTypeIfPrimitive = this._primitives.asWrapperTypeIfPrimitive(_type);
        JvmTypeReference _wildcardSuper = null;
        if (_asWrapperTypeIfPrimitive != null) {
            _wildcardSuper = this._typeReferenceBuilder.wildcardSuper(_asWrapperTypeIfPrimitive);
        }
        _elvis = _wildcardSuper != null ? _wildcardSuper : (_wildcard = this._typeReferenceBuilder.wildcard());
        JvmTypeReference optionType = this._typeReferenceBuilder.typeRef(Comparable.class, new JvmTypeReference[]{_elvis});
        String _upperBoundConstantName = this.getUpperBoundConstantName(option);
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                XExpression _upperBound = option.getUpperBound();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _upperBound);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Upper bound value for {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(option);
                _builder.append((Object)_constantName, "");
                _builder.append((Object)"}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)option, _upperBoundConstantName, optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toDependencyValue(final MdOptionDependency dependency) {
        JvmTypeReference _typeRef;
        EObject _eContainer = dependency.eContainer();
        final MdOption source = (MdOption)_eContainer;
        JvmTypeReference _elvis = null;
        MdOption _target = dependency.getTarget();
        JvmTypeReference _type = _target.getType();
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_type);
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        String _dependencyConstantName = this.getDependencyConstantName(dependency);
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                XExpression _value = dependency.getValue();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _value);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Required value for dependency between {@link #");
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(source);
                _builder.append((Object)_constantName, "");
                _builder.append((Object)"} and {@link #");
                MdOption _target = dependency.getTarget();
                String _constantName_1 = MetaDataJvmModelInferrer.this.getConstantName(_target);
                _builder.append((Object)_constantName_1, "");
                _builder.append((Object)"}.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)dependency, _dependencyConstantName, optionType, (Procedures.Procedure1)_function);
    }

    private StringConcatenationClient registerLayoutOptions(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<MdBundleMember> _members = bundle.getMembers();
                Iterable _allOptionDefinitions = MetaDataJvmModelInferrer.this.getAllOptionDefinitions(_members);
                for (MdOption option : _allOptionDefinitions) {
                    boolean _not;
                    boolean _isGlobal;
                    boolean _isOutput;
                    boolean _tripleEquals_2;
                    boolean _tripleEquals_1;
                    boolean _tripleEquals;
                    String _name;
                    _builder.append((Object)"registry.register(new org.eclipse.elk.core.data.LayoutOptionData(");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    String _qualifiedName = MetaDataJvmModelInferrer.this.getQualifiedName(option);
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName);
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    Iterable _groups = MetaDataJvmModelInferrer.this.getGroups(option);
                    Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

                        public String apply(MdGroup it) {
                            return it.getName();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_groups, (Functions.Function1)_function);
                    String _join = IterableExtensions.join((Iterable)_map, (CharSequence)".");
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(_join);
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _elvis = null;
                    String _label = option.getLabel();
                    _elvis = _label != null ? _label : (_name = option.getName());
                    String _shrinkWhiteSpace = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis);
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace);
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _description = option.getDescription();
                    String _shrinkWhiteSpace_1 = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_description);
                    String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace_1);
                    _builder.append((Object)_codeString_3, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    XExpression _defaultValue = option.getDefaultValue();
                    boolean bl = _tripleEquals = _defaultValue == null;
                    if (_tripleEquals) {
                        _builder.append((Object)"null,");
                    } else {
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(option);
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.append((Object)",");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    XExpression _lowerBound = option.getLowerBound();
                    boolean bl2 = _tripleEquals_1 = _lowerBound == null;
                    if (_tripleEquals_1) {
                        _builder.append((Object)"null,");
                    } else {
                        String _lowerBoundConstantName = MetaDataJvmModelInferrer.this.getLowerBoundConstantName(option);
                        _builder.append((Object)_lowerBoundConstantName, "    ");
                        _builder.append((Object)",");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    XExpression _upperBound = option.getUpperBound();
                    boolean bl3 = _tripleEquals_2 = _upperBound == null;
                    if (_tripleEquals_2) {
                        _builder.append((Object)"null,");
                    } else {
                        String _upperBoundConstantName = MetaDataJvmModelInferrer.this.getUpperBoundConstantName(option);
                        _builder.append((Object)_upperBoundConstantName, "    ");
                        _builder.append((Object)",");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    _builder.append((Object)"org.eclipse.elk.core.data.LayoutOptionData.Type.");
                    String _optionType = MetaDataJvmModelInferrer.this.getOptionType(option);
                    _builder.append((Object)_optionType, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    JvmTypeReference _optionTypeClass = MetaDataJvmModelInferrer.this.getOptionTypeClass(option);
                    _builder.append((Object)_optionTypeClass, "    ");
                    _builder.append((Object)".class,");
                    _builder.newLineIfNotEmpty();
                    EList<MdOptionTargetType> _targets = option.getTargets();
                    boolean _isEmpty = _targets.isEmpty();
                    if (_isEmpty) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)"null,");
                        _builder.newLine();
                    } else {
                        _builder.append((Object)"    ");
                        _builder.append(EnumSet.class, "    ");
                        _builder.append((Object)".of(");
                        EList<MdOptionTargetType> _targets_1 = option.getTargets();
                        boolean _hasElements = false;
                        for (MdOptionTargetType t : _targets_1) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "    ");
                            }
                            _builder.append((Object)"org.eclipse.elk.core.data.LayoutOptionData.Target.");
                            String _string = t.toString();
                            String _upperCase = _string.toUpperCase();
                            _builder.append((Object)_upperCase, "    ");
                        }
                        _builder.append((Object)"),");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean _or = false;
                    boolean _or_1 = false;
                    boolean _isProgrammatic = option.isProgrammatic();
                    _or_1 = _isProgrammatic ? true : (_isOutput = option.isOutput());
                    _or = _or_1 ? true : (_isGlobal = option.isGlobal());
                    if (_or) {
                        _builder.append((Object)"    ");
                        _builder.append((Object)"org.eclipse.elk.core.data.LayoutOptionData.Visibility.HIDDEN");
                        _builder.newLine();
                    } else {
                        boolean _isAdvanced = option.isAdvanced();
                        if (_isAdvanced) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)"org.eclipse.elk.core.data.LayoutOptionData.Visibility.ADVANCED");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"    ");
                            _builder.append((Object)"org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE");
                            _builder.newLine();
                        }
                    }
                    EList<String> _legacyIds = option.getLegacyIds();
                    boolean _isEmpty_1 = _legacyIds.isEmpty();
                    boolean bl4 = _not = !_isEmpty_1;
                    if (_not) {
                        _builder.append((Object)"    ");
                        EList<String> _legacyIds_1 = option.getLegacyIds();
                        Functions.Function1<String, String> _function_1 = new Functions.Function1<String, String>(){

                            public String apply(String it) {
                                return ", \"" + it + "\"";
                            }
                        };
                        List _map_1 = ListExtensions.map(_legacyIds_1, (Functions.Function1)_function_1);
                        String _join_1 = IterableExtensions.join((Iterable)_map_1);
                        _builder.append((Object)_join_1, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"));");
                    _builder.newLine();
                    EList<MdOptionDependency> _dependencies = option.getDependencies();
                    for (MdOptionDependency dependency : _dependencies) {
                        boolean _tripleEquals_3;
                        _builder.append((Object)"registry.addDependency(");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        String _qualifiedName_1 = MetaDataJvmModelInferrer.this.getQualifiedName(option);
                        String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName_1);
                        _builder.append((Object)_codeString_4, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"    ");
                        MdOption _target = dependency.getTarget();
                        String _qualifiedName_2 = MetaDataJvmModelInferrer.this.getQualifiedName(_target);
                        String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName_2);
                        _builder.append((Object)_codeString_5, "    ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        XExpression _value = dependency.getValue();
                        boolean bl5 = _tripleEquals_3 = _value == null;
                        if (_tripleEquals_3) {
                            _builder.append((Object)"    ");
                            _builder.append((Object)"null");
                            _builder.newLine();
                        } else {
                            _builder.append((Object)"    ");
                            String _dependencyConstantName = MetaDataJvmModelInferrer.this.getDependencyConstantName(dependency);
                            _builder.append((Object)_dependencyConstantName, "    ");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)");");
                        _builder.newLine();
                    }
                }
            }
        };
        return _client;
    }

    private StringConcatenationClient registerLayoutCategories(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<MdBundleMember> _members = bundle.getMembers();
                Iterable _filter = Iterables.filter(_members, MdCategory.class);
                for (MdCategory category : _filter) {
                    String _name;
                    _builder.append((Object)"registry.register(new org.eclipse.elk.core.data.LayoutCategoryData(");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    String _qualifiedName = MetaDataJvmModelInferrer.this.getQualifiedName(category);
                    String _codeString = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName);
                    _builder.append((Object)_codeString, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _elvis = null;
                    String _label = category.getLabel();
                    _elvis = _label != null ? _label : (_name = category.getName());
                    String _shrinkWhiteSpace = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis);
                    String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace);
                    _builder.append((Object)_codeString_1, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    String _description = category.getDescription();
                    String _shrinkWhiteSpace_1 = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_description);
                    String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace_1);
                    _builder.append((Object)_codeString_2, "    ");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"));");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private StringConcatenationClient registerLayoutAlgorithms(final MdBundle bundle) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                EList<MdBundleMember> _members = bundle.getMembers();
                Iterable _filter = Iterables.filter(_members, MdAlgorithm.class);
                for (MdAlgorithm algorithm : _filter) {
                    _builder.append((Object)"new ");
                    String _qualifiedTargetClass = MetaDataJvmModelInferrer.this.getQualifiedTargetClass(algorithm);
                    _builder.append((Object)_qualifiedTargetClass, "");
                    _builder.append((Object)"().apply(registry);");
                    _builder.newLineIfNotEmpty();
                }
            }
        };
        return _client;
    }

    private void inferAlgorithm(final MdAlgorithm algorithm, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        boolean _tripleEquals;
        String _name = algorithm.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        String _qualifiedTargetClass = this.getQualifiedTargetClass(algorithm);
        JvmGenericType _class = this._jvmTypesBuilder.toClass((EObject)algorithm, _qualifiedTargetClass);
        Procedures.Procedure1<JvmGenericType> _function = new Procedures.Procedure1<JvmGenericType>(){

            public void apply(JvmGenericType it) {
                EList _superTypes = it.getSuperTypes();
                JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider", new JvmTypeReference[0]);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_superTypes, (Object)_typeRef);
                MdBundle _bundle = MetaDataJvmModelInferrer.this.getBundle(algorithm);
                String _documentation = MetaDataJvmModelInferrer.this._jvmTypesBuilder.getDocumentation((EObject)_bundle);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setFileHeader((JvmDeclaredType)it, _documentation);
                String _documentation_1 = algorithm.getDocumentation();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _documentation_1);
                EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
                for (MdOptionSupport support : _supportedOptions) {
                    boolean _tripleNotEquals;
                    XExpression _value = support.getValue();
                    boolean bl = _tripleNotEquals = _value != null;
                    if (_tripleNotEquals) {
                        EList _members = it.getMembers();
                        JvmField _supportedOptionDefault = MetaDataJvmModelInferrer.this.toSupportedOptionDefault(support);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_supportedOptionDefault);
                    }
                    EList _members_1 = it.getMembers();
                    JvmField _supportedOptionConstant = MetaDataJvmModelInferrer.this.toSupportedOptionConstant(support);
                    MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members_1, (Object)_supportedOptionConstant);
                }
                EList _members = it.getMembers();
                JvmTypeReference _typeRef_1 = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE, new JvmTypeReference[0]);
                Procedures.Procedure1<JvmOperation> _function = new Procedures.Procedure1<JvmOperation>(){

                    public void apply(JvmOperation it) {
                        EList _parameters = it.getParameters();
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef("org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry", new JvmTypeReference[0]);
                        JvmFormalParameter _parameter = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toParameter((EObject)algorithm, "registry", _typeRef);
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_parameters, (Object)_parameter);
                        StringConcatenationClient _client = new StringConcatenationClient(){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _registerLayoutAlgorithm = MetaDataJvmModelInferrer.this.registerLayoutAlgorithm(algorithm);
                                _builder.append((Object)_registerLayoutAlgorithm, "");
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        MetaDataJvmModelInferrer.this._jvmTypesBuilder.setBody((JvmExecutable)it, _client);
                    }
                };
                JvmOperation _method = MetaDataJvmModelInferrer.this._jvmTypesBuilder.toMethod((EObject)algorithm, "apply", _typeRef_1, (Procedures.Procedure1)_function);
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.operator_add(_members, (Object)_method);
            }
        };
        acceptor.accept((JvmDeclaredType)_class, (Procedures.Procedure1)_function);
    }

    private JvmField toSupportedOptionDefault(final MdOptionSupport support) {
        JvmTypeReference _typeRef;
        EObject _eContainer = support.eContainer();
        final MdAlgorithm algorithm = (MdAlgorithm)_eContainer;
        JvmTypeReference _elvis = null;
        MdOption _option = support.getOption();
        JvmTypeReference _type = _option.getType();
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_type);
        _elvis = _cloneWithProxies != null ? _cloneWithProxies : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference optionType = _elvis;
        MdOption _option_1 = support.getOption();
        String _defaultConstantName = this.getDefaultConstantName(_option_1);
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                String _name;
                it.setVisibility(JvmVisibility.PRIVATE);
                it.setStatic(true);
                it.setFinal(true);
                XExpression _value = support.getValue();
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _value);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Default value for {@link #");
                MdOption _option = support.getOption();
                String _constantName = MetaDataJvmModelInferrer.this.getConstantName(_option);
                _builder.append((Object)_constantName, "");
                _builder.append((Object)"} with algorithm \"");
                String _elvis = null;
                String _label = algorithm.getLabel();
                _elvis = _label != null ? _label : (_name = algorithm.getName());
                _builder.append((Object)_elvis, "");
                _builder.append((Object)"\".");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)support, _defaultConstantName, optionType, (Procedures.Procedure1)_function);
    }

    private JvmField toSupportedOptionConstant(final MdOptionSupport support) {
        JvmTypeReference _typeRef;
        MdOption _option = support.getOption();
        String _constantName = this.getConstantName(_option);
        JvmTypeReference _elvis = null;
        MdOption _option_1 = support.getOption();
        JvmTypeReference _type = _option_1.getType();
        _elvis = _type != null ? _type : (_typeRef = this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
        JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(IProperty.class, new JvmTypeReference[]{_elvis});
        Procedures.Procedure1<JvmField> _function = new Procedures.Procedure1<JvmField>(){

            public void apply(JvmField it) {
                StringConcatenationClient _client_1;
                StringConcatenationClient _client;
                it.setVisibility(JvmVisibility.PUBLIC);
                it.setStatic(true);
                it.setFinal(true);
                MdOption _option = support.getOption();
                boolean _isDeprecated = _option.isDeprecated();
                it.setDeprecated(_isDeprecated);
                StringConcatenationClient _xifexpression = null;
                XExpression _value = support.getValue();
                boolean _tripleEquals = _value == null;
                _xifexpression = _tripleEquals ? (_client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        MdOption _option = support.getOption();
                        MdBundle _bundle = MetaDataJvmModelInferrer.this.getBundle(_option);
                        String _qualifiedTargetClass = MetaDataJvmModelInferrer.this.getQualifiedTargetClass(_bundle);
                        JvmTypeReference _typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(_qualifiedTargetClass, new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef, "");
                        _builder.append((Object)".");
                        MdOption _option_1 = support.getOption();
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(_option_1);
                        _builder.append((Object)_constantName, "");
                    }
                }) : (_client_1 = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        JvmTypeReference _typeRef;
                        _builder.append((Object)"new ");
                        _builder.append(Property.class, "");
                        _builder.append((Object)"<");
                        JvmTypeReference _elvis = null;
                        MdOption _option = support.getOption();
                        JvmTypeReference _type = _option.getType();
                        JvmTypeReference _asWrapperTypeIfPrimitive = MetaDataJvmModelInferrer.this._primitives.asWrapperTypeIfPrimitive(_type);
                        _elvis = _asWrapperTypeIfPrimitive != null ? _asWrapperTypeIfPrimitive : (_typeRef = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class, new JvmTypeReference[0]));
                        _builder.append((Object)_elvis, "");
                        _builder.append((Object)">(");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"                            ");
                        MdOption _option_1 = support.getOption();
                        MdBundle _bundle = MetaDataJvmModelInferrer.this.getBundle(_option_1);
                        String _qualifiedTargetClass = MetaDataJvmModelInferrer.this.getQualifiedTargetClass(_bundle);
                        JvmTypeReference _typeRef_1 = MetaDataJvmModelInferrer.this._typeReferenceBuilder.typeRef(_qualifiedTargetClass, new JvmTypeReference[0]);
                        _builder.append((Object)_typeRef_1, "                            ");
                        _builder.append((Object)".");
                        MdOption _option_2 = support.getOption();
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(_option_2);
                        _builder.append((Object)_constantName, "                            ");
                        _builder.append((Object)",");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"                            ");
                        MdOption _option_3 = support.getOption();
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(_option_3);
                        _builder.append((Object)_defaultConstantName, "                            ");
                        _builder.append((Object)")");
                    }
                });
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _xifexpression);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Property constant to access ");
                String _elvis = null;
                MdOption _option_1 = support.getOption();
                String _label = _option_1.getLabel();
                if (_label != null) {
                    _elvis = _label;
                } else {
                    String _name;
                    MdOption _option_2 = support.getOption();
                    _elvis = _name = _option_2.getName();
                }
                _builder.append((Object)_elvis, "");
                _builder.append((Object)" from within the layout algorithm code.");
                MetaDataJvmModelInferrer.this._jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)it, _builder.toString());
            }
        };
        return this._jvmTypesBuilder.toField((EObject)support, _constantName, _typeRef_1, (Procedures.Procedure1)_function);
    }

    private StringConcatenationClient registerLayoutAlgorithm(final MdAlgorithm algorithm) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _name;
                _builder.append((Object)"registry.register(new org.eclipse.elk.core.data.LayoutAlgorithmData(");
                _builder.newLine();
                _builder.append((Object)"    ");
                String _qualifiedName = MetaDataJvmModelInferrer.this.getQualifiedName(algorithm);
                String _codeString = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName);
                _builder.append((Object)_codeString, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                String _elvis = null;
                String _label = algorithm.getLabel();
                _elvis = _label != null ? _label : (_name = algorithm.getName());
                String _shrinkWhiteSpace = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_elvis);
                String _codeString_1 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace);
                _builder.append((Object)_codeString_1, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                String _description = algorithm.getDescription();
                String _shrinkWhiteSpace_1 = MetaDataJvmModelInferrer.this.shrinkWhiteSpace(_description);
                String _codeString_2 = MetaDataJvmModelInferrer.this.toCodeString(_shrinkWhiteSpace_1);
                _builder.append((Object)_codeString_2, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"new org.eclipse.elk.core.util.AlgorithmFactory(");
                JvmTypeReference _provider = algorithm.getProvider();
                _builder.append((Object)_provider, "    ");
                _builder.append((Object)".class, \"");
                String _parameter = algorithm.getParameter();
                _builder.append((Object)_parameter, "    ");
                _builder.append((Object)"\"),");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                MdCategory _category = algorithm.getCategory();
                String _qualifiedName_1 = null;
                if (_category != null) {
                    _qualifiedName_1 = MetaDataJvmModelInferrer.this.getQualifiedName(_category);
                }
                String _codeString_3 = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName_1);
                _builder.append((Object)_codeString_3, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                MdBundle _bundle = MetaDataJvmModelInferrer.this.getBundle(algorithm);
                String _label_1 = null;
                if (_bundle != null) {
                    _label_1 = _bundle.getLabel();
                }
                String _codeString_4 = MetaDataJvmModelInferrer.this.toCodeString(_label_1);
                _builder.append((Object)_codeString_4, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                String _previewImage = algorithm.getPreviewImage();
                String _codeString_5 = MetaDataJvmModelInferrer.this.toCodeString(_previewImage);
                _builder.append((Object)_codeString_5, "    ");
                _builder.append((Object)",");
                _builder.newLineIfNotEmpty();
                EList<MdGraphFeature> _supportedFeatures = algorithm.getSupportedFeatures();
                boolean _isEmpty = _supportedFeatures.isEmpty();
                if (_isEmpty) {
                    _builder.append((Object)"    ");
                    _builder.append((Object)"null");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"    ");
                    _builder.append(EnumSet.class, "    ");
                    _builder.append((Object)".of(");
                    EList<MdGraphFeature> _supportedFeatures_1 = algorithm.getSupportedFeatures();
                    boolean _hasElements = false;
                    for (MdGraphFeature f : _supportedFeatures_1) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "    ");
                        }
                        _builder.append((Object)"org.eclipse.elk.core.options.GraphFeature.");
                        String _string = f.toString();
                        String _upperCase = _string.toUpperCase();
                        _builder.append((Object)_upperCase, "    ");
                    }
                    _builder.append((Object)")");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"));");
                _builder.newLine();
                EList<MdOptionSupport> _supportedOptions = algorithm.getSupportedOptions();
                for (MdOptionSupport support : _supportedOptions) {
                    boolean _tripleEquals;
                    _builder.append((Object)"registry.addOptionSupport(");
                    _builder.newLine();
                    _builder.append((Object)"    ");
                    String _qualifiedName_2 = MetaDataJvmModelInferrer.this.getQualifiedName(algorithm);
                    String _codeString_6 = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName_2);
                    _builder.append((Object)_codeString_6, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"    ");
                    MdOption _option = support.getOption();
                    String _qualifiedName_3 = MetaDataJvmModelInferrer.this.getQualifiedName(_option);
                    String _codeString_7 = MetaDataJvmModelInferrer.this.toCodeString(_qualifiedName_3);
                    _builder.append((Object)_codeString_7, "    ");
                    _builder.append((Object)",");
                    _builder.newLineIfNotEmpty();
                    XExpression _value = support.getValue();
                    boolean bl = _tripleEquals = _value == null;
                    if (_tripleEquals) {
                        _builder.append((Object)"    ");
                        MdOption _option_1 = support.getOption();
                        String _constantName = MetaDataJvmModelInferrer.this.getConstantName(_option_1);
                        _builder.append((Object)_constantName, "    ");
                        _builder.append((Object)".getDefault()");
                        _builder.newLineIfNotEmpty();
                    } else {
                        _builder.append((Object)"    ");
                        MdOption _option_2 = support.getOption();
                        String _defaultConstantName = MetaDataJvmModelInferrer.this.getDefaultConstantName(_option_2);
                        _builder.append((Object)_defaultConstantName, "    ");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)");");
                    _builder.newLine();
                }
            }
        };
        return _client;
    }

    private Iterable<MdOption> getAllOptionDefinitions(Iterable<? extends MdBundleMember> elements) {
        Iterable _filter = Iterables.filter(elements, MdOption.class);
        Iterable _filter_1 = Iterables.filter(elements, MdGroup.class);
        Functions.Function1<MdGroup, Iterable<MdOption>> _function = new Functions.Function1<MdGroup, Iterable<MdOption>>(){

            public Iterable<MdOption> apply(MdGroup it) {
                EList<MdGroupOrOption> _children = it.getChildren();
                return MetaDataJvmModelInferrer.this.getAllOptionDefinitions(_children);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return Iterables.concat((Iterable)_filter, (Iterable)_flatten);
    }

    private String getQualifiedTargetClass(MdBundle bundle) {
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _targetClass = bundle.getTargetClass();
        _elvis = _targetClass != null ? _targetClass : "Metadata";
        String bundleClass = _elvis;
        String _name = model.getName();
        String _plus = String.valueOf(_name) + ".";
        return String.valueOf(_plus) + bundleClass;
    }

    private String getQualifiedTargetClass(MdAlgorithm algorithm) {
        MdBundle _bundle = this.getBundle(algorithm);
        EObject _eContainer = _bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _targetClass = algorithm.getTargetClass();
        if (_targetClass != null) {
            _elvis = _targetClass;
        } else {
            String _plus;
            String _name = algorithm.getName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_name);
            _elvis = _plus = String.valueOf(_firstUpper) + "Metadata";
        }
        String algorithmClass = _elvis;
        String _name_1 = model.getName();
        String _plus_1 = String.valueOf(_name_1) + ".";
        return String.valueOf(_plus_1) + algorithmClass;
    }

    private Iterable<MdGroup> getGroups(MdBundleMember member) {
        LinkedList<MdGroup> _xblockexpression = null;
        LinkedList<MdGroup> groups = new LinkedList<MdGroup>();
        EObject group = member.eContainer();
        while (group instanceof MdGroup) {
            EObject _eContainer;
            groups.addFirst((MdGroup)group);
            group = _eContainer = ((MdGroup)group).eContainer();
        }
        _xblockexpression = groups;
        return _xblockexpression;
    }

    private String getOptionType(MdOption option) {
        boolean _matched_1;
        String _identifier;
        JvmTypeReference _type = option.getType();
        JvmType _type_1 = null;
        if (_type != null) {
            _type_1 = _type.getType();
        }
        JvmType jvmType = _type_1;
        boolean _matched = false;
        if (!_matched && jvmType instanceof JvmPrimitiveType) {
            String _name_3;
            String _name_2;
            String _name_1;
            String _name;
            _matched = true;
            _identifier = ((JvmPrimitiveType)jvmType).getIdentifier();
            _matched_1 = false;
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name = Boolean.TYPE.getName()))) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_1 = Integer.TYPE.getName()))) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_2 = Float.TYPE.getName()))) {
                _matched_1 = true;
                return "FLOAT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_name_3 = Double.TYPE.getName()))) {
                _matched_1 = true;
                return "FLOAT";
            }
        }
        if (!_matched && jvmType instanceof JvmGenericType) {
            String _canonicalName_5;
            String _canonicalName_4;
            String _canonicalName_3;
            String _canonicalName_2;
            String _canonicalName_1;
            String _canonicalName;
            _matched = true;
            _identifier = ((JvmGenericType)jvmType).getIdentifier();
            _matched_1 = false;
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName = Boolean.class.getCanonicalName()))) {
                _matched_1 = true;
                return "BOOLEAN";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_1 = Integer.class.getCanonicalName()))) {
                _matched_1 = true;
                return "INT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_2 = Float.class.getCanonicalName()))) {
                _matched_1 = true;
                return "FLOAT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_3 = Double.class.getCanonicalName()))) {
                _matched_1 = true;
                return "FLOAT";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_4 = String.class.getCanonicalName()))) {
                _matched_1 = true;
                return "STRING";
            }
            if (!_matched_1 && Objects.equal((Object)_identifier, (Object)(_canonicalName_5 = EnumSet.class.getCanonicalName()))) {
                _matched_1 = true;
                return "ENUMSET";
            }
            return "OBJECT";
        }
        if (!_matched && jvmType instanceof JvmEnumerationType) {
            _matched = true;
            return "ENUM";
        }
        return "UNDEFINED";
    }

    private boolean hasSupertype(JvmDeclaredType type, final Class<?> superType) {
        Functions.Function1<JvmDeclaredType, Boolean> _function_2;
        Functions.Function1<JvmTypeReference, JvmType> _function_1;
        boolean _notEquals;
        Functions.Function1<JvmTypeReference, Boolean> _function;
        EList _superTypes = type.getSuperTypes();
        JvmTypeReference _findFirst = (JvmTypeReference)IterableExtensions.findFirst((Iterable)_superTypes, (Functions.Function1)(_function = new Functions.Function1<JvmTypeReference, Boolean>(){

            public Boolean apply(JvmTypeReference t) {
                String _qualifiedName = t.getQualifiedName();
                String _canonicalName = superType.getCanonicalName();
                return Objects.equal((Object)_qualifiedName, (Object)_canonicalName);
            }
        }));
        boolean bl = _notEquals = !Objects.equal((Object)_findFirst, null);
        if (_notEquals) {
            return true;
        }
        EList _superTypes_1 = type.getSuperTypes();
        List _map = ListExtensions.map((List)_superTypes_1, (Functions.Function1)(_function_1 = new Functions.Function1<JvmTypeReference, JvmType>(){

            public JvmType apply(JvmTypeReference rt) {
                return rt.getType();
            }
        }));
        Iterable _filter = Iterables.filter((Iterable)_map, JvmDeclaredType.class);
        JvmDeclaredType _findFirst_1 = (JvmDeclaredType)IterableExtensions.findFirst((Iterable)_filter, (Functions.Function1)(_function_2 = new Functions.Function1<JvmDeclaredType, Boolean>(){

            public Boolean apply(JvmDeclaredType t) {
                return MetaDataJvmModelInferrer.this.hasSupertype(t, superType);
            }
        }));
        return !Objects.equal((Object)_findFirst_1, null);
    }

    private JvmTypeReference getOptionTypeClass(MdOption property) {
        JvmTypeReference _xblockexpression;
        boolean _notEquals;
        JvmTypeReference _xifexpression = null;
        JvmTypeReference _type = property.getType();
        boolean bl = _notEquals = !Objects.equal((Object)_type, null);
        if (_notEquals) {
            _xblockexpression = null;
            JvmTypeReference _type_1 = property.getType();
            JvmType _type_2 = _type_1.getType();
            if (_type_2 instanceof JvmPrimitiveType) {
                JvmTypeReference _type_3 = property.getType();
                JvmType _type_4 = _type_3.getType();
                JvmPrimitiveType primitiveType = (JvmPrimitiveType)_type_4;
                String _simpleName = primitiveType.getSimpleName();
                boolean _equals = Objects.equal((Object)_simpleName, (Object)"double");
                if (_equals) {
                    return this._typeReferenceBuilder.typeRef(Float.class, new JvmTypeReference[0]);
                }
                String _simpleName_1 = primitiveType.getSimpleName();
                boolean _equals_1 = Objects.equal((Object)_simpleName_1, (Object)"long");
                if (_equals_1) {
                    return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                }
            } else {
                JvmTypeReference _type_5 = property.getType();
                JvmType _type_6 = _type_5.getType();
                if (_type_6 instanceof JvmGenericType) {
                    JvmTypeReference _type_7 = property.getType();
                    JvmType _type_8 = _type_7.getType();
                    JvmGenericType genericType = (JvmGenericType)_type_8;
                    String _identifier = genericType.getIdentifier();
                    boolean _equals_2 = Objects.equal((Object)_identifier, (Object)"java.lang.Double");
                    if (_equals_2) {
                        return this._typeReferenceBuilder.typeRef(Float.class, new JvmTypeReference[0]);
                    }
                    String _identifier_1 = genericType.getIdentifier();
                    boolean _equals_3 = Objects.equal((Object)_identifier_1, (Object)"java.lang.Long");
                    if (_equals_3) {
                        return this._typeReferenceBuilder.typeRef(Integer.class, new JvmTypeReference[0]);
                    }
                    String _identifier_2 = genericType.getIdentifier();
                    boolean _equals_4 = Objects.equal((Object)_identifier_2, (Object)"java.util.EnumSet");
                    if (_equals_4) {
                        JvmTypeReference _type_9 = property.getType();
                        JvmParameterizedTypeReference outer = (JvmParameterizedTypeReference)_type_9;
                        EList _arguments = outer.getArguments();
                        JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_arguments);
                        return this._jvmTypesBuilder.cloneWithProxies(_head);
                    }
                }
            }
        } else {
            return this._typeReferenceBuilder.typeRef(Void.class, new JvmTypeReference[0]);
        }
        JvmTypeReference _type_10 = property.getType();
        JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_type_10);
        _xifexpression = _xblockexpression = this._primitives.asWrapperTypeIfPrimitive(_cloneWithProxies);
        return _xifexpression;
    }

    private MdBundle getBundle(MdBundleMember member) {
        EObject parent = member.eContainer();
        while (!(parent instanceof MdBundle)) {
            EObject _eContainer;
            parent = _eContainer = parent.eContainer();
        }
        return (MdBundle)parent;
    }

    private String getQualifiedName(MdBundleMember member) {
        int _length;
        int _lastIndexOf;
        int _plus;
        String _substring;
        String _name;
        MdBundle bundle = this.getBundle(member);
        EObject _eContainer = bundle.eContainer();
        MdModel model = (MdModel)_eContainer;
        String _elvis = null;
        String _idPrefix = bundle.getIdPrefix();
        _elvis = _idPrefix != null ? _idPrefix : (_name = model.getName());
        String prefix = _elvis;
        String _name_1 = member.getName();
        boolean _equals = Objects.equal((Object)_name_1, (Object)(_substring = prefix.substring(_plus = (_lastIndexOf = prefix.lastIndexOf(".")) + 1, _length = prefix.length())));
        if (_equals) {
            String _substring_1;
            int _lastIndexOf_1 = prefix.lastIndexOf(".");
            prefix = _substring_1 = prefix.substring(0, _lastIndexOf_1);
        }
        String _xifexpression = null;
        Iterable<MdGroup> _groups = this.getGroups(member);
        boolean _isEmpty = IterableExtensions.isEmpty(_groups);
        _xifexpression = _isEmpty ? "" : ".";
        String _plus_1 = String.valueOf(prefix) + _xifexpression;
        Iterable<MdGroup> _groups_1 = this.getGroups(member);
        Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

            public String apply(MdGroup it) {
                return it.getName();
            }
        };
        Iterable _map = IterableExtensions.map(_groups_1, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)".");
        String _plus_2 = String.valueOf(_plus_1) + _join;
        String _plus_3 = String.valueOf(_plus_2) + ".";
        String _name_2 = member.getName();
        return String.valueOf(_plus_3) + _name_2;
    }

    private String getConstantName(MdBundleMember member) {
        String name = member.getName();
        if (name != null) {
            boolean _greaterThan;
            StringBuilder result = new StringBuilder();
            Iterable<MdGroup> _groups = this.getGroups(member);
            Functions.Function1<MdGroup, String> _function = new Functions.Function1<MdGroup, String>(){

                public String apply(MdGroup it) {
                    String _name = it.getName();
                    return MetaDataJvmModelInferrer.this.toUpperCaseWithUnderscores(_name);
                }
            };
            Iterable _map = IterableExtensions.map(_groups, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"_");
            result.append(_join);
            int _length = result.length();
            boolean bl = _greaterThan = _length > 0;
            if (_greaterThan) {
                result.append("_");
            }
            String _upperCaseWithUnderscores = this.toUpperCaseWithUnderscores(name);
            result.append(_upperCaseWithUnderscores);
            return result.toString();
        }
        return null;
    }

    private String toUpperCaseWithUnderscores(String str) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            boolean _and = false;
            boolean _isUpperCase = Character.isUpperCase(c);
            if (!_isUpperCase) {
                _and = false;
            } else {
                boolean bl = _and = i > 0;
            }
            if (_and) {
                result.append("_");
            }
            char _upperCase = Character.toUpperCase(c);
            result.append(_upperCase);
            ++i;
        }
        return result.toString();
    }

    private String getDefaultConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_DEFAULT";
    }

    private String getLowerBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_LOWER_BOUND";
    }

    private String getUpperBoundConstantName(MdOption option) {
        String _constantName = this.getConstantName(option);
        return String.valueOf(_constantName) + "_UPPER_BOUND";
    }

    private String getDependencyConstantName(MdOptionDependency dependency) {
        String _xblockexpression = null;
        EObject _eContainer = dependency.eContainer();
        MdOption option = (MdOption)_eContainer;
        String _constantName = this.getConstantName(option);
        String _plus = String.valueOf(_constantName) + "_DEP_";
        MdOption _target = dependency.getTarget();
        String _constantName_1 = this.getConstantName(_target);
        _xblockexpression = String.valueOf(_plus) + _constantName_1;
        return _xblockexpression;
    }

    private String toCodeString(String s) {
        if (s == null) {
            return "null";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\"");
        String _convertToJavaString = Strings.convertToJavaString((String)s);
        _builder.append((Object)_convertToJavaString, "");
        _builder.append((Object)"\"");
        return _builder.toString();
    }

    private String shrinkWhiteSpace(String s) {
        boolean _greaterThan;
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean shrink = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            boolean _isWhitespace = Character.isWhitespace(c);
            if (_isWhitespace) {
                if (!shrink) {
                    result.append(" ");
                }
                shrink = true;
            } else {
                result.append(c);
                shrink = false;
            }
            ++i;
        }
        boolean _and = false;
        int _length = result.length();
        boolean bl = _greaterThan = _length > 0;
        if (!_greaterThan) {
            _and = false;
        } else {
            boolean _isWhitespace;
            int _length_1 = result.length();
            int _minus = _length_1 - 1;
            char _charAt = result.charAt(_minus);
            _and = _isWhitespace = Character.isWhitespace(_charAt);
        }
        if (_and) {
            int _length_2 = result.length();
            int _minus_1 = _length_2 - 1;
            result.deleteCharAt(_minus_1);
        }
        return result.toString();
    }

    private String trimLines(String s) {
        String _xifexpression = null;
        if (s == null) {
            _xifexpression = null;
        } else {
            String[] _split = s.split("\r?\n");
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    return it.trim();
                }
            };
            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_split)), (Functions.Function1)_function);
            _xifexpression = IterableExtensions.join((Iterable)_map, (CharSequence)"\n");
        }
        return _xifexpression;
    }

    public void infer(EObject model, IJvmDeclaredTypeAcceptor acceptor, boolean isPreIndexingPhase) {
        if (model instanceof MdModel) {
            this._infer((MdModel)model, acceptor, isPreIndexingPhase);
            return;
        }
        if (model != null) {
            this._infer(model, acceptor, isPreIndexingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model, acceptor, isPreIndexingPhase).toString());
    }
}

