/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.compare.ui.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrusrt.umlrt.tooling.compare.umlrt.internal.UMLRTDiff;

public class UMLRTElementsFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            if (input instanceof TreeNode) {
                TreeNode node = (TreeNode)input;
                EObject data = node.getData();
                if (data instanceof UMLRTDiff || UMLRTElementsFilter.containsUMLRTDiffChild(node)) {
                    return false;
                }
                if (data instanceof Diff) {
                    Diff diff = (Diff)data;
                    boolean refines = Iterables.any((Iterable)diff.getRefines(), (Predicate)Predicates.instanceOf(UMLDiff.class));
                    return refines;
                }
            }
            return false;
        }
    };

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    private static boolean containsUMLRTDiffChild(TreeNode parentNode) {
        for (TreeNode node : parentNode.getChildren()) {
            if (node.getData() instanceof UMLRTDiff) {
                return true;
            }
            if (!UMLRTElementsFilter.containsUMLRTDiffChild(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        if (scope != null) {
            for (String nsURI : scope.getNsURIs()) {
                if (!nsURI.matches("http://www\\.eclipse\\.org/papyrus.*/umlrt")) continue;
                return true;
            }
        }
        return false;
    }
}

