/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionModel
implements ISelectionModel {
    protected final SelectionLayer selectionLayer;
    private boolean multipleSelectionAllowed;
    private final List<Rectangle> selections;
    private final ReadWriteLock selectionsLock;
    private boolean clearSelectionOnChange = true;

    public SelectionModel(SelectionLayer selectionLayer) {
        this(selectionLayer, true);
    }

    public SelectionModel(SelectionLayer selectionLayer, boolean multipleSelectionAllowed) {
        this.selectionLayer = selectionLayer;
        this.multipleSelectionAllowed = multipleSelectionAllowed;
        this.selections = new LinkedList<Rectangle>();
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isMultipleSelectionAllowed() {
        return this.multipleSelectionAllowed;
    }

    @Override
    public void setMultipleSelectionAllowed(boolean multipleSelectionAllowed) {
        this.multipleSelectionAllowed = multipleSelectionAllowed;
    }

    @Override
    public void addSelection(int columnPosition, int rowPosition) {
        this.addSelectionIntoList(new Rectangle(columnPosition, rowPosition, 1, 1));
    }

    @Override
    public void addSelection(Rectangle range) {
        if (range != null) {
            this.addSelectionIntoList(range);
        }
    }

    private void addSelectionIntoList(Rectangle selection) {
        this.selectionsLock.writeLock().lock();
        try {
            if (this.multipleSelectionAllowed) {
                ArrayList<Rectangle> itemsToRemove = null;
                for (Rectangle r : this.selections) {
                    if (!selection.intersects(r)) continue;
                    if (r.equals((Object)selection)) break;
                    Rectangle intersection = selection.intersection(r);
                    if (intersection.equals((Object)r)) {
                        if (itemsToRemove == null) {
                            itemsToRemove = new ArrayList<Rectangle>();
                        }
                        itemsToRemove.add(r);
                        continue;
                    }
                    if (intersection.equals((Object)selection)) break;
                }
                if (itemsToRemove != null) {
                    this.selections.removeAll(itemsToRemove);
                }
            } else {
                this.selections.clear();
                selection.height = 1;
                selection.width = 1;
            }
            this.selections.add(selection);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selections.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(int columnPosition, int rowPosition) {
        this.clearSelection(new Rectangle(columnPosition, rowPosition, 1, 1));
    }

    @Override
    public void clearSelection(Rectangle removedSelection) {
        LinkedList<Rectangle> removedItems = new LinkedList<Rectangle>();
        LinkedList<Rectangle> addedItems = new LinkedList<Rectangle>();
        this.selectionsLock.readLock().lock();
        try {
            for (Rectangle r : this.selections) {
                Rectangle bottomSelection;
                Rectangle leftSelection;
                Rectangle rightSelection;
                if (!r.intersects(removedSelection)) continue;
                Rectangle intersection = removedSelection.intersection(r);
                removedItems.add(r);
                Rectangle topSelection = this.getTopSelection(intersection, r);
                if (topSelection != null) {
                    addedItems.add(topSelection);
                }
                if ((rightSelection = this.getRightSelection(intersection, r)) != null) {
                    addedItems.add(rightSelection);
                }
                if ((leftSelection = this.getLeftSelection(intersection, r)) != null) {
                    addedItems.add(leftSelection);
                }
                if ((bottomSelection = this.getBottomSelection(intersection, r)) == null) continue;
                addedItems.add(bottomSelection);
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        if (removedItems.size() > 0) {
            this.selectionsLock.writeLock().lock();
            try {
                this.selections.removeAll(removedItems);
            }
            finally {
                this.selectionsLock.writeLock().unlock();
            }
            removedItems.clear();
        }
        if (addedItems.size() > 0) {
            this.selectionsLock.writeLock().lock();
            try {
                this.selections.addAll(addedItems);
            }
            finally {
                this.selectionsLock.writeLock().unlock();
            }
            addedItems.clear();
        }
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selections.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<Rectangle> getSelections() {
        return this.selections;
    }

    @Override
    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
            if (cell != null) {
                Rectangle cellRectangle = new Rectangle(cell.getOriginColumnPosition(), cell.getOriginRowPosition(), cell.getColumnSpan(), cell.getRowSpan());
                for (Rectangle selectionRectangle : this.selections) {
                    if (!selectionRectangle.intersects(cellRectangle)) continue;
                    return true;
                }
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getSelectedColumnPositions() {
        TreeSet<Integer> selectedColumns = new TreeSet<Integer>();
        this.selectionsLock.readLock().lock();
        int columnCount = this.selectionLayer.getColumnCount();
        try {
            for (Rectangle r : this.selections) {
                int startColumn = r.x;
                if (startColumn >= columnCount) continue;
                int numColumns = r.x + r.width <= columnCount ? r.width : columnCount - r.x;
                int column = startColumn;
                while (column < startColumn + numColumns) {
                    selectedColumns.add(column);
                    ++column;
                }
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return ObjectUtils.asIntArray(selectedColumns);
    }

    @Override
    public boolean isColumnPositionSelected(int columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            int[] nArray = this.getSelectedColumnPositions();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                if (column == columnPosition) {
                    return true;
                }
                ++n2;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getFullySelectedColumnPositions(int columnHeight) {
        int[] selectedColumns = this.getSelectedColumnPositions();
        int[] columnsToHide = new int[selectedColumns.length];
        int index = 0;
        int[] nArray = selectedColumns;
        int n = selectedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int columnPosition = nArray[n2];
            if (this.isColumnPositionFullySelected(columnPosition, columnHeight)) {
                columnsToHide[index++] = columnPosition;
            }
            ++n2;
        }
        return index > 0 ? ArrayUtil.subarray(columnsToHide, 0, index) : new int[]{};
    }

    @Override
    public boolean isColumnPositionFullySelected(int columnPosition, int columnHeight) {
        this.selectionsLock.readLock().lock();
        try {
            ArrayList<Rectangle> selectedRectanglesInColumn = new ArrayList<Rectangle>();
            for (Rectangle r : this.selections) {
                if (columnPosition < r.x || columnPosition >= r.x + r.width) continue;
                selectedRectanglesInColumn.add(new Rectangle(columnPosition, r.y, 1, r.height));
            }
            if (selectedRectanglesInColumn.isEmpty()) {
                return false;
            }
            this.sortByY(selectedRectanglesInColumn);
            Rectangle finalRectangle = new Rectangle(columnPosition, ((Rectangle)selectedRectanglesInColumn.get((int)0)).y, 0, 0);
            int i = 0;
            while (i < selectedRectanglesInColumn.size()) {
                Rectangle rectangle = (Rectangle)selectedRectanglesInColumn.get(i);
                if (!this.contains(finalRectangle, rectangle)) {
                    if (i > 0) {
                        Rectangle previousRect = (Rectangle)selectedRectanglesInColumn.get(i - 1);
                        if (rectangle.union((Rectangle)previousRect).height > rectangle.height + previousRect.height) {
                            return false;
                        }
                    }
                    finalRectangle = finalRectangle.union(rectangle);
                }
                ++i;
            }
            boolean bl = finalRectangle.height >= columnHeight;
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int getSelectedRowCount() {
        Set<Range> selectedRows = this.getSelectedRowPositions();
        int count = 0;
        for (Range range : selectedRows) {
            count += range.end - range.start;
        }
        return count;
    }

    @Override
    public Set<Range> getSelectedRowPositions() {
        HashSet<Range> selectedRowsRange = new HashSet<Range>();
        this.selectionsLock.readLock().lock();
        int rowCount = this.selectionLayer.getRowCount();
        try {
            for (Rectangle r : this.selections) {
                if (r.y >= rowCount) continue;
                int height = r.y + r.height <= rowCount ? r.height : rowCount - r.y;
                selectedRowsRange.add(new Range(r.y, r.y + height));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        ArrayList<Range> ranges = new ArrayList<Range>(selectedRowsRange);
        Range.sortByStart(ranges);
        ArrayList<Range> uniqueRanges = new ArrayList<Range>();
        int i = 0;
        while (i < ranges.size()) {
            if (i > 0) {
                Range currentRange;
                Range previousRange = ranges.get(i - 1);
                if (previousRange.overlap(currentRange = ranges.get(i)) || previousRange.end == currentRange.start) {
                    int largerRangeEnd;
                    ((Range)uniqueRanges.get((int)(uniqueRanges.size() - 1))).end = largerRangeEnd = previousRange.end > currentRange.end ? previousRange.end : currentRange.end;
                    ranges.get((int)i).end = largerRangeEnd;
                } else {
                    uniqueRanges.add(ranges.get(i));
                }
            } else {
                uniqueRanges.add(ranges.get(i));
            }
            ++i;
        }
        return new HashSet<Range>(uniqueRanges);
    }

    @Override
    public boolean isRowPositionSelected(int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            for (Range rowRange : this.getSelectedRowPositions()) {
                if (!rowRange.contains(rowPosition)) continue;
                return true;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getFullySelectedRowPositions(int rowWidth) {
        Set<Range> selectedRows = this.getSelectedRowPositions();
        int[] fullySelectedRows = new int[this.getSelectedRowCount()];
        int index = 0;
        for (Range rowRange : selectedRows) {
            int i = rowRange.start;
            while (i < rowRange.end) {
                if (this.isRowPositionFullySelected(i, rowWidth)) {
                    fullySelectedRows[index++] = i;
                }
                ++i;
            }
        }
        return index > 0 ? ArrayUtil.subarray(fullySelectedRows, 0, index) : new int[]{};
    }

    @Override
    public boolean isRowPositionFullySelected(int rowPosition, int rowWidth) {
        this.selectionsLock.readLock().lock();
        try {
            ArrayList<Rectangle> selectedRectanglesInRow = new ArrayList<Rectangle>();
            for (Rectangle r : this.selections) {
                if (rowPosition < r.y || rowPosition >= r.y + r.height) continue;
                selectedRectanglesInRow.add(new Rectangle(r.x, rowPosition, r.width, 1));
            }
            if (selectedRectanglesInRow.isEmpty()) {
                return false;
            }
            this.sortByX(selectedRectanglesInRow);
            Rectangle finalRectangle = new Rectangle(((Rectangle)selectedRectanglesInRow.get((int)0)).x, rowPosition, 0, 0);
            int i = 0;
            while (i < selectedRectanglesInRow.size()) {
                Rectangle rectangle = (Rectangle)selectedRectanglesInRow.get(i);
                if (!this.contains(finalRectangle, rectangle)) {
                    if (i > 0) {
                        Rectangle previousRect = (Rectangle)selectedRectanglesInRow.get(i - 1);
                        if (rectangle.union((Rectangle)previousRect).width > rectangle.width + previousRect.width) {
                            return false;
                        }
                    }
                    finalRectangle = finalRectangle.union(rectangle);
                }
                ++i;
            }
            boolean bl = finalRectangle.width >= rowWidth;
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    protected boolean contains(Rectangle containerRectangle, Rectangle rectangle) {
        Rectangle union = containerRectangle.union(rectangle);
        return union.equals((Object)containerRectangle);
    }

    protected void sortByX(List<Rectangle> selectionRectanglesInRow) {
        Collections.sort(selectionRectanglesInRow, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle rectangle1, Rectangle rectangle2) {
                return new Integer(rectangle1.x).compareTo(new Integer(rectangle2.x));
            }
        });
    }

    protected void sortByY(List<Rectangle> selectionRectanglesInColumn) {
        Collections.sort(selectionRectanglesInColumn, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle rectangle1, Rectangle rectangle2) {
                return new Integer(rectangle1.y).compareTo(new Integer(rectangle2.y));
            }
        });
    }

    private Rectangle getLeftSelection(Rectangle intersection, Rectangle selection) {
        if (intersection.x > selection.x) {
            Rectangle leftSelection = new Rectangle(selection.x, selection.y, intersection.x - selection.x, selection.height);
            return leftSelection;
        }
        return null;
    }

    private Rectangle getRightSelection(Rectangle intersection, Rectangle selection) {
        int newX = intersection.x + intersection.width;
        if (newX < selection.x + selection.width) {
            Rectangle rightSelection = new Rectangle(newX, selection.y, selection.x + selection.width - newX, selection.height);
            return rightSelection;
        }
        return null;
    }

    private Rectangle getTopSelection(Rectangle intersection, Rectangle selection) {
        if (intersection.y > selection.y) {
            Rectangle topSelection = new Rectangle(selection.x, selection.y, selection.width, intersection.y - selection.y);
            return topSelection;
        }
        return null;
    }

    private Rectangle getBottomSelection(Rectangle intersection, Rectangle selection) {
        int newY = intersection.y + intersection.height;
        if (newY < selection.y + selection.height) {
            Rectangle bottomSelection = new Rectangle(selection.x, newY, selection.width, selection.y + selection.height - newY);
            return bottomSelection;
        }
        return null;
    }

    public String toString() {
        this.selectionsLock.readLock().lock();
        try {
            String string = this.selections.toString();
            return string;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        block12: {
            PositionCoordinate[] coords;
            block13: {
                Range changedRange;
                Collection<Rectangle> rectangles;
                if (!this.clearSelectionOnChange) break block13;
                if (event.isHorizontalStructureChanged()) {
                    if (event.getColumnDiffs() == null) {
                        rectangles = event.getChangedPositionRectangles();
                        for (Rectangle rectangle : rectangles) {
                            changedRange = new Range(rectangle.y, rectangle.y + rectangle.height);
                            if (!this.selectedColumnModified(changedRange)) continue;
                            this.selectionLayer.clear();
                            break;
                        }
                    } else {
                        for (StructuralDiff diff : event.getColumnDiffs()) {
                            if (diff.getDiffType() == StructuralDiff.DiffTypeEnum.CHANGE || !this.selectedColumnModified(diff.getBeforePositionRange())) continue;
                            this.selectionLayer.clear();
                            break;
                        }
                    }
                }
                if (!event.isVerticalStructureChanged()) break block12;
                if (event.getRowDiffs() == null) {
                    rectangles = event.getChangedPositionRectangles();
                    for (Rectangle rectangle : rectangles) {
                        changedRange = new Range(rectangle.y, rectangle.y + rectangle.height);
                        if (!this.selectedRowModified(changedRange)) continue;
                        this.selectionLayer.clear();
                        break block12;
                    }
                } else {
                    for (StructuralDiff diff : event.getRowDiffs()) {
                        if (diff.getDiffType() == StructuralDiff.DiffTypeEnum.CHANGE || !this.selectedRowModified(diff.getBeforePositionRange())) continue;
                        this.selectionLayer.clear();
                        break block12;
                    }
                }
                break block12;
            }
            PositionCoordinate[] positionCoordinateArray = coords = this.selectionLayer.getSelectedCellPositions();
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                PositionCoordinate coord = positionCoordinateArray[n2];
                if (coord.getColumnPosition() >= this.selectionLayer.getColumnCount() || coord.getRowPosition() >= this.selectionLayer.getRowCount()) {
                    this.selectionLayer.clearSelection(coord.getColumnPosition(), coord.getRowPosition());
                }
                ++n2;
            }
        }
    }

    private boolean selectedRowModified(Range changedRange) {
        Set<Range> selectedRows = this.selectionLayer.getSelectedRowPositions();
        for (Range rowRange : selectedRows) {
            if (!rowRange.overlap(changedRange)) continue;
            return true;
        }
        return this.selectionLayer.getRowCount() == 0 && !this.isEmpty();
    }

    private boolean selectedColumnModified(Range changedRange) {
        int i = changedRange.start;
        while (i <= changedRange.end) {
            if (this.isColumnPositionSelected(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setClearSelectionOnChange(boolean clearSelectionOnChange) {
        this.clearSelectionOnChange = clearSelectionOnChange;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }
}

