/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class GMFDiagramViewTypeHelper
implements IViewTypeHelper {
    private static final String EXTENSION_PAPYRUS_DIAGRAM = "org.eclipse.papyrus.infra.ui.papyrusDiagram";
    private Map<PapyrusView, DiagramPrototype> cache;
    private Map<String, Implementation> implementations;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)ConfigurationPackage.eINSTANCE.getPapyrusDiagram());
    }

    public boolean isSupported(EObject view) {
        return view instanceof Diagram;
    }

    public ViewPrototype getPrototypeFor(PapyrusView configuration) {
        if (!(configuration instanceof PapyrusDiagram)) {
            return null;
        }
        if (this.implementations == null) {
            this.buildImplementationCache();
        }
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusView, DiagramPrototype>();
        }
        if (this.cache.containsKey(configuration)) {
            return this.cache.get(configuration);
        }
        if (!this.implementations.containsKey(configuration.getImplementationID())) {
            return null;
        }
        Implementation impl = this.implementations.get(configuration.getImplementationID());
        if (ViewPrototype.isNatural((PapyrusView)configuration)) {
            NakedViewPrototype proto = new NakedViewPrototype(configuration, impl.language, impl.command, impl.name, impl.icon);
            this.cache.put(configuration, proto);
            return proto;
        }
        DiagramPrototype proto = new DiagramPrototype(configuration, impl.language, impl.command);
        this.cache.put(configuration, proto);
        return proto;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!(view instanceof Diagram)) {
            return null;
        }
        return DiagramUtils.getPrototype((Diagram)view);
    }

    private void buildImplementationCache() {
        this.implementations = new HashMap<String, Implementation>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_PAPYRUS_DIAGRAM);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i != extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                if (elements[j].getName().equals("creationCommand")) {
                    try {
                        Object obj = elements[j].createExecutableExtension("creationCommandClass");
                        if (obj instanceof AbstractPapyrusGmfCreateDiagramCommandHandler) {
                            AbstractPapyrusGmfCreateDiagramCommandHandler command = (AbstractPapyrusGmfCreateDiagramCommandHandler)((Object)obj);
                            String label = elements[j].getAttribute("label");
                            String icon = elements[j].getAttribute("icon");
                            String language = elements[j].getAttribute("language");
                            String implID = command.getCreatedDiagramType();
                            if (!icon.startsWith("platform:/")) {
                                icon = "platform:/plugin/" + extensions[i].getContributor().getName() + "/" + icon;
                            }
                            if (!this.implementations.containsKey(implID)) {
                                this.implementations.put(implID, new Implementation(label, icon, language, command));
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static class Implementation {
        public final String name;
        public final String icon;
        public final String language;
        public final AbstractPapyrusGmfCreateDiagramCommandHandler command;

        public Implementation(String name, String icon, String language, AbstractPapyrusGmfCreateDiagramCommandHandler command) {
            this.name = name;
            this.icon = icon;
            this.language = language;
            this.command = command;
        }
    }

    private static class NakedViewPrototype
    extends DiagramPrototype {
        private final String label;
        private final String icon;

        public NakedViewPrototype(PapyrusView configuration, String category, AbstractPapyrusGmfCreateDiagramCommandHandler command, String label, String icon) {
            super(configuration, category, command);
            this.label = label;
            this.icon = icon;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconURI() {
            return this.icon;
        }
    }
}

