/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.tooltip.AbstractTooltipProvider;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeChangeTooltipProvider
extends AbstractTooltipProvider<AttributeChange> {
    public AttributeChangeTooltipProvider(ComposedAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.labelProvider = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
    }

    @Override
    public String getTooltip(MergeMode mode) throws IllegalArgumentException {
        String tooltip;
        AttributeChange diff = (AttributeChange)this.target;
        boolean isFromLeft = this.isFromLeft(diff);
        switch (diff.getKind()) {
            case DELETE: {
                tooltip = this.setDeleteNonContainmentTooltip(mode, diff, isFromLeft);
                break;
            }
            case ADD: {
                tooltip = this.setAddAttributeTooltip(mode, diff, isFromLeft);
                break;
            }
            case MOVE: {
                tooltip = this.setMovePositionTooltip(mode, diff, isFromLeft);
                break;
            }
            case CHANGE: {
                if (this.isUnset(diff, this.getChangedValueFromModel(diff))) {
                    tooltip = this.setUnsetTooltip(mode, diff, isFromLeft);
                    break;
                }
                tooltip = this.setSetTooltip(mode, diff, isFromLeft);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return tooltip;
    }

    private String getChangedValueFromModel(AttributeChange diff) {
        EObject changedContainer;
        EAttribute attribute = diff.getAttribute();
        switch (diff.getSource()) {
            case LEFT: {
                changedContainer = diff.getMatch().getLeft();
                break;
            }
            case RIGHT: {
                changedContainer = diff.getMatch().getRight();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (changedContainer == null) {
            return null;
        }
        return String.valueOf(ReferenceUtil.safeEGet((EObject)changedContainer, (EStructuralFeature)attribute));
    }

    private boolean isUnset(AttributeChange diff, Object targetValue) {
        Object defaultValue = diff.getAttribute().getDefaultValue();
        return targetValue == null || targetValue.equals(defaultValue) || defaultValue == null && "".equals(targetValue);
    }

    private String setAddAttributeTooltip(MergeMode mode, AttributeChange diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.left.leftToRight", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.right.leftToRight", value, containerValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.left.rightToLeft", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.right.rightToLeft", value, containerValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.left.accept", value, containerValue);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.right.accept", value, containerValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.left.reject", value, containerValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.attribute.right.reject", value, containerValue);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }
}

