/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.linklf.policy.graphicalnode;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.tooling.runtime.linklf.policies.LinksLFGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.communication.custom.helper.CommunicationUtil;
import org.eclipse.papyrus.uml.diagram.communication.custom.helper.MessageHelper;
import org.eclipse.papyrus.uml.diagram.communication.edit.parts.LifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.communication.providers.UMLElementTypes;

public class CommunicationLinksLFEditPolicy
extends LinksLFGraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command command = super.getConnectionCompleteCommand(request);
        if (command == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        for (Object obj : cc) {
            if (!(obj instanceof SetConnectionBendpointsCommand)) continue;
            SetConnectionBendpointsCommand sbbCommand = (SetConnectionBendpointsCommand)obj;
            PointList pointList = sbbCommand.getNewPointList();
            request.getExtendedData().put("Source model container", CommunicationUtil.findInteractionFragmentAt((Point)pointList.getFirstPoint(), (EditPart)this.getHost()));
            request.getExtendedData().put("Target model container", CommunicationUtil.findInteractionFragmentAt((Point)pointList.getLastPoint(), (EditPart)this.getHost()));
        }
        return command;
    }

    public Command getCommand(Request request) {
        if ("connection end".equals(request.getType()) && request instanceof CreateConnectionViewAndElementRequest) {
            Command c = this.getConnectionAndRelationshipCompleteCommand((CreateConnectionViewAndElementRequest)request);
            CreateElementRequestAdapter requestAdapter = ((CreateConnectionViewAndElementRequest)request).getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
            CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
            if (UMLElementTypes.Path_Edge.equals(createElementRequest.getElementType())) {
                EditPart sourceEditPart = ((CreateConnectionViewAndElementRequest)request).getSourceEditPart();
                EditPart targetEditPart = ((CreateConnectionViewAndElementRequest)request).getTargetEditPart();
                MessageHelper messageHelper = new MessageHelper(this.getEditingDomain());
                if (sourceEditPart instanceof LifelineEditPartCN && targetEditPart instanceof LifelineEditPartCN && CommunicationUtil.verifyIfLifelinesEPConnected((EditPart)sourceEditPart, (EditPart)targetEditPart) != null) {
                    ConnectionEditPart link = CommunicationUtil.verifyIfLifelinesEPConnected((EditPart)sourceEditPart, (EditPart)targetEditPart);
                    return messageHelper.getCommand((CreateConnectionViewAndElementRequest)request, c, link);
                }
            }
        }
        return super.getCommand(request);
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }
}

