/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.UMLPackage;

public class ConnectorLabelParser
extends NamedElementLabelParser {
    protected static final String NAME_FORMAT = "%s";
    protected static final String TYPE_FORMAT = "%s: %s";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Connector) {
            Connector connector = (Connector)eObject;
            if (maskValues.contains("name") && connector.isSetName()) {
                String name = connector.getName();
                result = String.format(NAME_FORMAT, name);
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (connector.getType() != null) {
                    type = connector.getType().getName();
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Connector) {
            Connector semElement = (Connector)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("undefinedType", "Show <Undefined> type");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name", "type");
    }
}

