/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.FeatureCallExpImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.pivot.library.collection.OrderedCollectionAtOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanAndOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanNotOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class OperationCallExpImpl
extends FeatureCallExpImpl
implements OperationCallExp {
    protected static final boolean IS_VIRTUAL_EDEFAULT = true;
    protected static final int IS_VIRTUAL_EFLAG = 4096;
    protected EList<OCLExpression> ownedArguments;
    protected Operation referredOperation;

    protected OperationCallExpImpl() {
        this.eFlags |= 0x1000;
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.OPERATION_CALL_EXP;
    }

    @Override
    public boolean isIsVirtual() {
        return (this.eFlags & 0x1000) != 0;
    }

    @Override
    public void setIsVirtual(boolean newIsVirtual) {
        boolean oldIsVirtual;
        boolean bl = oldIsVirtual = (this.eFlags & 0x1000) != 0;
        this.eFlags = newIsVirtual ? (this.eFlags |= 0x1000) : (this.eFlags &= 0xFFFFEFFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldIsVirtual, newIsVirtual));
        }
    }

    @Override
    public @NonNull List<OCLExpression> getOwnedArguments() {
        if (this.ownedArguments == null) {
            this.ownedArguments = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 14);
        }
        return this.ownedArguments;
    }

    @Override
    public Operation getReferredOperation() {
        if (this.referredOperation != null && this.referredOperation.eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = (Operation)this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldReferredOperation, (Object)this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public Operation basicGetReferredOperation() {
        return this.referredOperation;
    }

    @Override
    public void setReferredOperation(Operation newReferredOperation) {
        Operation oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldReferredOperation, (Object)this.referredOperation));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetOwnedSource(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getOwnedArguments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 8: {
                return this.getTypeValue();
            }
            case 9: {
                return this.isIsImplicit();
            }
            case 10: {
                return this.isIsSafe();
            }
            case 11: {
                return this.getOwnedSource();
            }
            case 12: {
                return this.isIsPre();
            }
            case 13: {
                return this.isIsVirtual();
            }
            case 14: {
                return this.getOwnedArguments();
            }
            case 15: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
            case 8: {
                this.setTypeValue((Type)newValue);
                return;
            }
            case 9: {
                this.setIsImplicit((Boolean)newValue);
                return;
            }
            case 10: {
                this.setIsSafe((Boolean)newValue);
                return;
            }
            case 11: {
                this.setOwnedSource((OCLExpression)newValue);
                return;
            }
            case 12: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 13: {
                this.setIsVirtual((Boolean)newValue);
                return;
            }
            case 14: {
                this.getOwnedArguments().clear();
                this.getOwnedArguments().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setReferredOperation((Operation)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
            case 8: {
                this.setTypeValue(null);
                return;
            }
            case 9: {
                this.setIsImplicit(false);
                return;
            }
            case 10: {
                this.setIsSafe(false);
                return;
            }
            case 11: {
                this.setOwnedSource(null);
                return;
            }
            case 12: {
                this.setIsPre(false);
                return;
            }
            case 13: {
                this.setIsVirtual(true);
                return;
            }
            case 14: {
                this.getOwnedArguments().clear();
                return;
            }
            case 15: {
                this.setReferredOperation(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
            case 8: {
                return this.typeValue != null;
            }
            case 9: {
                return (this.eFlags & 0x200) != 0;
            }
            case 10: {
                return (this.eFlags & 0x400) != 0;
            }
            case 11: {
                return this.ownedSource != null;
            }
            case 12: {
                return (this.eFlags & 0x800) != 0;
            }
            case 13: {
                return (this.eFlags & 0x1000) == 0;
            }
            case 14: {
                return this.ownedArguments != null && !this.ownedArguments.isEmpty();
            }
            case 15: {
                return this.referredOperation != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.getReferredElement();
            }
            case 5: {
                return this.validateArgumentCount((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateArgumentTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitOperationCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredOperation();
    }

    @Override
    public boolean validateArgumentTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_5;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"OperationCallExp::ArgumentTypeIsConformant");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_5 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_forAll;
            try {
                boolean forAll;
                Class safe_owningClass_source;
                Object CAUGHT_operation_0;
                OrderedSetValue safe_ownedParameters_source;
                Object CAUGHT_operation;
                @Nullable Operation operation = this.getReferredOperation();
                try {
                    CAUGHT_operation = operation;
                }
                catch (Exception e) {
                    CAUGHT_operation = ValueUtil.createInvalidValue(e);
                }
                @NonNull Boolean symbol_0 = CAUGHT_operation == null;
                if (symbol_0 == Boolean.TRUE) {
                    safe_ownedParameters_source = null;
                } else {
                    OrderedSetValue BOXED_ownedParameters;
                    assert (operation != null);
                    @NonNull List<Parameter> ownedParameters = operation.getOwnedParameters();
                    safe_ownedParameters_source = BOXED_ownedParameters = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, ownedParameters);
                }
                try {
                    CAUGHT_operation_0 = operation;
                }
                catch (Exception e) {
                    CAUGHT_operation_0 = ValueUtil.createInvalidValue(e);
                }
                @NonNull Boolean symbol_1 = CAUGHT_operation_0 == null;
                if (symbol_1 == Boolean.TRUE) {
                    safe_owningClass_source = null;
                } else {
                    Class owningClass;
                    assert (operation != null);
                    safe_owningClass_source = owningClass = operation.getOwningClass();
                }
                @NonNull List<OCLExpression> ownedArguments = this.getOwnedArguments();
                @NonNull OrderedSetValue BOXED_ownedArguments = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, ownedArguments);
                @NonNull IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedArguments);
                @NonNull IntegerRange RNG = ValueUtil.createRange(PivotTables.INT_1, size);
                @NonNull SequenceValue Sequence = ValueUtil.createSequenceRange(PivotTables.SEQ_PRIMid_Integer, RNG);
                @Nullable Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                @NonNull Iterator<Object> ITERATOR_i = Sequence.iterator();
                while (true) {
                    Serializable CAUGHT_conformsTo;
                    if (!ITERATOR_i.hasNext()) {
                        if (accumulator == ValueUtil.TRUE_VALUE) {
                            forAll = ValueUtil.TRUE_VALUE;
                            break;
                        }
                        throw (InvalidValueException)accumulator;
                    }
                    @NonNull IntegerValue i = (IntegerValue)ITERATOR_i.next();
                    try {
                        Type safe_type_source_0;
                        Object CAUGHT_argument;
                        Type requiredType;
                        Boolean safe_isTypeof_source;
                        Object CAUGHT_parameter_0;
                        Type safe_type_source;
                        Object CAUGHT_parameter;
                        @Nullable OCLExpression argument = (OCLExpression)OrderedCollectionAtOperation.INSTANCE.evaluate(BOXED_ownedArguments, i);
                        @Nullable Parameter parameter = (Parameter)OrderedCollectionAtOperation.INSTANCE.evaluate(safe_ownedParameters_source, i);
                        try {
                            CAUGHT_parameter = parameter;
                        }
                        catch (Exception e) {
                            CAUGHT_parameter = ValueUtil.createInvalidValue(e);
                        }
                        @NonNull Boolean symbol_2 = CAUGHT_parameter == null;
                        if (symbol_2 == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type;
                            assert (parameter != null);
                            safe_type_source = type = parameter.getType();
                        }
                        try {
                            CAUGHT_parameter_0 = parameter;
                        }
                        catch (Exception e) {
                            CAUGHT_parameter_0 = ValueUtil.createInvalidValue(e);
                        }
                        @NonNull Boolean symbol_3 = CAUGHT_parameter_0 == null;
                        if (symbol_3 == Boolean.TRUE) {
                            safe_isTypeof_source = null;
                        } else {
                            assert (parameter != null);
                            boolean isTypeof = parameter.isIsTypeof();
                            safe_isTypeof_source = isTypeof;
                        }
                        if (safe_isTypeof_source == null) {
                            throw new InvalidValueException("Null if condition", new Object[0]);
                        }
                        if (safe_isTypeof_source.booleanValue()) {
                            Class TYP_Class;
                            requiredType = TYP_Class = idResolver.getClass(PivotTables.CLSSid_Class, null);
                        } else {
                            if (safe_type_source == null) {
                                throw new InvalidValueException("Null source for 'pivot::Type::specializeIn(CallExp[1],Type[1]) : Type[1]'", new Object[0]);
                            }
                            @NonNull Type specializeIn = safe_type_source.specializeIn(this, safe_owningClass_source);
                            requiredType = specializeIn;
                        }
                        try {
                            CAUGHT_argument = argument;
                        }
                        catch (Exception e) {
                            CAUGHT_argument = ValueUtil.createInvalidValue(e);
                        }
                        @NonNull Boolean symbol_4 = CAUGHT_argument == null;
                        if (symbol_4 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_0;
                            assert (argument != null);
                            safe_type_source_0 = type_0 = argument.getType();
                        }
                        boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)safe_type_source_0, (Object)requiredType);
                        CAUGHT_conformsTo = Boolean.valueOf(conformsTo);
                    }
                    catch (Exception e) {
                        CAUGHT_conformsTo = ValueUtil.createInvalidValue(e);
                    }
                    if (CAUGHT_conformsTo == ValueUtil.FALSE_VALUE) {
                        forAll = ValueUtil.FALSE_VALUE;
                        break;
                    }
                    if (CAUGHT_conformsTo == ValueUtil.TRUE_VALUE) continue;
                    if (CAUGHT_conformsTo instanceof InvalidValueException) {
                        accumulator = CAUGHT_conformsTo;
                        continue;
                    }
                    accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                }
                CAUGHT_forAll = Boolean.valueOf(forAll);
            }
            catch (Exception e) {
                CAUGHT_forAll = ValueUtil.createInvalidValue(e);
            }
            symbol_5 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::ArgumentTypeIsConformant", this, null, diagnostics, context, null, severity_0, CAUGHT_forAll, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_5;
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        IntegerValue severity_0;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)(severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"OperationCallExp::SafeSourceCanBeNull")), (Object)PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_not;
                Serializable CAUGHT_and;
                try {
                    Serializable CAUGHT_isSafe;
                    Serializable CAUGHT_ne;
                    try {
                        @Nullable OCLExpression ownedSource = this.getOwnedSource();
                        boolean ne = ownedSource != null;
                        CAUGHT_ne = Boolean.valueOf(ne);
                    }
                    catch (Exception e) {
                        CAUGHT_ne = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        @Nullable Boolean isSafe = this.isIsSafe();
                        CAUGHT_isSafe = isSafe;
                    }
                    catch (Exception e) {
                        CAUGHT_isSafe = ValueUtil.createInvalidValue(e);
                    }
                    @Nullable Boolean and = BooleanAndOperation.INSTANCE.evaluate(CAUGHT_ne, CAUGHT_isSafe);
                    CAUGHT_and = and;
                }
                catch (Exception e) {
                    CAUGHT_and = ValueUtil.createInvalidValue(e);
                }
                try {
                    Boolean safe_isRequired_source;
                    Object CAUGHT_ownedSource_0;
                    @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource_0 = ownedSource_0;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                    }
                    @NonNull Boolean symbol_0 = CAUGHT_ownedSource_0 == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_isRequired_source = null;
                    } else {
                        assert (ownedSource_0 != null);
                        boolean isRequired = ownedSource_0.isIsRequired();
                        safe_isRequired_source = isRequired;
                    }
                    @Nullable Boolean not = BooleanNotOperation.INSTANCE.evaluate(safe_isRequired_source);
                    CAUGHT_not = not;
                }
                catch (Exception e) {
                    CAUGHT_not = ValueUtil.createInvalidValue(e);
                }
                @Nullable Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_and, CAUGHT_not);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateArgumentCount(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        @NonNull Executor executor = PivotUtilInternal.getExecutor(this);
        @NonNull IdResolver idResolver = executor.getIdResolver();
        @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)"OperationCallExp::ArgumentCount");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                OrderedSetValue safe_ownedParameters_source;
                Object CAUGHT_referredOperation;
                @NonNull List<OCLExpression> ownedArguments = this.getOwnedArguments();
                @NonNull OrderedSetValue BOXED_ownedArguments = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_OCLExpression, ownedArguments);
                @NonNull IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedArguments);
                @Nullable Operation referredOperation = this.getReferredOperation();
                try {
                    CAUGHT_referredOperation = referredOperation;
                }
                catch (Exception e) {
                    CAUGHT_referredOperation = ValueUtil.createInvalidValue(e);
                }
                @NonNull Boolean symbol_0 = CAUGHT_referredOperation == null;
                if (symbol_0 == Boolean.TRUE) {
                    safe_ownedParameters_source = null;
                } else {
                    OrderedSetValue BOXED_ownedParameters;
                    assert (referredOperation != null);
                    @NonNull List<Parameter> ownedParameters = referredOperation.getOwnedParameters();
                    safe_ownedParameters_source = BOXED_ownedParameters = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Parameter, ownedParameters);
                }
                @NonNull IntegerValue size_0 = CollectionSizeOperation.INSTANCE.evaluate(safe_ownedParameters_source);
                boolean status = size.equals(size_0);
                CAUGHT_status = Boolean.valueOf(status);
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "OperationCallExp::ArgumentCount", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }
}

