/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextEditor;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ToggleCBreakpointTester
extends PropertyTester {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object element;
        List list;
        if ("isCEditorSupportsCBreakpoint".equals(property) && receiver instanceof CEditor) {
            if (!CDebugUtils.isCustomToggleBreakpointFactory()) {
                return true;
            }
            CEditor editor = (CEditor)receiver;
            IWorkingCopy cElement = editor.getInputCElement();
            if (cElement == null) return false;
            ICProject cproject = cElement.getCProject();
            if (cproject == null) return true;
            IResource resource = cElement.getResource();
            if (resource == null || !resource.exists()) {
                return true;
            }
            if (!CDebugUtils.isStandardCBreakpointFactory((IProject)cproject.getProject())) return false;
            return true;
        }
        if ("isAsmEditorSupportsCBreakpoint".equals(property) && receiver instanceof AsmTextEditor) {
            if (!CDebugUtils.isCustomToggleBreakpointFactory()) {
                return true;
            }
            AsmTextEditor editor = (AsmTextEditor)receiver;
            ICElement cElement = editor.getInputCElement();
            if (cElement == null) return false;
            IResource resource = cElement.getResource();
            if (resource == null || !resource.exists()) {
                return true;
            }
            ICProject cproject = cElement.getCProject();
            if (cproject == null) return true;
            if (!CDebugUtils.isStandardCBreakpointFactory((IProject)cproject.getProject())) return false;
            return true;
        }
        if (!"isCDeclarationSupportsCBreakpoint".equals(property) || !(receiver instanceof List) || (list = (List)receiver).size() != 1 || !((element = list.get(0)) instanceof IDeclaration) || !(element instanceof IVariableDeclaration) && !(element instanceof IFunctionDeclaration) && !(element instanceof IMethodDeclaration)) return false;
        if (!CDebugUtils.isCustomToggleBreakpointFactory()) {
            return true;
        }
        IDeclaration cElement = (IDeclaration)element;
        IResource resource = cElement.getResource();
        if (resource == null || !resource.exists()) {
            return true;
        }
        ICProject cproject = cElement.getCProject();
        if (cproject == null) return true;
        if (!CDebugUtils.isStandardCBreakpointFactory((IProject)cproject.getProject())) return false;
        return true;
    }
}

