/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.dsf;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.Platform;

public class DisassemblyUtils {
    public static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/disassembly"));

    public static String getAddressText(BigInteger address) {
        if (address == null) {
            return "<null>";
        }
        if (address.compareTo(BigInteger.ZERO) < 0) {
            return address.toString();
        }
        String hex = address.toString(16);
        return "0x" + "0000000000000000".substring(hex.length() + (address.bitLength() <= 32 ? 8 : 0)) + hex;
    }

    public static void internalError(Throwable e) {
        if (DEBUG) {
            System.err.println("Disassembly: Internal error");
            CDebugUIPlugin.log(e);
        }
    }

    public static BigInteger decodeAddress(String string) {
        if (string.startsWith("0x")) {
            return new BigInteger(string.substring(2), 16);
        }
        return new BigInteger(string);
    }
}

