/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ModuleLabelProvider
extends ElementLabelProvider {
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IWorkbenchAdapter adapter;
        Object element = elementPath.getLastSegment();
        if (element instanceof ICModule && presentationContext instanceof DebugModelPresentationContext) {
            IDebugModelPresentation presentation = ((DebugModelPresentationContext)presentationContext).getModelPresentation();
            return presentation.getText(element);
        }
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        return "";
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IWorkbenchAdapter adapter;
        Object element = elementPath.getLastSegment();
        if (element instanceof ICModule) {
            ICModule module = (ICModule)element;
            switch (module.getType()) {
                case 1: {
                    if (module.areSymbolsLoaded()) {
                        return CDebugImages.DESC_OBJS_EXECUTABLE_WITH_SYMBOLS;
                    }
                    return CDebugImages.DESC_OBJS_EXECUTABLE;
                }
                case 2: {
                    if (module.areSymbolsLoaded()) {
                        return CDebugImages.DESC_OBJS_SHARED_LIBRARY_WITH_SYMBOLS;
                    }
                    return CDebugImages.DESC_OBJS_SHARED_LIBRARY;
                }
            }
        }
        if (element instanceof ICElement && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getImageDescriptor(element);
        }
        return super.getImageDescriptor(elementPath, presentationContext, columnId);
    }
}

