/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SoundAction
extends AbstractBreakpointAction {
    private File soundFile;

    public static void playSoundFile(File soundFile) {
        if (soundFile.exists()) {
            class SoundPlayer
            extends Thread {
                private final /* synthetic */ File val$soundFile;

                SoundPlayer(File file) {
                    this.val$soundFile = file;
                }

                @Override
                public void run() {
                    try {
                        AudioInputStream soundStream = AudioSystem.getAudioInputStream(this.val$soundFile);
                        AudioFormat audioFormat = soundStream.getFormat();
                        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
                        SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                        byte[] soundBuffer = new byte[5000];
                        sourceDataLine.open(audioFormat);
                        sourceDataLine.start();
                        int dataCount = 0;
                        while ((dataCount = soundStream.read(soundBuffer, 0, soundBuffer.length)) != -1) {
                            if (dataCount <= 0) continue;
                            sourceDataLine.write(soundBuffer, 0, dataCount);
                        }
                        sourceDataLine.drain();
                        sourceDataLine.close();
                    }
                    catch (UnsupportedAudioFileException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                }
            }
            new SoundPlayer(soundFile).start();
        }
    }

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        if (this.soundFile == null || !this.soundFile.exists()) {
            String errorMsg = MessageFormat.format((String)Messages.getString("SoundAction.error.0"), (Object[])new Object[]{this.getSummary()});
            return new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, errorMsg, null);
        }
        SoundAction.playSoundFile(this.soundFile);
        return Status.OK_STATUS;
    }

    public String getDefaultName() {
        return Messages.getString("SoundAction.UntitledName");
    }

    public File getSoundFile() {
        return this.soundFile;
    }

    public String getSummary() {
        if (this.soundFile == null) {
            return "";
        }
        return this.soundFile.getAbsolutePath();
    }

    public String getTypeName() {
        return Messages.getString("SoundAction.ActionTypeName");
    }

    public String getMemento() {
        String soundData = "";
        if (this.soundFile != null) {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dfactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("soundData");
                rootElement.setAttribute("file", this.soundFile.getAbsolutePath());
                doc.appendChild(rootElement);
                ByteArrayOutputStream s = new ByteArrayOutputStream();
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult outputTarget = new StreamResult(s);
                transformer.transform(source, outputTarget);
                soundData = s.toString("UTF8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return soundData;
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            String value = root.getAttribute("file");
            if (value == null) {
                throw new Exception();
            }
            this.soundFile = new File(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.SoundAction";
    }

    public void setSoundFile(File soundFile) {
        this.soundFile = soundFile;
    }
}

