/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.factories.impl;

import org.eclipse.gmf.runtime.emf.type.core.AdviceBindingInheritance;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ContainerConfiguration;
import org.eclipse.papyrus.infra.types.core.factories.impl.AbstractAdviceFactory;
import org.eclipse.papyrus.infra.types.core.registries.ContainerConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.registries.MatcherConfigurationTypeRegistry;

public abstract class AbstractAdviceBindingFactory<T extends AbstractAdviceBindingConfiguration>
extends AbstractAdviceFactory<T> {
    private final String ALL_TYPE_ID = "*";

    @Override
    protected String getTypeId(T adviceConfiguration) {
        if (adviceConfiguration.getTarget() != null) {
            return adviceConfiguration.getTarget().getIdentifier();
        }
        return "*";
    }

    @Override
    protected IContainerDescriptor getContainerDescriptor(T adviceConfiguration) {
        ContainerConfiguration containerConfiguration = adviceConfiguration.getContainerConfiguration();
        if (containerConfiguration == null) {
            return null;
        }
        IContainerDescriptor containerDescriptor = ContainerConfigurationTypeRegistry.getInstance().getContainerDescriptor(containerConfiguration);
        return containerDescriptor;
    }

    @Override
    protected IElementMatcher getMatcher(T adviceConfiguration) {
        AbstractMatcherConfiguration matcherConfiguration = adviceConfiguration.getMatcherConfiguration();
        if (matcherConfiguration == null) {
            return null;
        }
        IElementMatcher matcher = MatcherConfigurationTypeRegistry.getInstance().getMatcher(matcherConfiguration);
        return matcher;
    }

    @Override
    protected AdviceBindingInheritance getInheritance(T adviceConfiguration) {
        return AdviceBindingInheritance.getAdviceBindingInheritance((String)adviceConfiguration.getInheritance().getName());
    }

    @Override
    protected String getId(T adviceConfiguration) {
        return adviceConfiguration.getIdentifier();
    }
}

