/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.factories.impl;

import java.util.ArrayList;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IAdviceBindingDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.papyrus.infra.types.AbstractEditHelperAdviceConfiguration;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ContainerConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.factories.impl.AbstractElementTypeConfigurationFactory;
import org.eclipse.papyrus.infra.types.core.impl.ConfiguredHintedSpecializationElementType;
import org.eclipse.papyrus.infra.types.core.impl.NullEditHelperAdvice;
import org.eclipse.papyrus.infra.types.core.registries.AdviceConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.registries.ContainerConfigurationTypeRegistry;
import org.eclipse.papyrus.infra.types.core.registries.MatcherConfigurationTypeRegistry;

public class SpecializationTypeFactory
extends AbstractElementTypeConfigurationFactory<SpecializationTypeConfiguration> {
    @Override
    public IHintedType createElementType(SpecializationTypeConfiguration elementTypeConfiguration) {
        return new ConfiguredHintedSpecializationElementType(this.getID(elementTypeConfiguration), this.getIconURL(elementTypeConfiguration), this.getDisplayName(elementTypeConfiguration), this.getSpecializedID(elementTypeConfiguration), this.createElementMatcher(elementTypeConfiguration), this.createContainerDescriptor(elementTypeConfiguration), this.getEditHelperAdvice(elementTypeConfiguration), this.getSemanticHint(elementTypeConfiguration), elementTypeConfiguration);
    }

    protected IEditHelperAdvice getEditHelperAdvice(SpecializationTypeConfiguration elementTypeConfiguration) {
        AbstractEditHelperAdviceConfiguration editHelperAdviceConfiguration = elementTypeConfiguration.getEditHelperAdviceConfiguration();
        if (editHelperAdviceConfiguration == null) {
            return NullEditHelperAdvice.getInstance();
        }
        IAdviceBindingDescriptor editHelperAdviceDescriptor = AdviceConfigurationTypeRegistry.getInstance().getEditHelperAdviceDecriptor(editHelperAdviceConfiguration);
        return editHelperAdviceDescriptor.getEditHelperAdvice();
    }

    protected IContainerDescriptor createContainerDescriptor(SpecializationTypeConfiguration elementTypeConfiguration) {
        ContainerConfiguration containerConfiguration = elementTypeConfiguration.getContainerConfiguration();
        if (containerConfiguration == null) {
            return null;
        }
        IContainerDescriptor containerDescriptor = ContainerConfigurationTypeRegistry.getInstance().getContainerDescriptor(containerConfiguration);
        return containerDescriptor;
    }

    protected IElementType[] getSpecializedID(SpecializationTypeConfiguration elementTypeConfiguration) {
        ArrayList<IElementType> specializedTypes = new ArrayList<IElementType>(elementTypeConfiguration.getSpecializedTypesID().size());
        for (String specializedTypeId : elementTypeConfiguration.getSpecializedTypesID()) {
            IElementType specializedType = ElementTypeRegistry.getInstance().getType(specializedTypeId);
            if (specializedType != null) {
                specializedTypes.add(specializedType);
                continue;
            }
            Activator.log.info("Unable to add specialization \"" + this.getID(elementTypeConfiguration) + "\" to \"" + specializedTypeId + "\"");
        }
        IElementType[] elementTypes = specializedTypes.toArray(new IElementType[0]);
        return elementTypes;
    }

    protected IElementMatcher createElementMatcher(SpecializationTypeConfiguration configuration) {
        AbstractMatcherConfiguration matcherConfiguration = configuration.getMatcherConfiguration();
        if (matcherConfiguration == null) {
            return null;
        }
        IElementMatcher matcher = MatcherConfigurationTypeRegistry.getInstance().getMatcher(matcherConfiguration);
        return matcher;
    }
}

