/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource.index;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexManager;

public abstract class InternalModelIndex {
    private final QualifiedName indexKey;
    private final int maxIndexJobs;
    private final ListenableFuture<IndexManager> manager = SettableFuture.create();
    private ClassLoader ownerClassLoader;

    public InternalModelIndex(QualifiedName indexKey, int maxIndexJobs) {
        this.indexKey = indexKey;
        this.maxIndexJobs = maxIndexJobs;
    }

    public InternalModelIndex(QualifiedName indexKey) {
        this(indexKey, 0);
    }

    public final QualifiedName getIndexKey() {
        return this.indexKey;
    }

    public final int getMaxIndexJobs() {
        return this.maxIndexJobs;
    }

    protected final IContentType[] getContentTypes(IFile file) {
        return ((IndexManager)Futures.getUnchecked(this.manager)).getContentTypes(file);
    }

    protected <V> ListenableFuture<V> afterIndex(Callable<V> callable) {
        AsyncFunction indexFunction = mgr -> mgr.afterIndex(this, callable);
        return Futures.transform(this.manager, (AsyncFunction)indexFunction);
    }

    protected <V> V ifAvailable(Callable<V> callable) throws CoreException {
        try {
            return ((IndexManager)this.manager.get()).ifAvailable(callable);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", "Index manager not available", (Throwable)e));
        }
    }

    void setOwnerClassLoader(ClassLoader ownerClassLoader) {
        this.ownerClassLoader = ownerClassLoader;
    }

    protected final ObjectInputStream createObjectInput(InputStream underlying) throws IOException {
        return this.ownerClassLoader == null ? new ObjectInputStream(underlying) : new ObjectInputStream(underlying){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return Class.forName(desc.getName(), true, InternalModelIndex.this.ownerClassLoader);
            }
        };
    }

    protected abstract void dispose();

    void start(IndexManager manager) {
        try {
            this.start();
        }
        finally {
            ((SettableFuture)this.manager).set((Object)manager);
        }
    }

    protected abstract void start();

    protected abstract boolean match(IFile var1);

    protected abstract void process(IFile var1) throws CoreException;

    protected abstract void remove(IProject var1, IFile var2) throws CoreException;

    protected abstract void remove(IProject var1) throws CoreException;
}

