/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class GeneralUtil {
    public static <T> void addIfNotNull(List<T> list, T obj) {
        if (list != null && obj != null) {
            list.add(obj);
        }
    }

    public static <T> void addIfNotPresent(List<T> list, T obj) {
        if (list != null && obj != null && !list.contains(obj)) {
            list.add(obj);
        }
    }

    public static <T> void addAllNonPresent(final List<T> targetList, List<? extends T> sourceList) {
        Consumer _function = new Consumer<T>(){

            @Override
            public void accept(T it) {
                GeneralUtil.addIfNotPresent(targetList, it);
            }
        };
        sourceList.forEach(_function);
    }

    public static <P, R, T extends R> List<T> transformList(List<? extends P> sourceList, final Function<? super P, ? extends R> transform, Class<T> type) {
        Functions.Function1 _function = new Functions.Function1<P, Function<? super P, ? extends R>>(){

            public Function<? super P, ? extends R> apply(P it) {
                return transform;
            }
        };
        List _map = ListExtensions.map(sourceList, (Functions.Function1)_function);
        Iterable _filter = Iterables.filter((Iterable)_map, type);
        return IterableExtensions.toList((Iterable)_filter);
    }

    protected static String _getName(ENamedElement eobj) {
        return eobj.getName();
    }

    protected static String _getName(org.eclipse.uml2.uml.NamedElement eobj) {
        return eobj.getName();
    }

    protected static String _getName(NamedElement eobj) {
        return eobj.getName();
    }

    public static <T> Pair<Iterable<T>, Iterable<T>> difference(Iterable<T> l1, Iterable<T> l2) {
        Pair _xblockexpression = null;
        ArrayList left = CollectionLiterals.newArrayList((Object[])new Object[0]);
        ArrayList right = CollectionLiterals.newArrayList((Object[])new Object[0]);
        int i = 0;
        while (i < IterableExtensions.size(l1) && i < IterableExtensions.size(l2) && Objects.equal((Object)((Object[])Conversions.unwrapArray(l1, Object.class))[i], (Object)((Object[])Conversions.unwrapArray(l2, Object.class))[i])) {
            ++i;
        }
        while (i < IterableExtensions.size(l1) && i < IterableExtensions.size(l2)) {
            int _size_1;
            boolean _lessThan_1;
            boolean _lessThan;
            int _size = IterableExtensions.size(l1);
            boolean bl = _lessThan = i < _size;
            if (_lessThan) {
                Object _get = ((Object[])Conversions.unwrapArray(l1, Object.class))[i];
                left.add(_get);
            }
            boolean bl2 = _lessThan_1 = i < (_size_1 = IterableExtensions.size(l2));
            if (_lessThan_1) {
                Object _get_1 = ((Object[])Conversions.unwrapArray(l2, Object.class))[i];
                right.add(_get_1);
            }
            ++i;
        }
        _xblockexpression = new Pair((Object)left, (Object)right);
        return _xblockexpression;
    }

    public static <T> Iterable<T> remainder(Iterable<T> l1, Iterable<T> l2) {
        int _size_1;
        Iterable _xblockexpression = null;
        Pair<Iterable<T>, Iterable<T>> diff = GeneralUtil.difference(l1, l2);
        Iterable _xifexpression = null;
        int _size = IterableExtensions.size(l1);
        boolean _lessThan = _size < (_size_1 = IterableExtensions.size(l2));
        _xifexpression = _lessThan ? (Iterable)diff.getValue() : (Iterable)diff.getKey();
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static <T> Iterable<T> longestCommonPrefix(Iterable<T> l1, Iterable<T> l2) {
        ArrayList _xblockexpression = null;
        ArrayList prefix = CollectionLiterals.newArrayList((Object[])new Object[0]);
        int i = 0;
        while (i < IterableExtensions.size(l1) && i < IterableExtensions.size(l2) && Objects.equal((Object)((Object[])Conversions.unwrapArray(l1, Object.class))[i], (Object)((Object[])Conversions.unwrapArray(l2, Object.class))[i])) {
            Object _get = ((Object[])Conversions.unwrapArray(l1, Object.class))[i];
            prefix.add(_get);
            ++i;
        }
        _xblockexpression = prefix;
        return _xblockexpression;
    }

    public static <T> Iterable<T> longestCommonPrefix(Iterable<? extends Iterable<T>> listOfLists) {
        ArrayList _xblockexpression = null;
        if (listOfLists == null || IterableExtensions.isEmpty(listOfLists)) {
            return null;
        }
        ArrayList prefix = CollectionLiterals.newArrayList((Object[])new Object[0]);
        boolean listsMatch = true;
        int itemIndex = 0;
        while (listsMatch) {
            boolean _tripleEquals;
            Iterable firstList = ((Iterable[])Conversions.unwrapArray(listOfLists, Iterable.class))[0];
            int listIndex = 1;
            while (listIndex < IterableExtensions.size(listOfLists) && itemIndex < IterableExtensions.size((Iterable)firstList) && itemIndex < IterableExtensions.size((Iterable)((Iterable[])Conversions.unwrapArray(listOfLists, Iterable.class))[listIndex]) && Objects.equal((Object)((Object[])Conversions.unwrapArray((Object)firstList, Object.class))[itemIndex], (Object)((Object[])Conversions.unwrapArray((Object)((Iterable[])Conversions.unwrapArray(listOfLists, Iterable.class))[listIndex], Object.class))[itemIndex])) {
                ++listIndex;
            }
            int _size = IterableExtensions.size(listOfLists);
            boolean bl = _tripleEquals = listIndex == _size;
            if (_tripleEquals) {
                Object _get = ((Object[])Conversions.unwrapArray((Object)firstList, Object.class))[itemIndex];
                prefix.add(_get);
            } else {
                listsMatch = false;
            }
            ++itemIndex;
        }
        _xblockexpression = prefix;
        return _xblockexpression;
    }

    public static String longestCommonPrefix(String s1, String s2) {
        String _xblockexpression = null;
        StringBuilder prefix = new StringBuilder();
        int i = 0;
        while (s1.charAt(i) == s2.charAt(i)) {
            char _charAt = s1.charAt(i);
            prefix.append(_charAt);
            ++i;
        }
        _xblockexpression = prefix.toString();
        return _xblockexpression;
    }

    public static String getName(EObject eobj) {
        if (eobj instanceof org.eclipse.uml2.uml.NamedElement) {
            return GeneralUtil._getName((org.eclipse.uml2.uml.NamedElement)eobj);
        }
        if (eobj instanceof ENamedElement) {
            return GeneralUtil._getName((ENamedElement)eobj);
        }
        if (eobj instanceof NamedElement) {
            return GeneralUtil._getName((NamedElement)eobj);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(eobj).toString());
    }
}

