/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IComponentModel;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.dnd.IDropTarget;

public class ComponentPart
extends PagePart
implements IComponentPage {
    private IComponentModel partModel;
    private Composite editorControl;

    public ComponentPart(TabFolderPart parent, IComponentModel partModel, Object rawModel) {
        super(parent, rawModel);
        this.partModel = partModel;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Supplier<Object> fallback = () -> super.getAdapter(adapter);
        return (T)PlatformHelper.getAdapter((Object)this.partModel, adapter, fallback);
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            this.editorControl = this.createEditorPartControl(parent);
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.infra.core.sasheditor", e.getLocalizedMessage()));
        }
    }

    private Composite createEditorPartControl(Composite parentControl) throws PartInitException {
        Composite editorParent = new Composite(parentControl, 0);
        editorParent.setLayout((Layout)new FillLayout());
        this.partModel.createPartControl(editorParent);
        return editorParent;
    }

    @Override
    public void dispose() {
        if (!this.editorControl.isDisposed()) {
            this.editorControl.dispose();
        }
        this.partModel = null;
        this.rawModel = null;
    }

    @Override
    public void disposeThisAndChildren() {
        this.partModel = null;
    }

    public PagePart findPart(Point toFind) {
        return this;
    }

    @Override
    public PagePart findPartAt(Point toFind, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        throw new UnsupportedOperationException("Tile match the expected position '" + toFind + "' but there is no Tile of requested type '" + expectedTileType.getClass().getName() + "'");
    }

    public PagePart findPart(Object control) {
        if (this.getControl() == control) {
            return this;
        }
        return null;
    }

    public Composite getControl() {
        return this.editorControl;
    }

    public IDropTarget getDropTarget(Object draggedObject, TabFolderPart sourcePart, Point position) {
        return null;
    }

    @Override
    public void reparent(TabFolderPart newParent) {
        this.parent = newParent;
        this.editorControl.setParent(newParent.getControl());
        if (this.garbageState != AbstractPart.GarbageState.UNVISITED && this.garbageState != AbstractPart.GarbageState.ORPHANED && this.garbageState != AbstractPart.GarbageState.CREATED) {
            throw new IllegalStateException("Try to change state from " + this.garbageState.toString() + " to REPARENTED. This is forbidden.");
        }
        this.garbageState = AbstractPart.GarbageState.REPARENTED;
    }

    @Override
    public void setFocus() {
        if (this.editorControl != null && !this.editorControl.isDisposed()) {
            this.editorControl.setFocus();
        }
    }

    public void synchronize2(PartLists partMap) {
    }

    @Override
    public void garbage() {
        this.dispose();
        this.getSashWindowContainer().getLifeCycleEventProvider().firePageClosedEvent(this);
    }

    @Override
    public boolean visit(IPartVisitor visitor) {
        return visitor.accept(this);
    }

    public boolean visitChildren(IPartVisitor visitor) {
        return true;
    }

    protected void showStatus() {
        System.out.printf("ComponentPart: disposed=%-5b, visible=%-5b, garbState=%-10s, %s, %s\n", new Object[]{this.editorControl.isDisposed(), this.editorControl.isDisposed() ? false : this.editorControl.isVisible(), this.garbageState, this.getPageTitle(), this});
    }

    @Override
    public String getPageTitle() {
        try {
            return this.partModel.getTabTitle();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return "Error";
        }
    }

    @Override
    public Image getPageIcon() {
        try {
            return this.partModel.getTabIcon();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

