/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.debuggerconsole;

import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.ConsoleMessages;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.DebuggerConsoleView;
import org.eclipse.cdt.debug.internal.ui.views.debuggerconsole.DebuggerShowConsoleAction;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsoleManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class DebuggerConsoleDropDownAction
extends Action
implements IMenuCreator,
IConsoleListener,
IUpdate {
    private DebuggerConsoleView fView;
    private Menu fMenu;

    public DebuggerConsoleDropDownAction(DebuggerConsoleView view) {
        this.fView = view;
        this.setId("org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction");
        this.setText(ConsoleMessages.ConsoleDropDownAction_name);
        this.setToolTipText(ConsoleMessages.ConsoleDropDownAction_description);
        this.setImageDescriptor(CDebugImages.DESC_OBJS_DEBUGGER_CONSOLE_SELECT);
        this.setMenuCreator(this);
        this.getDebuggerConsoleManager().addConsoleListener(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        this.getDebuggerConsoleManager().removeConsoleListener(this);
    }

    private IDebuggerConsoleManager getDebuggerConsoleManager() {
        return CDebugUIPlugin.getDebuggerConsoleManager();
    }

    public void update() {
        IDebuggerConsole[] consoles = this.getDebuggerConsoleManager().getConsoles();
        this.setEnabled(consoles.length > 0);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IDebuggerConsole[] consoles = this.getDebuggerConsoleManager().getConsoles();
        IDebuggerConsole current = this.fView.getCurrentConsole();
        int i = 0;
        while (i < consoles.length) {
            IDebuggerConsole console = consoles[i];
            DebuggerShowConsoleAction action = new DebuggerShowConsoleAction(this.fView, console);
            action.setChecked(console.equals(current));
            this.addActionToMenu(this.fMenu, action, i + 1);
            ++i;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        IDebuggerConsole[] consoles = this.getDebuggerConsoleManager().getConsoles();
        IDebuggerConsole current = this.fView.getCurrentConsole();
        int idx = 0;
        int i = 0;
        while (i < consoles.length) {
            idx = i;
            if (consoles[i] == current) break;
            ++i;
        }
        int next = idx + 1;
        if (next >= consoles.length) {
            next = 0;
        }
        this.fView.display(consoles[next]);
    }

    public void consolesAdded(IConsole[] consoles) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                DebuggerConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public void consolesRemoved(IConsole[] consoles) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DebuggerConsoleDropDownAction.this.fMenu != null) {
                    DebuggerConsoleDropDownAction.this.fMenu.dispose();
                }
                DebuggerConsoleDropDownAction.this.update();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

