/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrusrt.xtumlrt.util.DetailedException;
import org.eclipse.xtext.xbase.lib.Functions;

public class CodeGenPlugin
extends Plugin {
    public static final String ID = "org.eclipse.papyrusrt.codegen";
    public static final String EOBJECTLOCATOR_EP_ID = "eobjectlocator";
    private static CodeGenPlugin instance;
    private static boolean standalone;
    private static boolean textual;
    private static boolean printStackTrace;
    private static final Logger LOGGER;

    static {
        standalone = false;
        textual = false;
        LOGGER = Logger.getLogger("CodeGenPlugin");
    }

    public CodeGenPlugin() {
        instance = this;
        LOGGER.setUseParentHandlers(false);
    }

    public static CodeGenPlugin getDefault() {
        return instance;
    }

    public static IStatus debug(String message) {
        Status status = new Status(1, ID, "[DEBUG]" + message);
        if (standalone) {
            CodeGenPlugin.getLogger().finest(message);
        }
        return status;
    }

    public static IStatus debug(Functions.Function0<CharSequence> thunk) {
        Status status = null;
        if (!standalone || CodeGenPlugin.getLogger().getLevel().intValue() > Level.FINEST.intValue()) {
            status = new Status(1, ID, "[DEBUG] " + thunk.toString());
        } else {
            String message = ((CharSequence)thunk.apply()).toString();
            status = new Status(1, ID, "[DEBUG]\n" + message);
            if (standalone) {
                CodeGenPlugin.getLogger().finest(message);
            }
        }
        return status;
    }

    public static IStatus info(String message) {
        Status status = new Status(1, ID, message);
        if (standalone) {
            CodeGenPlugin.getLogger().info(message);
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus warning(String message) {
        Status status = new Status(2, ID, message);
        if (standalone) {
            CodeGenPlugin.getLogger().warning(message);
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static IStatus error(String message) {
        return CodeGenPlugin.error(message, null);
    }

    public static IStatus error(Throwable e) {
        return CodeGenPlugin.error("Error", e);
    }

    public static IStatus error(String message, Throwable e) {
        Status status = null;
        status = e instanceof DetailedException ? new Status(4, ID, e.toString()) : new Status(4, ID, message, e);
        if (standalone) {
            CodeGenPlugin.getLogger().severe(status.toString());
            if (printStackTrace && e != null) {
                e.printStackTrace();
            }
        } else {
            CodeGenPlugin.getDefault().getLog().log((IStatus)status);
        }
        return status;
    }

    public static void setStandalone(boolean printTrace) {
        standalone = true;
        printStackTrace = printTrace;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static void setTextual(boolean printTrace) {
        textual = true;
        printStackTrace = printTrace;
    }

    public static boolean isTextual() {
        return textual;
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

