/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class ProcessWrapper {
    public static void process(List<String> arguments) {
        BufferedReader results = null;
        BufferedReader errors = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(arguments);
            Process p = null;
            try {
                String s;
                p = pb.start();
                results = new BufferedReader(new InputStreamReader(p.getInputStream()));
                boolean error = false;
                String errorMsg = "";
                errors = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = errors.readLine()) != null) {
                    errorMsg = String.valueOf(errorMsg) + s;
                    error = true;
                }
                while ((s = results.readLine()) != null) {
                    errorMsg = String.valueOf(errorMsg) + s;
                    error = true;
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
                if (error) {
                    throw new RuntimeException(String.format("error during execution of external command: %s", errorMsg));
                }
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            try {
                if (results != null) {
                    results.close();
                }
                if (errors != null) {
                    errors.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (results != null) {
                results.close();
            }
            if (errors != null) {
                errors.close();
            }
        }
        catch (IOException iOException) {}
    }
}

