/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.controlmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.controlmode.Activator;
import org.eclipse.papyrus.infra.gmfdiag.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDiagramsCommand
extends AbstractControlCommand {
    private static final String RETRIEVE_OLD_URI_RESOURCE_ERROR = Messages.getString("ControlDiagramsCommand.old.uri.resource.error");
    private static final String RETRIEVE_OLD_RESOURCE_ERROR = Messages.getString("ControlDiagramsCommand.old.resource.error");
    private static final String COMMAND_TITLE = Messages.getString("ControlDiagramsCommand.command.title");
    private static final String CREATION_RESOURCE_ERROR = Messages.getString("ControlDiagramsCommand.resource.creation.error");
    private Resource oldNotationResource = null;

    public ControlDiagramsCommand(ControlModeRequest request) {
        super(COMMAND_TITLE, null, request);
        this.getAffectedFiles().addAll(ControlDiagramsCommand.getWorkspaceFiles(this.getDiagrams()));
    }

    protected void addMovedDiagramToRequest(List<Diagram> diags) {
        ArrayList<Diagram> openables = (ArrayList<Diagram>)this.getRequest().getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (openables == null) {
            openables = new ArrayList<Diagram>();
        }
        openables.addAll(diags);
        this.getRequest().addParameters(Collections.singletonMap("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables", openables));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        EObject objectToControl = this.getRequest().getTargetObject();
        Resource newNotationResource = this.getRequest().getTargetResource("notation");
        if (newNotationResource == null) {
            return CommandResult.newErrorCommandResult((String)CREATION_RESOURCE_ERROR);
        }
        List<Diagram> diagrams = this.getDiagrams();
        if (!diagrams.isEmpty()) {
            newNotationResource.getContents().addAll(diagrams);
            this.addMovedDiagramToRequest(diagrams);
        }
        Collection crossReferences = EMFHelper.getUsages((EObject)objectToControl);
        HashSet<Resource> impactedNotationResources = new HashSet<Resource>(2);
        if (!crossReferences.isEmpty()) {
            for (EStructuralFeature.Setting setting : crossReferences) {
                Resource resource;
                EObject referencedObject = setting.getEObject();
                if (!(referencedObject instanceof View) || (resource = referencedObject.eResource()) == null) continue;
                impactedNotationResources.add(resource);
            }
            if (!impactedNotationResources.isEmpty()) {
                for (Resource resource : impactedNotationResources) {
                    resource.setModified(true);
                }
            }
        }
        return CommandResult.newOKCommandResult((Object)newNotationResource);
    }

    protected List<Diagram> getDiagrams() {
        Resource notationResource = this.getOldNotationResource();
        return NotationUtils.getDiagrams((Resource)notationResource, (EObject)this.getRequest().getTargetObject());
    }

    private Resource getOldNotationResource() {
        if (this.oldNotationResource == null) {
            try {
                this.oldNotationResource = this.getRequest().getModelSet().getResource(this.getOldNotationURI(), true);
            }
            catch (Exception e) {
                Activator.log.error(RETRIEVE_OLD_RESOURCE_ERROR, (Throwable)e);
            }
        }
        return this.oldNotationResource;
    }

    protected URI getOldNotationURI() throws ExecutionException {
        URI uri = this.getRequest().getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("notation");
        }
        throw new ExecutionException(RETRIEVE_OLD_URI_RESOURCE_ERROR);
    }
}

