/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.launchbar.ui.internal.target.NewLaunchTargetWizardSelectionPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

class NewLaunchTargetWizardNewPage
implements ISelectionChangedListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "NewWizardSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_VIEWER_WIDTH = 300;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_ID = "NewWizardSelectionPage.STORE_SELECTED_ID";
    private NewLaunchTargetWizardSelectionPage page;
    private FilteredTree filteredTree;
    private WizardPatternFilter filteredTreeFilter;
    private Hashtable selectedWizards = new Hashtable();
    private IDialogSettings settings;
    private Button showAllCheck;
    private IWizardDescriptor[] primaryWizards;
    private CLabel descImageCanvas;
    private Map imageTable = new HashMap();
    private IWizardDescriptor selectedElement;
    private WizardActivityFilter filter = new WizardActivityFilter();
    private boolean needShowAll;

    public NewLaunchTargetWizardNewPage(NewLaunchTargetWizardSelectionPage mainPage, IWizardCategory wizardCategories, IWizardDescriptor[] primaryWizards) {
        this.page = mainPage;
        this.primaryWizards = primaryWizards;
        this.needShowAll = !this.allActivityEnabled(primaryWizards);
    }

    private boolean allActivityEnabled(IWizardDescriptor[] wizards) {
        int i = 0;
        while (i < wizards.length) {
            IWizardDescriptor wizard = wizards[i];
            if (WorkbenchActivityHelper.filterItem((Object)wizard)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void activate() {
        this.page.setDescription(WorkbenchMessages.NewWizardNewPage_description);
    }

    protected Control createControl(Composite parent) {
        Font wizardFont = parent.getFont();
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        outerContainer.setLayout((Layout)layout);
        Label wizardLabel = new Label(outerContainer, 0);
        GridData data = new GridData(1, 4, false, true);
        outerContainer.setLayoutData((Object)data);
        wizardLabel.setFont(wizardFont);
        wizardLabel.setText(WorkbenchMessages.NewWizardNewPage_wizardsLabel);
        Composite innerContainer = new Composite(outerContainer, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        innerContainer.setLayout((Layout)layout);
        innerContainer.setFont(wizardFont);
        data = new GridData(4, 4, true, true);
        innerContainer.setLayoutData((Object)data);
        this.filteredTree = this.createFilteredTree(innerContainer);
        this.createOptionsButtons(innerContainer);
        this.createImage(innerContainer);
        this.updateDescription(null);
        this.restoreWidgetValues();
        return outerContainer;
    }

    protected FilteredTree createFilteredTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        boolean needsHint = DialogUtil.inRegularFontMode((Composite)parent);
        if (needsHint) {
            data.heightHint = 200;
        }
        composite.setLayoutData((Object)data);
        this.filteredTreeFilter = new WizardPatternFilter();
        FilteredTree filterTree = new FilteredTree(composite, 2820, (PatternFilter)this.filteredTreeFilter, true);
        filterTree.setQuickSelectionMode(true);
        final TreeViewer treeViewer = filterTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new WizardContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ArrayList<IWizardDescriptor> inputArray = new ArrayList<IWizardDescriptor>();
        int i = 0;
        while (i < this.primaryWizards.length) {
            inputArray.add(this.primaryWizards[i]);
            ++i;
        }
        boolean expandTop = false;
        if (expandTop) {
            treeViewer.setAutoExpandLevel(2);
        }
        AdaptableList input = new AdaptableList(inputArray);
        treeViewer.setInput((Object)input);
        filterTree.setBackground(parent.getDisplay().getSystemColor(22));
        treeViewer.getTree().setFont(parent.getFont());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                NewLaunchTargetWizardNewPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getViewer(), (ISelection)s));
                Object element = s.getFirstElement();
                if (treeViewer.isExpandable(element)) {
                    treeViewer.setExpandedState(element, !treeViewer.getExpandedState(element));
                } else if (element instanceof WorkbenchWizardElement) {
                    NewLaunchTargetWizardNewPage.this.page.advanceToNextPageOrFinish();
                }
            }
        });
        treeViewer.addFilter((ViewerFilter)this.filter);
        Dialog.applyDialogFont((Control)filterTree);
        return filterTree;
    }

    private void createOptionsButtons(Composite parent) {
        if (this.needShowAll) {
            this.showAllCheck = new Button(parent, 32);
            GridData data = new GridData();
            this.showAllCheck.setLayoutData((Object)data);
            this.showAllCheck.setFont(parent.getFont());
            this.showAllCheck.setText(WorkbenchMessages.NewWizardNewPage_showAll);
            this.showAllCheck.setSelection(false);
            this.showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private Object[] delta = new Object[0];

                public void widgetSelected(SelectionEvent e) {
                    boolean showAll = NewLaunchTargetWizardNewPage.this.showAllCheck.getSelection();
                    if (showAll) {
                        NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().getControl().setRedraw(false);
                    } else {
                        this.delta = NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                    }
                    try {
                        if (showAll) {
                            NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().resetFilters();
                            NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().addFilter((ViewerFilter)NewLaunchTargetWizardNewPage.this.filteredTreeFilter);
                            Object[] currentExpanded = NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                            Object[] expanded = new Object[this.delta.length + currentExpanded.length];
                            System.arraycopy(currentExpanded, 0, expanded, 0, currentExpanded.length);
                            System.arraycopy(this.delta, 0, expanded, currentExpanded.length, this.delta.length);
                            NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().setExpandedElements(expanded);
                        } else {
                            NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().addFilter((ViewerFilter)NewLaunchTargetWizardNewPage.this.filter);
                        }
                        NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().refresh(false);
                        if (!showAll) {
                            Object[] newExpanded = NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                            ArrayList<Object> deltaList = new ArrayList<Object>(Arrays.asList(this.delta));
                            deltaList.removeAll(Arrays.asList(newExpanded));
                        }
                    }
                    finally {
                        if (showAll) {
                            NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().getControl().setRedraw(true);
                        }
                    }
                }
            });
        }
    }

    private void createImage(Composite parent) {
        this.descImageCanvas = new CLabel(parent, 0);
        GridData data = new GridData(34);
        data.widthHint = 0;
        data.heightHint = 0;
        this.descImageCanvas.setLayoutData((Object)data);
        this.descImageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Iterator i = NewLaunchTargetWizardNewPage.this.imageTable.values().iterator();
                while (i.hasNext()) {
                    ((Image)i.next()).dispose();
                }
                NewLaunchTargetWizardNewPage.this.imageTable.clear();
            }
        });
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        return selection.size() == 1 ? selection.getFirstElement() : null;
    }

    protected void restoreWidgetValues() {
        this.selectPreviouslySelected();
    }

    public void saveWidgetValues() {
        this.storeSelectedCategoryAndWizard();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        Object selectedObject = this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (selectedObject instanceof IWizardDescriptor) {
            if (selectedObject == this.selectedElement) {
                return;
            }
            this.updateWizardSelection((IWizardDescriptor)selectedObject);
        } else {
            this.selectedElement = null;
            this.page.setHasPages(false);
            this.page.setCanFinishEarly(false);
            this.page.selectWizardNode(null);
            this.updateDescription(null);
        }
    }

    protected void selectPreviouslySelected() {
        String selectedId = this.settings.get(STORE_SELECTED_ID);
        if (selectedId == null) {
            return;
        }
        IWizardDescriptor selected = null;
        int i = 0;
        while (i < this.primaryWizards.length) {
            IWizardDescriptor wizard = this.primaryWizards[i];
            if (wizard.getId().equals(selectedId)) {
                selected = wizard;
                break;
            }
            ++i;
        }
        if (selected == null) {
            return;
        }
        final StructuredSelection selection = new StructuredSelection(selected);
        this.filteredTree.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewLaunchTargetWizardNewPage.this.filteredTree.getViewer().setSelection((ISelection)selection, true);
            }
        });
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    protected void storeSelectedCategoryAndWizard() {
        Object selected = this.getSingleSelection((IStructuredSelection)this.filteredTree.getViewer().getSelection());
        if (selected != null) {
            if (selected instanceof IWizardCategory) {
                this.settings.put(STORE_SELECTED_ID, ((IWizardCategory)selected).getPath().toString());
            } else {
                this.settings.put(STORE_SELECTED_ID, ((IWizardDescriptor)selected).getId());
            }
        }
    }

    private void updateDescription(IWizardDescriptor selectedObject) {
        String string = "";
        if (selectedObject != null) {
            string = selectedObject.getDescription();
        }
        this.page.setDescription(string);
        if (this.hasImage(selectedObject)) {
            ImageDescriptor descriptor = null;
            if (selectedObject != null) {
                descriptor = selectedObject.getDescriptionImage();
            }
            if (descriptor != null) {
                GridData data = (GridData)this.descImageCanvas.getLayoutData();
                data.widthHint = -1;
                data.heightHint = -1;
                Image image = (Image)this.imageTable.get(descriptor);
                if (image == null) {
                    image = descriptor.createImage(false);
                    this.imageTable.put(descriptor, image);
                }
                this.descImageCanvas.setImage(image);
            }
        } else {
            GridData data = (GridData)this.descImageCanvas.getLayoutData();
            data.widthHint = 0;
            data.heightHint = 0;
            this.descImageCanvas.setImage(null);
        }
        this.descImageCanvas.getParent().layout(true);
        this.filteredTree.getViewer().getTree().showSelection();
        IWizardContainer container = this.page.getWizard().getContainer();
        if (container instanceof IWizardContainer2) {
            ((IWizardContainer2)container).updateSize();
        }
    }

    private boolean hasImage(IWizardDescriptor selectedObject) {
        if (selectedObject == null) {
            return false;
        }
        return selectedObject.getDescriptionImage() != null;
    }

    private void updateWizardSelection(IWizardDescriptor selectedObject) {
        WorkbenchWizardNode selectedNode;
        this.selectedElement = selectedObject;
        if (this.selectedWizards.containsKey(selectedObject)) {
            selectedNode = (WorkbenchWizardNode)this.selectedWizards.get(selectedObject);
        } else {
            selectedNode = new WorkbenchWizardNode(this.page, selectedObject){

                public IWorkbenchWizard createWizard() throws CoreException {
                    return this.wizardElement.createWizard();
                }
            };
            this.selectedWizards.put(selectedObject, selectedNode);
        }
        this.page.setCanFinishEarly(selectedObject.canFinishEarly());
        this.page.setHasPages(selectedObject.hasPages());
        this.page.selectWizardNode((IWizardNode)selectedNode);
        this.updateDescription(selectedObject);
    }
}

