/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.IdentityAnchorHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.common.editparts.NamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GrillingEditpart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.NoGrillElementFound;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;

public class ConnectMessageToGridEditPolicy
extends GraphicalEditPolicyEx
implements AutomaticNotationEditPolicy,
NotificationListener,
IGrillingEditpolicy {
    protected GrillingEditpart gridCompartment = null;
    public static String CONNECT_TO_GRID_MANAGEMENT = "CONNECT_TO_GRID_MANAGEMENT";
    protected int displayImprecision = 2;
    private View rowSource;
    private View rowTarget;

    protected void updatePositionGridAxis(DecorationNode axis, int x, int y) {
        Location currentBounds = (Location)axis.getLayoutConstraint();
        if (x < currentBounds.getX() - this.displayImprecision || x > currentBounds.getX() + this.displayImprecision) {
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS to x=" + x + " y=" + y);
            this.execute((ICommand)new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update Column", (IAdaptable)new EObjectAdapter((EObject)axis), new Point(x, y)));
        }
        if (y < currentBounds.getY() - this.displayImprecision || y > currentBounds.getY() + this.displayImprecision) {
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS to x=" + x + " y=" + y);
            this.execute((ICommand)new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update row", (IAdaptable)new EObjectAdapter((EObject)axis), new Point(x, y)));
        }
    }

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            if (grilling != null) {
                ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getHost();
                Edge edge = (Edge)connectionEditPart.getModel();
                IdentityAnchor sourceAnchor = (IdentityAnchor)edge.getSourceAnchor();
                IdentityAnchor targetAnchor = (IdentityAnchor)edge.getSourceAnchor();
                if (sourceAnchor != null && targetAnchor != null) {
                    double absoluteY;
                    double localY;
                    PrecisionRectangle bounds;
                    if (sourceAnchor.getId() != null && !sourceAnchor.getId().equals("")) {
                        View viewsr = edge.getSource();
                        Message m = (Message)connectionEditPart.resolveSemanticElement();
                        double ypercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)sourceAnchor);
                        bounds = NotationHelper.getAbsoluteBounds((Node)((Node)viewsr));
                        localY = bounds.preciseHeight() * ypercent;
                        absoluteY = localY + bounds.preciseY();
                        this.rowSource = m.getSendEvent() == null ? grilling.createRowTolisten((int)absoluteY, (Element)m) : grilling.createRowTolisten((int)absoluteY, (Element)m.getSendEvent());
                        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowSource, (NotificationListener)this);
                    }
                    if (targetAnchor.getId() != null && !targetAnchor.getId().equals("")) {
                        View viewtg = edge.getTarget();
                        double ypercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)targetAnchor);
                        Message m = (Message)connectionEditPart.resolveSemanticElement();
                        bounds = NotationHelper.getAbsoluteBounds((Node)((Node)viewtg));
                        localY = bounds.preciseHeight() * ypercent;
                        absoluteY = localY + bounds.preciseY();
                        this.rowTarget = m.getReceiveEvent() == null ? grilling.createRowTolisten((int)absoluteY, (Element)m) : grilling.createRowTolisten((int)absoluteY, (Element)m.getReceiveEvent());
                        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowTarget, (NotificationListener)this);
                    }
                }
            }
        }
        catch (NoGrillElementFound e) {
            UMLDiagramEditorPlugin.log.error((Throwable)e);
        }
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        if (diagramEditPart != null) {
            Edge edge;
            GridManagementEditPolicy grilling;
            IdentityAnchor anchor;
            Edge edge2;
            ConnectionEditPart connectionEditPart;
            GridManagementEditPolicy grilling2;
            int anchorY;
            NamedElementEditPart sourceEditpart;
            ConnectionEditPart connectionEditPart2;
            IdentityAnchor anchor2;
            if (notification.getNotifier().equals((EObject)this.getHost().getModel()) && NotationPackage.eINSTANCE.getEdge_SourceAnchor().equals(notification.getFeature()) && notification.getNewValue() != null) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT :CREATION add SourceAnchor " + notification.getNotifier());
                anchor2 = (IdentityAnchor)notification.getNewValue();
                if (anchor2.getId() != null && !anchor2.getId().equals("")) {
                    connectionEditPart2 = (ConnectionEditPart)this.getHost();
                    Message m = (Message)connectionEditPart2.resolveSemanticElement();
                    sourceEditpart = (NamedElementEditPart)connectionEditPart2.getSource();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor2, (GraphicalEditPart)sourceEditpart);
                    try {
                        grilling2 = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                        if (grilling2 != null) {
                            if (this.rowSource == null) {
                                this.rowSource = m.getSendEvent() == null ? grilling2.createRowTolisten(anchorY, (Element)m) : grilling2.createRowTolisten(anchorY, (Element)m.getSendEvent());
                            }
                            this.getDiagramEventBroker().addNotificationListener((EObject)this.rowSource, (NotificationListener)this);
                        }
                    }
                    catch (NoGrillElementFound e) {
                        UMLDiagramEditorPlugin.log.error((Throwable)e);
                    }
                }
            }
            if (notification.getNotifier().equals((EObject)this.getHost().getModel()) && NotationPackage.eINSTANCE.getEdge_TargetAnchor().equals(notification.getFeature()) && notification.getNewValue() != null) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: CREATION add targetAnchor " + notification.getNotifier());
                anchor2 = (IdentityAnchor)notification.getNewValue();
                if (anchor2.getId() != null && !anchor2.getId().equals("")) {
                    connectionEditPart2 = (ConnectionEditPart)this.getHost();
                    NamedElementEditPart editpart = (NamedElementEditPart)connectionEditPart2.getTarget();
                    Message m = (Message)connectionEditPart2.resolveSemanticElement();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor2, (GraphicalEditPart)editpart);
                    try {
                        grilling2 = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                        if (grilling2 != null) {
                            if (this.rowTarget == null) {
                                this.rowTarget = m.getReceiveEvent() == null ? grilling2.createRowTolisten(anchorY, (Element)m) : grilling2.createRowTolisten(anchorY, (Element)m.getReceiveEvent());
                            }
                            this.getDiagramEventBroker().addNotificationListener((EObject)this.rowTarget, (NotificationListener)this);
                        }
                    }
                    catch (NoGrillElementFound e) {
                        UMLDiagramEditorPlugin.log.error((Throwable)e);
                    }
                }
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getEdge_Source())) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT Source change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge2 = (Edge)connectionEditPart.getNotationView();
                if (edge2.getSourceAnchor() != null && this.rowSource != null) {
                    anchor = (IdentityAnchor)edge2.getSourceAnchor();
                    sourceEditpart = (NamedElementEditPart)connectionEditPart.getSource();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor, (GraphicalEditPart)sourceEditpart);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + anchorY + " ");
                    this.updatePositionGridAxis((DecorationNode)this.rowSource, 0, anchorY);
                }
            }
            if (notification.getEventType() == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getEdge_Target())) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT target change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge2 = (Edge)connectionEditPart.getNotationView();
                if (edge2.getTargetAnchor() != null && this.rowTarget != null) {
                    anchor = (IdentityAnchor)edge2.getTargetAnchor();
                    NamedElementEditPart targetEditpart = (NamedElementEditPart)connectionEditPart.getTarget();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor, (GraphicalEditPart)targetEditpart);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + anchorY + " ");
                    this.updatePositionGridAxis((DecorationNode)this.rowTarget, 0, anchorY);
                }
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof IdentityAnchor) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+EVENT IdentificationAnchor change " + notification.getNotifier());
                connectionEditPart = (ConnectionEditPart)this.getHost();
                edge2 = (Edge)connectionEditPart.getNotationView();
                if (notification.getNotifier().equals(edge2.getSourceAnchor()) && this.rowSource != null) {
                    anchor = (IdentityAnchor)edge2.getSourceAnchor();
                    sourceEditpart = (NamedElementEditPart)connectionEditPart.getSource();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor, (GraphicalEditPart)sourceEditpart);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+--> SOURCE change for " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + anchorY + " ");
                    this.updatePositionGridAxis((DecorationNode)this.rowSource, 0, anchorY);
                }
                if (notification.getNotifier().equals(edge2.getTargetAnchor()) && this.rowTarget != null) {
                    anchor = (IdentityAnchor)edge2.getTargetAnchor();
                    NamedElementEditPart editpart = (NamedElementEditPart)connectionEditPart.getTarget();
                    anchorY = ConnectMessageToGridEditPolicy.computeAnchorPositionNotation(anchor, (GraphicalEditPart)editpart);
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+-->TARGET change " + ((NamedElement)connectionEditPart.resolveSemanticElement()).getName() + " to " + anchorY + " ");
                    this.updatePositionGridAxis((DecorationNode)this.rowTarget, 0, anchorY);
                }
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.rowSource)) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT source Axis modified :" + notification);
                grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                if (grilling != null && Math.abs(notification.getOldIntValue() - notification.getNewIntValue()) > grilling.threshold) {
                    connectionEditPart2 = (ConnectionEditPart)this.getHost();
                    edge = (Edge)connectionEditPart2.getModel();
                    IdentityAnchor sourceAchor = (IdentityAnchor)edge.getSourceAnchor();
                    View viewsr = edge.getSource();
                    this.modifyAnchor(sourceAchor, (Node)viewsr, (DecorationNode)this.rowSource);
                }
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.rowTarget)) {
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT target Axis modified :" + notification);
                grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
                if (grilling != null && Math.abs(notification.getOldIntValue() - notification.getNewIntValue()) > grilling.threshold) {
                    connectionEditPart2 = (ConnectionEditPart)this.getHost();
                    edge = (Edge)connectionEditPart2.getModel();
                    IdentityAnchor targetAchor = (IdentityAnchor)edge.getTargetAnchor();
                    View viewtg = edge.getTarget();
                    this.modifyAnchor(targetAchor, (Node)viewtg, (DecorationNode)this.rowTarget);
                }
            }
        }
    }

    protected void modifyAnchor(IdentityAnchor anchor, Node connectedView, DecorationNode axis) {
        double xpercent = IdentityAnchorHelper.getXPercentage((IdentityAnchor)anchor);
        PrecisionRectangle bounds = NotationHelper.getAbsoluteBounds((Node)connectedView);
        bounds.height = BoundForEditPart.getHeightFromView(connectedView);
        Location boundsRow = (Location)axis.getLayoutConstraint();
        Integer intergerY = new Integer(boundsRow.getY());
        double newY = intergerY.doubleValue();
        double localY = newY - bounds.preciseY();
        double newPercentY = localY / bounds.preciseHeight();
        double oldPercentY = IdentityAnchorHelper.getYPercentage((IdentityAnchor)anchor);
        double oldPosition = oldPercentY * bounds.preciseHeight();
        double newPosition = newPercentY * bounds.preciseHeight();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
        if (grilling != null && Math.abs(oldPosition - newPosition) > (double)grilling.threshold) {
            if (newPercentY > 1.0) {
                newPercentY = 0.99;
            }
            if (newPercentY < 0.0) {
                newPercentY = 0.01;
            }
            if (newPercentY <= 1.0 && newPercentY >= 0.0 && newPercentY <= 1.0 && newPercentY >= 0.0) {
                String newIdValue = IdentityAnchorHelper.createNewAnchorIdValue((double)xpercent, (double)newPercentY);
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modify anchor to precentY=" + newPercentY);
                this.execute((Command)new SetCommand((EditingDomain)this.getDiagramEditPart(this.getHost()).getEditingDomain(), (EObject)anchor, (EStructuralFeature)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)newIdValue));
            }
        }
    }

    public static int computeAnchorPositionNotation(IdentityAnchor anchor, GraphicalEditPart nodeEditPart) {
        double yPercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)anchor);
        Node node = (Node)nodeEditPart.getNotationView();
        PrecisionRectangle bounds = NotationHelper.getAbsoluteBounds((Node)node);
        double height = BoundForEditPart.getHeightFromView(node);
        int anchorY = (int)(height * yPercent) + bounds.y;
        return anchorY;
    }
}

