/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterUtil {
    public static String getModifiersAsString(Parameter parameter, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : " ";
        if (parameter.isOrdered()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (parameter.isUnique()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        if (parameter.isException()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "exception");
        }
        if (parameter.isStream()) {
            needsComma = ParameterUtil.updateModifiersString(buffer, needsComma, NL, "stream");
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String NL, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(NL);
        }
        buffer.append(message);
        return true;
    }

    public static String getLabel(Parameter parameter) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        buffer.append(" ");
        buffer.append(parameter.getDirection().getLiteral());
        buffer.append(" ");
        if (parameter.getName() != null) {
            buffer.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter));
        }
        if (parameter.getType() != null) {
            buffer.append(": " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter.getType()));
        } else {
            buffer.append(": <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(multiplicity);
        }
        if (parameter.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        buffer.append(ParameterUtil.getModifiersAsString(parameter, false));
        return buffer.toString();
    }

    public static String getCustomLabel(Parameter parameter, Collection<String> maskValues) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (maskValues.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)parameter));
        }
        if (maskValues.contains("parametersDirection") || maskValues.contains("direction")) {
            buffer.append(" ");
            buffer.append(parameter.getDirection().getLiteral());
        }
        if (maskValues.contains("parametersName") || maskValues.contains("name")) {
            buffer.append(" ");
            buffer.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter));
        }
        if (maskValues.contains("parametersType") || maskValues.contains("type")) {
            if (parameter.getType() != null) {
                buffer.append(": " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)parameter.getType()));
            } else {
                buffer.append(": <Undefined>");
            }
        }
        if (maskValues.contains("parametersMultiplicity") || maskValues.contains("multiplicity")) {
            String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)parameter);
            buffer.append(multiplicity);
        }
        if ((maskValues.contains("parametersDefault") || maskValues.contains("defaultValue")) && parameter.getDefault() != null) {
            buffer.append(" = ");
            buffer.append(parameter.getDefault());
        }
        if (maskValues.contains("modifiers") && !(modifiers = ParameterUtil.getModifiersAsString(parameter, multiLine = maskValues.contains("multiline"))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    private static String getDefaultAsString(Parameter parameter, boolean equalSign) {
        String defaultString = "";
        if (parameter.getDefault() != null && !parameter.getDefault().equals("")) {
            if (equalSign) {
                defaultString = String.valueOf(defaultString) + "= ";
            }
            defaultString = String.valueOf(defaultString) + parameter.getDefault();
        }
        return "";
    }
}

