/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class WorkspaceSymbolService {
    @Inject
    @Extension
    private IResourceServiceProvider.Registry _registry;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public List<? extends SymbolInformation> getSymbols(String query, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        LinkedList result = CollectionLiterals.newLinkedList((Object[])new SymbolInformation[0]);
        Iterable _allResourceDescriptions = indexData.getAllResourceDescriptions();
        for (IResourceDescription resourceDescription : _allResourceDescriptions) {
            DocumentSymbolService documentSymbolService;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            IResourceServiceProvider resourceServiceProvider = this._registry.getResourceServiceProvider(resourceDescription.getURI());
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) continue;
            List<? extends SymbolInformation> _symbols = documentSymbolService.getSymbols(resourceDescription, query, resourceAccess, cancelIndicator);
            Iterables.addAll((Collection)result, _symbols);
        }
        return result;
    }
}

