/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemElement;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemElement;

public class CodanProblemCategory
extends CodanProblemElement
implements IProblemCategory,
Cloneable {
    private String id;
    private String name;
    private ArrayList<IProblemElement> list = new ArrayList();

    public CodanProblemCategory(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public IProblemElement[] getChildren() {
        return this.list.toArray(new IProblemElement[this.list.size()]);
    }

    public void addChild(IProblemElement p) {
        this.list.add(p);
        if (p instanceof CodanProblemElement) {
            CodanProblemElement cce = (CodanProblemElement)p;
            cce.setParentCategory(this);
            cce.setProfile(this.getProfile());
        }
    }

    public static IProblem findProblem(IProblemCategory c, String id) {
        IProblemElement[] children;
        IProblemElement[] iProblemElementArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p;
            IProblemElement object = iProblemElementArray[n2];
            if (object instanceof IProblemCategory) {
                IProblemCategory cat = (IProblemCategory)object;
                IProblem found = CodanProblemCategory.findProblem(cat, id);
                if (found != null) {
                    return found;
                }
            } else if (object instanceof IProblem && (p = (IProblem)object).getId().equals(id)) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    public static IProblemCategory[] findProblemCategories(IProblemCategory c, String id) {
        IProblemElement[] children;
        ArrayList<IProblemCategory> list = new ArrayList<IProblemCategory>();
        IProblemElement[] iProblemElementArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem p;
            IProblemElement object = iProblemElementArray[n2];
            if (object instanceof IProblemCategory) {
                IProblemCategory cat = (IProblemCategory)object;
                IProblemCategory[] found = CodanProblemCategory.findProblemCategories(cat, id);
                if (found.length > 0) {
                    list.addAll(Arrays.asList(found));
                }
            } else if (object instanceof IProblem && (p = (IProblem)object).getId().equals(id)) {
                list.add(c);
            }
            ++n2;
        }
        return list.toArray(new IProblemCategory[list.size()]);
    }

    public static IProblemCategory findCategory(IProblemCategory cat, String id) {
        IProblemElement[] children;
        if (cat.getId().equals(id)) {
            return cat;
        }
        IProblemElement[] iProblemElementArray = children = cat.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemCategory cat2;
            IProblemCategory found;
            IProblemElement object = iProblemElementArray[n2];
            if (object instanceof IProblemCategory && (found = CodanProblemCategory.findCategory(cat2 = (IProblemCategory)object, id)) != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Object clone() {
        CodanProblemCategory catClone = (CodanProblemCategory)super.clone();
        catClone.list = new ArrayList();
        for (IProblemElement child : this.list) {
            IProblemElement childClone = (IProblemElement)child.clone();
            if (childClone instanceof CodanProblemElement) {
                CodanProblemElement cce = (CodanProblemElement)childClone;
                boolean fro = cce.isFrozen();
                cce.setFrozen(false);
                cce.setParentCategory(catClone);
                cce.setFrozen(fro);
            }
            catClone.list.add(childClone);
        }
        return catClone;
    }

    @Override
    public void setProfile(IProblemProfile profile) {
        this.checkSet();
        super.setProfile(profile);
        for (IProblemElement child : this.list) {
            if (!(child instanceof CodanProblemElement)) continue;
            ((CodanProblemElement)child).setProfile(profile);
        }
    }

    @Override
    public void setFrozen(boolean b) {
        this.checkSet();
        super.setFrozen(b);
        for (IProblemElement child : this.list) {
            if (!(child instanceof CodanProblemElement)) continue;
            ((CodanProblemElement)child).setFrozen(b);
        }
    }
}

