/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.properties.observables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.table.IMatrixTableWidgetManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.EObjectWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.IWrapper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablewrapper.NattablewrapperFactory;
import org.eclipse.papyrus.uml.nattable.properties.observables.AbstractMatrixSourcesEMFObservableList;

public class MatrixRowSourcesEMFObservableList
extends AbstractMatrixSourcesEMFObservableList {
    public MatrixRowSourcesEMFObservableList(EditingDomain domain, Table table, IMatrixTableWidgetManager manager) {
        super(domain, table, manager, (IMasterAxisProvider)table.getCurrentRowAxisProvider(), (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_Sources());
    }

    public boolean remove(Object o) {
        if (this.isDisposed()) {
            return true;
        }
        Object toRemove = null;
        if (o instanceof IWrapper) {
            toRemove = (IWrapper)o;
        } else {
            for (Object currentContext : ((IMasterAxisProvider)this.source).getSources()) {
                if (!(currentContext instanceof IWrapper) || ((IWrapper)currentContext).getElement() != o) continue;
                toRemove = currentContext;
                break;
            }
        }
        Assert.isNotNull((Object)toRemove);
        return super.remove(toRemove);
    }

    public boolean addAll(Collection c) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        for (Object current : c) {
            if (current instanceof IWrapper) {
                toAdd.add((IWrapper)current);
                continue;
            }
            if (!(current instanceof EObject)) continue;
            EObjectWrapper wrapper = NattablewrapperFactory.eINSTANCE.createEObjectWrapper();
            wrapper.setElement((EObject)current);
            toAdd.add(wrapper);
        }
        Assert.isTrue((c.size() == toAdd.size() ? 1 : 0) != 0);
        return super.addAll(toAdd);
    }

    public Command getRemoveCommand(Object value) {
        Command cmd = super.getRemoveCommand(value);
        if (value instanceof IWrapper) {
            List<Object> coll = Collections.singletonList(((IWrapper)value).getElement());
            Command tmp = this.manager.getRowAxisManager().getDestroyAxisCommand((TransactionalEditingDomain)this.editingDomain, coll);
            if (tmp != null && tmp.canExecute()) {
                cmd = cmd.chain(tmp);
            }
        }
        return cmd;
    }

    public Command getAddAllCommand(Collection<?> values) {
        Command cmd = super.getAddAllCommand(values);
        ArrayList<EObject> toAdd = new ArrayList<EObject>();
        for (Object current : values) {
            if (!(current instanceof EObjectWrapper)) continue;
            toAdd.add(((EObjectWrapper)current).getElement());
        }
        Assert.isTrue((values.size() == toAdd.size() ? 1 : 0) != 0);
        Command tmp = this.manager.getAddRowElementCommand(toAdd);
        if (tmp != null && tmp.canExecute()) {
            cmd = cmd.chain(tmp);
        }
        return cmd;
    }

    public void clear() {
        super.clear();
    }

    public Command getAddCommand(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Command getAddCommand(Object value) {
        throw new UnsupportedOperationException();
    }

    public Command getAddAllCommand(int index, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    public Command getRemoveCommand(int index) {
        throw new UnsupportedOperationException();
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        Command cmd = super.getRemoveAllCommand(values);
        ArrayList<EObject> toRemove = new ArrayList<EObject>();
        for (Object current : values) {
            if (!(current instanceof EObjectWrapper)) continue;
            toRemove.add(((EObjectWrapper)current).getElement());
        }
        Assert.isTrue((values.size() == toRemove.size() ? 1 : 0) != 0);
        Command tmp = this.manager.getRowAxisManager().getDestroyAxisCommand((TransactionalEditingDomain)this.editingDomain, toRemove);
        if (tmp != null && tmp.canExecute()) {
            cmd = cmd.chain(tmp);
        }
        return cmd;
    }

    public Command getRetainAllCommand(Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    public Command getSetCommand(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }
}

