/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ConfigurationSetRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherFactory;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ElementTypeRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Extension
    private static StereotypeApplicationMatcherFactory stereotypeApplicationMatcherConfigurationFactory = StereotypeApplicationMatcherFactory.eINSTANCE;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private Identifiers _identifiers;
    private final HashMap<ArrayList<?>, SpecializationTypeConfiguration> _createCache_toElementType = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private final HashMap<ArrayList<?>, StereotypeApplicationMatcherConfiguration> _createCache_toMatcherConfiguration = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecializationTypeConfiguration toElementType(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        SpecializationTypeConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, SpecializationTypeConfiguration> hashMap = this._createCache_toElementType;
        synchronized (hashMap) {
            SpecializationTypeConfiguration _createSpecializationTypeConfiguration;
            if (this._createCache_toElementType.containsKey(_cacheKey)) {
                return this._createCache_toElementType.get(_cacheKey);
            }
            _result = _createSpecializationTypeConfiguration = elementtypesconfigurationsFactory.createSpecializationTypeConfiguration();
            this._createCache_toElementType.put(_cacheKey, _result);
        }
        this._init_toElementType(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toElementType(SpecializationTypeConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        boolean _not;
        it.setIdentifier(this._identifiers.toElementTypeID(umlExtension, supertype));
        boolean _hasSemanticSupertype = this._uMLElementTypes.hasSemanticSupertype(supertype);
        if (_hasSemanticSupertype) {
            SpecializationTypeConfiguration baseType = elementtypesconfigurationsFactory.createSpecializationTypeConfiguration();
            String baseTypeId = this._identifiers.toElementTypeID(umlExtension, this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()));
            baseType.setIdentifier(baseTypeId);
            baseType.getSpecializedTypes().add((Object)this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()));
            baseType.setHint(this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass()).getHint());
            baseType.setName(this._identifiers.toElementTypeName(umlExtension, this._uMLElementTypes.getElementTypeConfiguration(umlExtension.getMetaclass())));
            IconEntry icon = this.getIconEntry(umlExtension.getStereotype());
            IconEntry _xifexpression = null;
            boolean _notEquals = !Objects.equal((Object)icon, null);
            _xifexpression = _notEquals ? icon : this._uMLElementTypes.getIconEntry(umlExtension.getMetaclass());
            baseType.setIconEntry(_xifexpression);
            ElementTypeConfiguration addedBaseType = ConfigurationSetRule.addElementType((ElementTypeConfiguration)baseType);
            it.getSpecializedTypes().add((Object)addedBaseType);
        }
        it.getSpecializedTypes().add((Object)supertype);
        it.setHint(supertype.getHint());
        it.setName(this._identifiers.toElementTypeName(umlExtension, supertype));
        IconEntry icon_1 = this.getIconEntry(umlExtension.getStereotype());
        IconEntry _xifexpression_1 = null;
        boolean _notEquals_1 = !Objects.equal((Object)icon_1, null);
        _xifexpression_1 = _notEquals_1 ? icon_1 : this._uMLElementTypes.getIconEntry(umlExtension.getMetaclass());
        it.setIconEntry(_xifexpression_1);
        boolean _hasSemanticSupertype_1 = this._uMLElementTypes.hasSemanticSupertype(supertype);
        boolean bl = _not = !_hasSemanticSupertype_1;
        if (_not) {
            it.setMatcherConfiguration((AbstractMatcherConfiguration)this.toMatcherConfiguration(umlExtension, supertype));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StereotypeApplicationMatcherConfiguration toMatcherConfiguration(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        StereotypeApplicationMatcherConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, supertype});
        HashMap<ArrayList<?>, StereotypeApplicationMatcherConfiguration> hashMap = this._createCache_toMatcherConfiguration;
        synchronized (hashMap) {
            StereotypeApplicationMatcherConfiguration _createStereotypeApplicationMatcherConfiguration;
            if (this._createCache_toMatcherConfiguration.containsKey(_cacheKey)) {
                return this._createCache_toMatcherConfiguration.get(_cacheKey);
            }
            _result = _createStereotypeApplicationMatcherConfiguration = stereotypeApplicationMatcherConfigurationFactory.createStereotypeApplicationMatcherConfiguration();
            this._createCache_toMatcherConfiguration.put(_cacheKey, _result);
        }
        this._init_toMatcherConfiguration(_result, umlExtension, supertype);
        return _result;
    }

    private void _init_toMatcherConfiguration(StereotypeApplicationMatcherConfiguration it, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        it.getStereotypesQualifiedNames().add((Object)umlExtension.getStereotype().getQualifiedName());
    }

    private IconEntry getIconEntry(final Stereotype stereotype) {
        boolean _notEquals;
        IconEntry _xblockexpression = null;
        Functions.Function1<Image, Boolean> _function = new Functions.Function1<Image, Boolean>(){

            public Boolean apply(Image it) {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getLocation());
                return !_isNullOrEmpty;
            }
        };
        Image image = (Image)IterableExtensions.findFirst((Iterable)stereotype.getIcons(), (Functions.Function1)_function);
        IconEntry _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)image, null);
        if (_notEquals) {
            boolean _notEquals_1;
            IconEntry _xblockexpression_1 = null;
            final URI uri = URI.createURI((String)image.getLocation(), (boolean)true);
            IconEntry _xifexpression_1 = null;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)uri, null);
            if (_notEquals_1) {
                IconEntry _createIconEntry = elementtypesconfigurationsFactory.createIconEntry();
                Procedures.Procedure1<IconEntry> _function_1 = new Procedures.Procedure1<IconEntry>(){

                    public void apply(IconEntry it) {
                        boolean _isPlatform = uri.isPlatform();
                        if (_isPlatform) {
                            it.setBundleId(uri.segment(1));
                            Functions.Function1<String, CharSequence> _function = new Functions.Function1<String, CharSequence>(){

                                public CharSequence apply(String it) {
                                    return URI.decode((String)it);
                                }
                            };
                            String _join = IterableExtensions.join((Iterable)IterableExtensions.drop((Iterable)uri.segmentsList(), (int)2), (CharSequence)"/", (Functions.Function1)_function);
                            String _plus = "/" + _join;
                            it.setIconPath(_plus);
                        } else {
                            boolean _isRelative = uri.isRelative();
                            if (_isRelative) {
                                it.setBundleId(ElementTypeRule.this.containingProject((EObject)stereotype).getName());
                                String _decode = URI.decode((String)uri.toString());
                                String _plus_1 = "/" + _decode;
                                it.setIconPath(_plus_1);
                            } else {
                                it.setIconPath(uri.toString());
                            }
                        }
                    }
                };
                _xifexpression_1 = (IconEntry)ObjectExtensions.operator_doubleArrow((Object)_createIconEntry, (Procedures.Procedure1)_function_1);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private IProject containingProject(EObject object) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(object.eResource().getURI().segment(2));
    }
}

