/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.StringTokenizer;
import org.eclipse.help.internal.search.InfoCenter;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.ui.ISearchScopeFactory;
import org.eclipse.jface.preference.IPreferenceStore;

public class InfoCenterSearchScopeFactory
implements ISearchScopeFactory {
    public static final String P_URL = "url";
    public static final String P_SEARCH_SELECTED = "searchSelected";
    public static final String P_TOCS = "tocs";
    public static final String TOC_SEPARATOR = ";";

    @Override
    public ISearchScope createSearchScope(IPreferenceStore store, String engineId, Dictionary<String, Object> parameters) {
        String tvalue;
        String url = this.getProperty(P_URL, store, engineId, parameters);
        String ssvalue = this.getProperty(P_SEARCH_SELECTED, store, engineId, parameters);
        boolean searchSelected = ssvalue != null && ssvalue.equalsIgnoreCase("true");
        String[] tocs = null;
        if (searchSelected && (tvalue = this.getProperty(P_TOCS, store, engineId, parameters)) != null && tvalue.length() > 0) {
            StringTokenizer stok = new StringTokenizer(tvalue, TOC_SEPARATOR);
            ArrayList<String> list = new ArrayList<String>();
            while (stok.hasMoreTokens()) {
                String toc = stok.nextToken();
                list.add(toc);
            }
            if (list.size() > 0) {
                tocs = list.toArray(new String[list.size()]);
            }
        }
        return new InfoCenter.Scope(url, searchSelected, tocs);
    }

    private String getProperty(String key, IPreferenceStore store, String engineId, Dictionary<String, Object> parameters) {
        String value = store.getString(String.valueOf(engineId) + "." + key);
        if (value != null && value.length() > 0) {
            return value;
        }
        return (String)parameters.get(key);
    }
}

