/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.PapyrusFacetContentProviderWrapper;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.context.PapyrusContextUtil;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.gmf.runtime.notation.Diagram;

public class PapyrusGroupProvider
extends AbstractDifferenceGroupProvider {
    protected Collection<? extends IDifferenceGroup> buildGroups(Comparison comparison2) {
        PapyrusDifferenceGroup group = new PapyrusDifferenceGroup(this.getComparison(), this.getCrossReferenceAdapter());
        group.buildSubTree();
        return ImmutableList.of((Object)((Object)group));
    }

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        return super.isEnabled(scope, comparison) && PapyrusContextUtil.isPapyrusContext(comparison);
    }

    public static class PapyrusDifferenceGroup
    extends BasicDifferenceGroupImpl {
        private Map<EObject, TreeNode> valueToMatchNode = new HashMap<EObject, TreeNode>();
        private HashMap<Diagram, EObject> diagramToContextualParent = new HashMap();

        public PapyrusDifferenceGroup(Comparison comparison, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, Predicates.alwaysTrue(), crossReferenceAdapter);
            this.retrieveContextualDiagramParents(IMergeViewer.MergeViewerSide.LEFT);
            this.retrieveContextualDiagramParents(IMergeViewer.MergeViewerSide.RIGHT);
        }

        private void retrieveContextualDiagramParents(IMergeViewer.MergeViewerSide side) {
            ResourceSet resourceSet = this.getResourceSet(this.getComparison(), side);
            if (resourceSet != null) {
                PapyrusFacetContentProviderWrapper facetContentProviderWrapper = new PapyrusFacetContentProviderWrapper(null, resourceSet);
                for (Object root : facetContentProviderWrapper.getElements(null)) {
                    this.retrieveDiagramParents(root, facetContentProviderWrapper);
                }
            }
        }

        private void retrieveDiagramParents(Object object, PapyrusFacetContentProviderWrapper facetContentProviderWrapper) {
            for (Object child : facetContentProviderWrapper.getChildren(object)) {
                if (child instanceof Diagram && !this.diagramToContextualParent.containsKey(child)) {
                    this.diagramToContextualParent.put((Diagram)child, (EObject)object);
                }
                this.retrieveDiagramParents(child, facetContentProviderWrapper);
            }
        }

        protected List<TreeNode> buildMatchTrees() {
            ArrayList<TreeNode> matchTrees = new ArrayList<TreeNode>();
            EList matches = this.getComparison().getMatches();
            for (Match match : Collections2.filter((Collection)matches, (Predicate)Predicates.not(this.isMatchValueInstanceOf(Diagram.class)))) {
                MatchNode matchNode = this.buildTree(match);
                if (matchNode == null) continue;
                matchTrees.add((TreeNode)matchNode);
            }
            for (Match match : Collections2.filter((Collection)matches, this.isMatchValueInstanceOf(Diagram.class))) {
                MatchNode diagramNode = this.buildTree(match);
                if (diagramNode == null) continue;
                TreeNode parentNode = this.retrieveParentNode((TreeNode)diagramNode, this.getParent(this.getMatchValue(match)));
                parentNode.getChildren().add((Object)diagramNode);
                diagramNode.setParent(parentNode);
            }
            return matchTrees;
        }

        private Predicate<Match> isMatchValueInstanceOf(final Class<?> clazz) {
            return new Predicate<Match>(){

                public boolean apply(Match match) {
                    return clazz.isInstance(PapyrusDifferenceGroup.this.getMatchValue(match));
                }
            };
        }

        private TreeNode createTreeNode(EObject data) {
            TreeNode node = TreeFactory.eINSTANCE.createTreeNode();
            node.setData(data);
            return node;
        }

        private TreeNode retrieveParentNode(TreeNode childNode, EObject parentObject) {
            TreeNode parentNode = this.getOrCreateParentNode(childNode, parentObject);
            if (!(parentNode instanceof MatchNode)) {
                this.createSubTree(parentNode, this.getParent(parentObject));
            }
            return parentNode;
        }

        private TreeNode getOrCreateParentNode(TreeNode childNode, EObject parentObject) {
            TreeNode parentNode = this.valueToMatchNode.get(parentObject);
            if (parentNode == null) {
                parentNode = this.createTreeNode(parentObject);
            }
            childNode.setParent(parentNode);
            parentNode.getChildren().add((Object)childNode);
            return parentNode;
        }

        private EObject getParent(EObject value) {
            if (value instanceof Diagram) {
                return this.diagramToContextualParent.get(value);
            }
            return value.eContainer();
        }

        private void createSubTree(TreeNode treeNode, EObject parentObject) {
            if (parentObject == null) {
                this.children.add(treeNode);
                return;
            }
            TreeNode parentNode = this.getOrCreateParentNode(treeNode, parentObject);
            treeNode.setParent(parentNode);
            parentNode.getChildren().add((Object)treeNode);
            if (parentNode instanceof MatchNode) {
                return;
            }
            this.createSubTree(parentNode, this.getParent(parentObject));
        }

        protected void populateMatchNode(MatchNode matchNode) {
            super.populateMatchNode(matchNode);
            if (!matchNode.getChildren().isEmpty()) {
                this.valueToMatchNode.put(this.getMatchValue(matchNode.getMatch()), (TreeNode)matchNode);
            }
        }

        private EObject getMatchValue(Match match) {
            if (match.getLeft() != null) {
                return match.getLeft();
            }
            if (match.getRight() != null) {
                return match.getRight();
            }
            return match.getOrigin();
        }

        private ResourceSet getResourceSet(Comparison comparison, IMergeViewer.MergeViewerSide side) {
            for (MatchResource matchResource : comparison.getMatchedResources()) {
                Resource resource = this.getResource(matchResource, side);
                if (resource == null) continue;
                return resource.getResourceSet();
            }
            return null;
        }

        private Resource getResource(MatchResource matchResource, IMergeViewer.MergeViewerSide side) {
            if (side == IMergeViewer.MergeViewerSide.LEFT) {
                return matchResource.getLeft();
            }
            if (side == IMergeViewer.MergeViewerSide.RIGHT) {
                return matchResource.getRight();
            }
            if (side == IMergeViewer.MergeViewerSide.ANCESTOR) {
                return matchResource.getOrigin();
            }
            return null;
        }
    }
}

