/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class BreakpointActionManager {
    public static final String BREAKPOINT_ACTION_ATTRIBUTE = "BREAKPOINT_ACTIONS";
    private static final String BREAKPOINT_ACTION_DATA = "BreakpointActionManager.actionData";
    private IExtension[] breakpointActionExtensions = null;
    private ArrayList<IBreakpointAction> breakpointActions = null;

    public void addAction(IBreakpointAction action) {
        this.getBreakpointActions().add(action);
    }

    private IBreakpointAction createActionFromClassName(String name, String className) {
        IBreakpointAction action = null;
        IExtension[] actionExtensions = CDebugCorePlugin.getDefault().getBreakpointActionManager().getBreakpointActionExtensions();
        try {
            int i = 0;
            while (i < actionExtensions.length && action == null) {
                IConfigurationElement[] elements = actionExtensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length && action == null) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("actionType") && element.getAttribute("class").equals(className)) {
                        action = (IBreakpointAction)element.createExecutableExtension("class");
                        action.setName(name);
                        CDebugCorePlugin.getDefault().getBreakpointActionManager().addAction(action);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return action;
    }

    public void deleteAction(IBreakpointAction action) {
        this.getBreakpointActions().remove(action);
    }

    public boolean breakpointHasActions(IBreakpoint breakpoint) {
        if (breakpoint != null) {
            IMarker marker = breakpoint.getMarker();
            String actionNames = marker.getAttribute(BREAKPOINT_ACTION_ATTRIBUTE, "");
            return actionNames.length() > 0;
        }
        return false;
    }

    public void executeActions(final IBreakpoint breakpoint, final IAdaptable context) {
        String[] actions;
        IMarker marker;
        String actionNames;
        if (breakpoint != null && (actionNames = (marker = breakpoint.getMarker()).getAttribute(BREAKPOINT_ACTION_ATTRIBUTE, "")).length() > 0 && (actions = actionNames.split(",")).length > 0) {
            Job job = new Job("Execute breakpoint actions"){

                public IStatus run(IProgressMonitor monitor) {
                    return BreakpointActionManager.this.doExecuteActions(breakpoint, context, actions, monitor);
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private IStatus doExecuteActions(IBreakpoint breakpoint, IAdaptable context, String[] actions, IProgressMonitor monitor) {
        try {
            int i = 0;
            while (i < actions.length && !monitor.isCanceled()) {
                String actionName = actions[i];
                IBreakpointAction action = this.findBreakpointAction(actionName);
                if (action != null) {
                    monitor.setTaskName(action.getSummary());
                    IStatus status = action.execute(breakpoint, context, monitor);
                    if (status.getCode() != 0) {
                        if (status.getCode() != 8) {
                            CDebugCorePlugin.log(status);
                        }
                        return status;
                    }
                }
                monitor.worked(1);
                ++i;
            }
        }
        catch (Exception e) {
            return new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal Error", (Throwable)e);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public IBreakpointAction findBreakpointAction(String name) {
        for (IBreakpointAction action : this.getBreakpointActions()) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return null;
    }

    public IExtension[] getBreakpointActionExtensions() {
        if (this.breakpointActionExtensions == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.debug.core", "BreakpointActionType");
            this.breakpointActionExtensions = point == null ? new IExtension[0] : point.getExtensions();
        }
        return this.breakpointActionExtensions;
    }

    public ArrayList<IBreakpointAction> getBreakpointActions() {
        if (this.breakpointActions == null) {
            this.breakpointActions = new ArrayList();
            CDebugCorePlugin.getDefault().getBreakpointActionManager().loadActionData();
        }
        return this.breakpointActions;
    }

    private void loadActionData() {
        String actionData = CDebugCorePlugin.getDefault().getPluginPreferences().getString(BREAKPOINT_ACTION_DATA);
        if (actionData == null || actionData.length() == 0) {
            return;
        }
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(actionData))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int entryCount = nodeList.getLength();
            int i = 0;
            while (i < entryCount) {
                Element subElement;
                String nodeName;
                Node node = nodeList.item(i);
                short type = node.getNodeType();
                if (type == 1 && (nodeName = (subElement = (Element)node).getNodeName()).equalsIgnoreCase("actionEntry")) {
                    String name = subElement.getAttribute("name");
                    if (name == null) {
                        throw new Exception();
                    }
                    String value = subElement.getAttribute("value");
                    if (value == null) {
                        throw new Exception();
                    }
                    String className = subElement.getAttribute("class");
                    if (className == null) {
                        throw new Exception();
                    }
                    IBreakpointAction action = this.createActionFromClassName(name, className);
                    action.initializeFromMemento(value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String makeUniqueActionName(String defaultName) {
        String result = defaultName;
        IBreakpointAction action = this.findBreakpointAction(defaultName);
        int actionCount = 1;
        while (action != null) {
            result = String.valueOf(defaultName) + "(" + actionCount + ")";
            action = this.findBreakpointAction(result);
            ++actionCount;
        }
        return result;
    }

    public void revertActionData() {
        this.breakpointActions = null;
    }

    public void saveActionData() {
        String actionData = "";
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("breakpointActionData");
            doc.appendChild(rootElement);
            for (IBreakpointAction action : this.getBreakpointActions()) {
                Element element = doc.createElement("actionEntry");
                element.setAttribute("name", action.getName());
                element.setAttribute("class", action.getClass().getName());
                element.setAttribute("value", action.getMemento());
                rootElement.appendChild(element);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            actionData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(BREAKPOINT_ACTION_DATA, actionData);
        CDebugCorePlugin.getDefault().savePluginPreferences();
    }
}

