/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.default_.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.interoperability.rsa.default_.DefaultFactory;
import org.eclipse.papyrus.interoperability.rsa.default_.DefaultLanguage;
import org.eclipse.papyrus.interoperability.rsa.default_.DefaultPackage;
import org.eclipse.papyrus.interoperability.rsa.default_.Documentation;
import org.eclipse.papyrus.interoperability.rsa.default_.Link;
import org.eclipse.papyrus.interoperability.rsa.default_.MarkingImport;
import org.eclipse.papyrus.interoperability.rsa.default_.MarkingModel;
import org.eclipse.papyrus.interoperability.rsa.default_.MetaConstraint;
import org.eclipse.papyrus.interoperability.rsa.default_.Mode;
import org.eclipse.papyrus.interoperability.rsa.default_.Severity;
import org.eclipse.papyrus.interoperability.rsa.default_.URL;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.DefaultLanguageImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.DocumentationImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.LinkImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.MarkingImportImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.MarkingModelImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.MetaConstraintImpl;
import org.eclipse.papyrus.interoperability.rsa.default_.impl.URLImpl;

public class DefaultFactoryImpl
extends EFactoryImpl
implements DefaultFactory {
    public static DefaultFactory init() {
        try {
            DefaultFactory theDefaultFactory = (DefaultFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/profile/default");
            if (theDefaultFactory != null) {
                return theDefaultFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DefaultFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDocumentation();
            }
            case 1: {
                return this.createURL();
            }
            case 2: {
                return this.createLink();
            }
            case 4: {
                return this.createMetaConstraint();
            }
            case 5: {
                return this.createMarkingModel();
            }
            case 6: {
                return this.createMarkingImport();
            }
            case 7: {
                return this.createDefaultLanguage();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createModeFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertModeToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Documentation createDocumentation() {
        DocumentationImpl documentation = new DocumentationImpl();
        return documentation;
    }

    @Override
    public URL createURL() {
        URLImpl url = new URLImpl();
        return url;
    }

    @Override
    public Link createLink() {
        LinkImpl link = new LinkImpl();
        return link;
    }

    @Override
    public MetaConstraint createMetaConstraint() {
        MetaConstraintImpl metaConstraint = new MetaConstraintImpl();
        return metaConstraint;
    }

    @Override
    public MarkingModel createMarkingModel() {
        MarkingModelImpl markingModel = new MarkingModelImpl();
        return markingModel;
    }

    @Override
    public MarkingImport createMarkingImport() {
        MarkingImportImpl markingImport = new MarkingImportImpl();
        return markingImport;
    }

    @Override
    public DefaultLanguage createDefaultLanguage() {
        DefaultLanguageImpl defaultLanguage = new DefaultLanguageImpl();
        return defaultLanguage;
    }

    public Mode createModeFromString(EDataType eDataType, String initialValue) {
        Mode result = Mode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DefaultPackage getDefaultPackage() {
        return (DefaultPackage)this.getEPackage();
    }

    @Deprecated
    public static DefaultPackage getPackage() {
        return DefaultPackage.eINSTANCE;
    }
}

