/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.handler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.properties.ui.creation.PropertyEditorFactory;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;
import org.eclipse.papyrus.interoperability.rsa.internal.ConfigurationManager;
import org.eclipse.papyrus.interoperability.rsa.transformation.ImportTransformationLauncher;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        HashSet<IFile> filesToImport = new HashSet<IFile>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                String fileExtension;
                IFile selectedFile;
                if (!(selectedElement instanceof IAdaptable) || (selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class)) == null || !"epx".equals(fileExtension = selectedFile.getFileExtension()) && !"emx".equals(fileExtension)) continue;
                filesToImport.add(selectedFile);
            }
        }
        if (filesToImport.isEmpty()) {
            Activator.log.warn("The selection doesn't contain any *.epx nor *.emx file");
        } else {
            this.importFiles(filesToImport, event);
        }
        return null;
    }

    public void importFiles(Set<IFile> selectedFiles, ExecutionEvent event) {
        Config config = this.getTransformationParameters(event);
        if (config == null) {
            return;
        }
        LinkedList<URI> urisToImport = new LinkedList<URI>();
        for (IFile selectedFile : selectedFiles) {
            URI uri = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
            urisToImport.add(uri);
        }
        Shell baseControl = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (baseControl != null && !baseControl.isDisposed() && baseControl.getParent() != null) {
            baseControl = baseControl.getParent();
        }
        if (baseControl == null || baseControl.isDisposed()) {
            baseControl = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        ImportTransformationLauncher launcher = new ImportTransformationLauncher(config, (Control)baseControl);
        launcher.run(urisToImport);
    }

    public Config getTransformationParameters(ExecutionEvent event) {
        Config config = RSAToPapyrusParametersFactory.eINSTANCE.createConfig();
        ConfigurationManager configMan = new ConfigurationManager();
        configMan.loadConfig(config);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        final AtomicBoolean okPressed = new AtomicBoolean(true);
        PropertyEditorFactory factory = new PropertyEditorFactory(){

            public String getEditionDialogTitle(Object objectToEdit) {
                return "Transformation parameters";
            }

            protected void handleEditCancelled(Control widget, Object source) {
                okPressed.set(false);
                super.handleEditCancelled(widget, source);
            }
        };
        Object result = factory.edit((Control)activeShell, (Object)config);
        if (!okPressed.get()) {
            configMan.dispose();
            return null;
        }
        if (result instanceof Config) {
            config = (Config)result;
        }
        configMan.saveConfig(config);
        configMan.dispose();
        return config;
    }
}

