/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.internal;

import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;

public class ConfigurationManager {
    private ResourceSet rset = new ResourceSetImpl();
    private Resource configResource;
    private Config config;

    public ConfigurationManager() {
        URI configURI = URI.createFileURI((String)Activator.getDefault().getStateLocation().toOSString()).appendSegment("config.xmi");
        try {
            this.configResource = this.rset.getResource(configURI, true);
        }
        catch (Exception e) {
            this.configResource = this.rset.getResource(configURI, false);
        }
        EList contents = this.configResource.getContents();
        if (!contents.isEmpty() && contents.get(0) instanceof Config) {
            this.config = (Config)contents.get(0);
        } else {
            this.config = RSAToPapyrusParametersFactory.eINSTANCE.createConfig();
            contents.clear();
            contents.add((Object)this.config);
        }
    }

    public void dispose() {
        this.config = null;
        this.configResource = null;
        EMFHelper.unload((ResourceSet)this.rset);
    }

    public void loadConfig(final Config config) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){
            private static final long serialVersionUID = 1L;

            protected EObject createCopy(EObject eObject) {
                return eObject == ConfigurationManager.this.config ? config : super.createCopy(eObject);
            }
        };
        copier.copy((EObject)this.config);
    }

    public void saveConfig(Config newConfig) {
        try {
            if (newConfig == null) {
                this.configResource.delete(null);
            } else if (!EcoreUtil.equals((EObject)this.config, (EObject)newConfig)) {
                EcoreUtil.replace((EObject)this.config, (EObject)EcoreUtil.copy((EObject)newConfig));
                this.configResource.save(null);
            }
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

