/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.transformation;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.MappingParameters;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.URIMapping;
import org.eclipse.papyrus.interoperability.rsa.concurrent.ThreadSafeResourceSet;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.uml2.uml.Element;

public class DependencyAnalysisHelper {
    protected final Config config;
    protected static final Set<String> rsaExtensions = Sets.newHashSet((Object[])new String[]{"emx", "efx"});
    protected static final String rsaProfileExtension = "epx";
    protected final ResourceSet localResourceSet = new ThreadSafeResourceSet();
    protected final Map<URI, Set<String>> brokenUris = new HashMap<URI, Set<String>>();
    protected final Set<URI> brokenProfiles = new HashSet<URI>();

    public DependencyAnalysisHelper(Config config) {
        this.config = config;
        this.configureResourceSet();
    }

    protected void configureResourceSet() {
        this.localResourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
        this.localResourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        this.localResourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        this.localResourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
    }

    protected void unloadResourceSet() {
        EMFHelper.unload((ResourceSet)this.localResourceSet);
    }

    public void computeURIMappings(Collection<Resource> sourceModels) {
        for (Resource sourceModel : sourceModels) {
            this.doComputeURIMappings(sourceModel);
        }
    }

    public synchronized void resolveAllMappings(Map<URI, URI> urisToReplace, Map<URI, URI> profileUrisToReplace) {
        if (this.config.getMappingParameters() == null) {
            this.config.setMappingParameters(RSAToPapyrusParametersFactory.eINSTANCE.createMappingParameters());
        }
        try {
            for (Map.Entry<URI, Set<String>> resourceToRepair : this.brokenUris.entrySet()) {
                if (urisToReplace.containsKey(resourceToRepair.getKey())) continue;
                this.findMatch(resourceToRepair.getKey(), resourceToRepair.getValue());
            }
            for (URI profileDefinition : this.brokenProfiles) {
                if (profileUrisToReplace.containsKey(profileDefinition.trimFragment().trimQuery())) continue;
                this.findMatch(profileDefinition);
            }
        }
        finally {
            this.unloadResourceSet();
            this.brokenUris.clear();
            this.brokenProfiles.clear();
        }
    }

    protected void findMatch(URI resourceURI, Set<String> fragments) {
        URIMapping mapping = null;
        for (String fragment : fragments) {
            URI eObjectURI = resourceURI.appendFragment(fragment);
            mapping = this.findExistingMapping(eObjectURI, this.localResourceSet);
            if (mapping != null) break;
        }
        if (mapping == null) {
            mapping = RSAToPapyrusParametersFactory.eINSTANCE.createURIMapping();
            mapping.setSourceURI(resourceURI.toString());
            mapping.setTargetURI(mapping.getSourceURI());
        }
        this.config.getMappingParameters().getUriMappings().add((Object)mapping);
    }

    protected void findMatch(URI profileDefinitionURI) {
        URIMapping match = this.findExistingProfileMapping(profileDefinitionURI, this.localResourceSet);
        if (match == null) {
            match = RSAToPapyrusParametersFactory.eINSTANCE.createURIMapping();
            match.setSourceURI(profileDefinitionURI.trimFragment().trimQuery().toString());
            match.setTargetURI(match.getSourceURI());
        }
        this.config.getMappingParameters().getProfileUriMappings().add((Object)match);
    }

    protected void doComputeURIMappings(Resource sourceModel) {
        this.doComputeProfileURIMappings(sourceModel);
        TreeIterator resourceContents = sourceModel.getAllContents();
        ResourceSet resourceSet = sourceModel.getResourceSet();
        while (resourceContents.hasNext()) {
            EObject next = (EObject)resourceContents.next();
            for (EReference reference : next.eClass().getEAllReferences()) {
                if (reference.isContainer() || reference.isContainment() || reference.isDerived() || reference.isTransient()) continue;
                Object value = next.eGet((EStructuralFeature)reference, false);
                if (value instanceof EObject) {
                    this.handleURIMapping((EObject)value, resourceSet);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                for (Object element : (Collection)value) {
                    if (!(element instanceof EObject)) continue;
                    this.handleURIMapping((EObject)element, resourceSet);
                }
            }
        }
    }

    protected void doComputeProfileURIMappings(Resource sourceModel) {
        ResourceSet resourceSet = sourceModel.getResourceSet();
        for (EObject rootObject : sourceModel.getContents()) {
            if (!this.isInvalidStereotypeApplication(rootObject)) continue;
            this.handleProfileURIMapping(rootObject, resourceSet);
        }
    }

    protected boolean isInvalidStereotypeApplication(EObject eObject) {
        if (eObject instanceof Element) {
            return false;
        }
        if (eObject instanceof AnyType) {
            return true;
        }
        EPackage ePackage = eObject.eClass().getEPackage();
        return rsaProfileExtension.equals(ePackage.eResource().getURI().fileExtension());
    }

    protected boolean isRSAModelElement(EObject eObject) {
        return this.isRSAModelElement(EcoreUtil.getURI((EObject)eObject));
    }

    protected boolean isRSAModelElement(URI objectURI) {
        String fileExtension = objectURI.fileExtension();
        return rsaExtensions.contains(fileExtension) || rsaProfileExtension.equals(fileExtension);
    }

    protected synchronized Set<String> getFragments(URI resourceURI) {
        if (!this.brokenUris.containsKey(resourceURI)) {
            this.brokenUris.put(resourceURI, new HashSet());
        }
        return this.brokenUris.get(resourceURI);
    }

    protected synchronized void handleBrokenReference(EObject proxy) {
        URI proxyURI = EcoreUtil.getURI((EObject)proxy);
        URI resourceURI = proxyURI.trimFragment().trimQuery();
        String fragment = proxyURI.fragment();
        Set<String> fragments = this.getFragments(resourceURI);
        fragments.add(fragment);
    }

    protected synchronized void addBrokenProfileDefinition(URI packageURI) {
        this.brokenProfiles.add(packageURI);
    }

    protected void handleProfileURIMapping(EObject stereotypeApplication, ResourceSet resourceSet) {
        EPackage profileDefinition = stereotypeApplication.eClass().getEPackage();
        URI packageURI = EcoreUtil.getURI((EObject)profileDefinition);
        if (packageURI.trimFragment().isEmpty()) {
            packageURI = URI.createURI((String)profileDefinition.getNsURI());
        }
        this.addBrokenProfileDefinition(packageURI);
    }

    protected void handleURIMapping(EObject eObject, ResourceSet resourceSet) {
        if (this.isRSAModelElement(eObject)) {
            this.handleBrokenReference(eObject);
            return;
        }
        if (eObject.eIsProxy() && (eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet)).eIsProxy()) {
            this.handleBrokenReference(eObject);
            return;
        }
    }

    protected URIMapping findExistingProfileMapping(URI profileDefinitionURI, ResourceSet resourceSet) {
        String fileExtension = profileDefinitionURI.fileExtension();
        URIMapping mapping = RSAToPapyrusParametersFactory.eINSTANCE.createURIMapping();
        URI sourceURI = profileDefinitionURI.trimFragment().trimQuery();
        mapping.setSourceURI(sourceURI.toString());
        URI targetURI = null;
        if (rsaProfileExtension.equals(fileExtension)) {
            targetURI = sourceURI.trimFileExtension().appendFileExtension("profile").appendFileExtension("uml");
            try {
                Resource resource = resourceSet.getResource(targetURI, true);
                if (resource != null && !resource.getContents().isEmpty()) {
                    mapping.setTargetURI(targetURI.toString());
                    return mapping;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.findExistingMapping(profileDefinitionURI, resourceSet);
    }

    protected URIMapping findExistingMapping(URI proxyURI, ResourceSet resourceSet) {
        EObject resolvedElement;
        String fileExtension = proxyURI.fileExtension();
        URIMapping mapping = RSAToPapyrusParametersFactory.eINSTANCE.createURIMapping();
        mapping.setSourceURI(proxyURI.trimFragment().trimQuery().toString());
        URI targetURI = null;
        if (rsaExtensions.contains(fileExtension)) {
            targetURI = proxyURI.trimFileExtension().appendFileExtension("uml");
        } else if (rsaProfileExtension.equals(fileExtension)) {
            targetURI = proxyURI.trimFileExtension().appendFileExtension("profile.uml");
        }
        if (targetURI != null) {
            try {
                EObject targetElement = resourceSet.getEObject(targetURI, true);
                if (targetElement != null) {
                    targetURI = EcoreUtil.getURI((EObject)targetElement);
                    mapping.setTargetURI(targetURI.trimFragment().trimQuery().toString());
                    return mapping;
                }
            }
            catch (Exception targetElement) {
                // empty catch block
            }
        }
        if (!this.isRSAModelElement(proxyURI)) {
            URI resourceURI = proxyURI.trimFragment().trimQuery();
            try {
                Resource resource = resourceSet.getResource(resourceURI, true);
                if (resource != null && !resource.getContents().isEmpty()) {
                    mapping.setTargetURI(resourceURI.toString());
                    return mapping;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isPathFragment(proxyURI)) {
            return null;
        }
        for (IRegisteredLibrary library : RegisteredLibrary.getRegisteredLibraries()) {
            URI libraryURI = library.getUri();
            try {
                Resource libraryResource = this.localResourceSet.getResource(libraryURI, true);
                if (libraryResource == null || (resolvedElement = libraryResource.getEObject(proxyURI.fragment())) == null || resolvedElement.eIsProxy()) continue;
                mapping.setTargetURI(libraryURI.toString());
                return mapping;
            }
            catch (Exception libraryResource) {
                // empty catch block
            }
        }
        for (IRegisteredProfile profile : RegisteredProfile.getRegisteredProfiles()) {
            URI profileURI = profile.getUri();
            try {
                Resource profileResource = this.localResourceSet.getResource(profileURI, true);
                if (profileResource == null || (resolvedElement = profileResource.getEObject(proxyURI.fragment())) == null || resolvedElement.eIsProxy()) continue;
                mapping.setTargetURI(profileURI.toString());
                return mapping;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isPathFragment(URI proxyURI) {
        String uriFragment = proxyURI.fragment();
        return uriFragment != null && uriFragment.charAt(0) == '/';
    }

    protected URIMapping findExistingMapping(EObject proxy, ResourceSet resourceSet) {
        URI proxyURI = EcoreUtil.getURI((EObject)proxy);
        return this.findExistingMapping(proxyURI, resourceSet);
    }

    public void propagateURIMappings(List<URIMapping> allMappings, MappingParameters result) {
        for (URIMapping mapping : allMappings) {
            for (URIMapping uriMapping : result.getUriMappings()) {
                if (!uriMapping.getSourceURI().equals(mapping.getSourceURI())) continue;
                uriMapping.setTargetURI(mapping.getTargetURI());
            }
            for (URIMapping profileURIMapping : result.getProfileUriMappings()) {
                if (!profileURIMapping.getSourceURI().equals(mapping.getSourceURI())) continue;
                profileURIMapping.setTargetURI(mapping.getTargetURI());
            }
        }
    }

    public List<URIMapping> flattenURIMappings(MappingParameters result) {
        LinkedList<URIMapping> allMappings = new LinkedList<URIMapping>();
        allMappings.addAll((Collection<URIMapping>)result.getUriMappings());
        allMappings.addAll((Collection<URIMapping>)result.getProfileUriMappings());
        this.removeDuplicates(allMappings);
        return allMappings;
    }

    protected void removeDuplicates(List<URIMapping> allMappings) {
        LinkedList<URIMapping> mappingsCopy = new LinkedList<URIMapping>(allMappings);
        block0: for (URIMapping mapping : mappingsCopy) {
            for (URIMapping m : allMappings) {
                if (m == mapping || !mapping.getSourceURI().equals(m.getSourceURI()) || !allMappings.contains(mapping) || !allMappings.contains(m)) continue;
                URIMapping mappingToRemove = this.findLessSpecificMapping(mapping, m);
                allMappings.remove(mappingToRemove);
                continue block0;
            }
        }
    }

    protected URIMapping findLessSpecificMapping(URIMapping mapping1, URIMapping mapping2) {
        if (!this.isUsefulMapping(mapping1)) {
            return mapping1;
        }
        return mapping2;
    }

    protected boolean isUsefulMapping(URIMapping mapping) {
        return mapping.getTargetURI() != null && !"".equals(mapping.getTargetURI()) && !mapping.getTargetURI().equals(mapping.getSourceURI());
    }
}

