/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CPPLambdaExpressionParameter
extends PlatformObject
implements ICPPParameter {
    private IType fType;
    private IASTName fDeclaration;

    public CPPLambdaExpressionParameter(IASTName name) {
        this.fDeclaration = name;
    }

    @Override
    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.fDeclaration.getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fDeclaration);
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            IASTNode parent = this.fDeclaration.getParent();
            while (parent != null) {
                if (parent instanceof ICPPASTParameterDeclaration) {
                    this.fType = CPPVisitor.createType((ICPPASTParameterDeclaration)parent, false);
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.fType;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    private boolean hasStorageClass(int storage) {
        IASTDeclSpecifier declSpec;
        IASTNode parent = this.fDeclaration.getParent();
        while (parent != null && !(parent instanceof IASTParameterDeclaration)) {
            parent = parent.getParent();
        }
        return parent != null && (declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage;
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public IValue getDefaultValue() {
        return null;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    public String toString() {
        String name = this.getName();
        return name.length() != 0 ? name : "<unnamed>";
    }

    @Override
    public IBinding getOwner() {
        IType type;
        IASTNode node = this.fDeclaration;
        while (node != null && !(node instanceof ICPPASTLambdaExpression)) {
            node = node.getParent();
        }
        if (node instanceof ICPPASTLambdaExpression && (type = ((ICPPASTLambdaExpression)node).getExpressionType()) instanceof IBinding) {
            return (IBinding)((Object)type);
        }
        return null;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }
}

