/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.providers;

import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.papyrus.uml.diagram.common.parser.stereotype.AppliedStereotypeParser;
import org.eclipse.papyrus.uml.diagram.composite.custom.parsers.ConnectorLabelParser;
import org.eclipse.papyrus.uml.diagram.composite.custom.parsers.MultiplicityLabelParser;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLParserProvider;

public class CustomParserProvider
extends UMLParserProvider {
    protected IParser getAppliedStereotypeParser(String defaultEditString) {
        return new AppliedStereotypeParser(defaultEditString);
    }

    @Override
    protected IParser getParser(String visualID) {
        switch (visualID) {
            case "Connector_TargetMultiplicityLabel": 
            case "Connector_SourceMultiplicityLabel": {
                return this.getMultiplicityFormatParser();
            }
            case "Connector_NameLabel": {
                return this.getConnectorLabelParser();
            }
            case "Abstraction_StereotypeLabel": {
                return this.getAppliedStereotypeParser("abstraction");
            }
            case "Deployment_StereotypeLabel": {
                return this.getAppliedStereotypeParser("deployment");
            }
            case "InformationFlow_StereotypeLabel": {
                return this.getAppliedStereotypeParser("flow");
            }
            case "Manifestation_StereotypeLabel": {
                return this.getAppliedStereotypeParser("manifestation");
            }
            case "Substitution_StereotypeLabel": {
                return this.getAppliedStereotypeParser("substitution");
            }
            case "Usage_StereotypeLabel": {
                return this.getAppliedStereotypeParser("use");
            }
        }
        return super.getParser(visualID);
    }

    private IParser getConnectorLabelParser() {
        return new ConnectorLabelParser();
    }

    private IParser getMultiplicityFormatParser() {
        return new MultiplicityLabelParser();
    }
}

