/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.NullModelMinimizer;
import org.eclipse.emf.compare.ide.ui.internal.logical.RemoteMappingContextStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;

public class EMFModelProvider
extends ModelProvider {
    public static final String PROVIDER_ID = "org.eclipse.emf.compare.model.provider";
    public static final long CACHE_EXPIRATION = 120L;
    private static final Logger LOGGER = Logger.getLogger(EMFModelProvider.class);
    private final LoadingCache<ResourceMappingContext, Cache<IResource, SynchronizationModel>> contextToResourceMappingCache = CacheBuilder.newBuilder().initialCapacity(10).build((CacheLoader)new CacheLoader<ResourceMappingContext, Cache<IResource, SynchronizationModel>>(){

        public Cache<IResource, SynchronizationModel> load(ResourceMappingContext key) throws Exception {
            return CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).initialCapacity(10).build();
        }
    });

    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("getMappings() - START for " + resource));
        }
        if (resource instanceof IContainer) {
            final ArrayList modelResources = new ArrayList();
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) throws CoreException {
                    if (visitedResource instanceof IFile) {
                        IFile visitedFile = (IFile)visitedResource;
                        if (ResourceUtil.hasModelType((IFile)visitedFile)) {
                            modelResources.add(visitedFile);
                        }
                        return false;
                    }
                    return true;
                }
            });
            if (!modelResources.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)("getMappings() - " + resource + " is a container with models: " + ((Object)modelResources).toString()));
                }
                return this.getMappings(modelResources.toArray(new IResource[0]), context, monitor);
            }
        } else if (resource instanceof IFile) {
            try {
                SynchronizationModel syncModel = this.getOrComputeLogicalModel((IFile)resource, context, monitor);
                if (syncModel != null) {
                    EMFResourceMapping mapping = new EMFResourceMapping(resource, context, syncModel, PROVIDER_ID);
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)"getMappings() - FINISH NORMALLY");
                    }
                    return new ResourceMapping[]{mapping};
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"getMappings() - fallback to super.");
        }
        return super.getMappings(resource, context, monitor);
    }

    public ResourceMapping[] getMappings(IResource[] resources, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (LOGGER.isInfoEnabled()) {
            Joiner joiner = Joiner.on((String)",").skipNulls();
            String resourceList = joiner.join((Object[])resources);
            LOGGER.info((Object)("getMappings() - START for " + resourceList));
        }
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        ArrayList<IFile> files = new ArrayList<IFile>();
        ArrayList<IResource> remainingResources = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                files.add((IFile)resource);
            } else {
                remainingResources.add(resource);
            }
            ++n2;
        }
        try {
            Map<SynchronizationModel, IFile> syncModels = this.computeLogicalModels(files, context, monitor);
            for (Map.Entry<SynchronizationModel, IFile> entry : syncModels.entrySet()) {
                EMFResourceMapping mapping = new EMFResourceMapping((IResource)entry.getValue(), context, entry.getKey(), PROVIDER_ID);
                mappings.add(mapping);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)"getMappings() - interrupt exception: fallback to super.");
            }
            return super.getMappings(resources, context, monitor);
        }
        if (!remainingResources.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                Joiner joiner = Joiner.on((String)",").skipNulls();
                String resourceList = joiner.join(remainingResources);
                LOGGER.info((Object)("getMappings() - not all resources were handled. fallback to super for: " + resourceList));
            }
            mappings.addAll(Arrays.asList(super.getMappings(remainingResources.toArray(new IResource[remainingResources.size()]), context, monitor)));
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)"getMappings() - FINISH NORMALLY");
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    public void clear() {
        this.contextToResourceMappingCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SynchronizationModel getOrComputeLogicalModel(IFile file, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SynchronizationModel syncModel;
        LoadingCache<ResourceMappingContext, Cache<IResource, SynchronizationModel>> loadingCache = this.contextToResourceMappingCache;
        synchronized (loadingCache) {
            this.removeEmptyCacheEntries();
            Cache resourceMappingCache = (Cache)this.contextToResourceMappingCache.getUnchecked((Object)context);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Retrieved cache with ~ " + resourceMappingCache.size() + " entries  for context " + context));
            }
            if ((syncModel = (SynchronizationModel)resourceMappingCache.getIfPresent((Object)file)) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Cache MISSED for " + file));
                }
                if ((syncModel = this.computeLogicalModel(file, context, monitor)) != null) {
                    for (IResource res : syncModel.getResources()) {
                        resourceMappingCache.put((Object)res, (Object)syncModel);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"EMFModelProvider - Minimizing model");
                    }
                    EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer().minimize(file, syncModel, monitor);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Cache FOUND entry for " + file));
            }
        }
        return syncModel;
    }

    private void removeEmptyCacheEntries() {
        Iterator entries = this.contextToResourceMappingCache.asMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (((Cache)entry.getValue()).size() != 0L) continue;
            entries.remove();
        }
    }

    private SynchronizationModel computeLogicalModel(IFile file, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SynchronizationModel syncModel;
        IProgressMonitor actualMonitor;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - START");
        }
        if ((actualMonitor = monitor) == null) {
            actualMonitor = new NullProgressMonitor();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - resolving local model");
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)file);
        StorageTraversal localTraversal = resolver.resolveLocalModel((IResource)file, actualMonitor);
        if (context instanceof RemoteResourceMappingContext) {
            RemoteMappingContextStorageAccessor accessor = new RemoteMappingContextStorageAccessor((RemoteResourceMappingContext)context);
            ITypedElement left = null;
            ITypedElement right = null;
            ITypedElement origin = null;
            if (((RemoteResourceMappingContext)context).isThreeWay()) {
                left = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.SOURCE);
                right = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.REMOTE);
                origin = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.ORIGIN);
            } else {
                left = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.SOURCE);
                right = this.findTypedElement(localTraversal, accessor, actualMonitor, IStorageProviderAccessor.DiffSide.REMOTE);
            }
            IStorage leftStorage = null;
            if (left instanceof IAdaptable) {
                leftStorage = (IStorage)((IAdaptable)left).getAdapter(IStorage.class);
            }
            if (left == null || right == null) {
                return null;
            }
            IModelResolver remoteResolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor(leftStorage);
            ComparisonScopeBuilder builder = new ComparisonScopeBuilder(remoteResolver, new NullModelMinimizer(), accessor);
            syncModel = builder.buildSynchronizationModel(left, right, origin, actualMonitor);
        } else {
            syncModel = new SynchronizationModel(localTraversal, new StorageTraversal(Collections.emptySet()), new StorageTraversal(Collections.emptySet()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"computeLogicalModel() - FINISH");
        }
        return syncModel;
    }

    Map<SynchronizationModel, IFile> computeLogicalModels(Collection<IFile> files, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            Joiner joiner = Joiner.on((String)",").skipNulls();
            String fileList = joiner.join(files);
            LOGGER.debug((Object)("computeLogicalModels() - START with " + fileList));
        }
        LinkedHashMap<SynchronizationModel, IFile> syncModels = new LinkedHashMap<SynchronizationModel, IFile>();
        for (IFile file : files) {
            SynchronizationModel currentSyncModel = this.getOrComputeLogicalModel(file, context, monitor);
            if (currentSyncModel == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("computeLogicalModels() - Could not determine logical model for \"" + file + "\". SKIP file."));
                continue;
            }
            boolean combineModels = false;
            LinkedList<SynchronizationModel> toCombine = new LinkedList<SynchronizationModel>();
            for (SynchronizationModel syncModel : syncModels.keySet()) {
                if (Collections.disjoint(syncModel.getResources(), currentSyncModel.getResources())) continue;
                toCombine.add(syncModel);
                if (syncModel.getResources().containsAll(currentSyncModel.getResources())) continue;
                combineModels = true;
            }
            if (toCombine.isEmpty()) {
                syncModels.put(currentSyncModel, file);
            }
            if (!combineModels) continue;
            Iterator it = toCombine.iterator();
            SynchronizationModel firstToCombine = (SynchronizationModel)it.next();
            IFile value = (IFile)syncModels.get(firstToCombine);
            SynchronizationModel combinedModel = this.combineModels(currentSyncModel, firstToCombine);
            syncModels.remove(firstToCombine);
            while (it.hasNext()) {
                SynchronizationModel currentModel = (SynchronizationModel)it.next();
                combinedModel = this.combineModels(combinedModel, currentModel);
                syncModels.remove(currentModel);
            }
            syncModels.put(combinedModel, value);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("computeLogicalModels() - FINISH with " + syncModels.size() + " models"));
        }
        return syncModels;
    }

    private SynchronizationModel combineModels(SynchronizationModel modelA, SynchronizationModel modelB) {
        HashSet left = new HashSet();
        HashSet right = new HashSet();
        HashSet origin = new HashSet();
        StorageTraversal leftTraversal = null;
        StorageTraversal rightTraversal = null;
        StorageTraversal originTraversal = null;
        if (modelA.getLeftTraversal() != null) {
            left.addAll(modelA.getLeftTraversal().getStorages());
            if (modelB != null && modelB.getLeftTraversal() != null) {
                left.addAll(modelB.getLeftTraversal().getStorages());
            }
            leftTraversal = new StorageTraversal(left);
        }
        if (modelA.getRightTraversal() != null) {
            right.addAll(modelA.getRightTraversal().getStorages());
            if (modelB != null && modelB.getRightTraversal() != null) {
                right.addAll(modelB.getRightTraversal().getStorages());
            }
            rightTraversal = new StorageTraversal(right);
        }
        if (modelA.getOriginTraversal() != null) {
            origin.addAll(modelA.getOriginTraversal().getStorages());
            if (modelB != null && modelB.getOriginTraversal() != null) {
                right.addAll(modelB.getOriginTraversal().getStorages());
            }
            originTraversal = new StorageTraversal(origin);
        }
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    private ITypedElement findTypedElement(StorageTraversal traversal, IStorageProviderAccessor storageAccessor, IProgressMonitor monitor, IStorageProviderAccessor.DiffSide side) throws CoreException {
        if (traversal != null && !traversal.getStorages().isEmpty()) {
            for (IStorage storage : traversal.getStorages()) {
                IStorageProvider storageProvider;
                if (!(storage instanceof IFile) || (storageProvider = storageAccessor.getStorageProvider((IResource)((IFile)storage), side)) == null) continue;
                return new StorageTypedElement(storageProvider.getStorage(monitor), ResourceUtil.getFixedPath((IStorage)storage).toString());
            }
        }
        return null;
    }
}

