/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.AbstractChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.util.UMLSwitch;

public abstract class AbstractUMLChangeFactory
extends AbstractChangeFactory {
    public boolean handles(Diff input) {
        return super.handles(input) && !this.isChangeOnAddOrDelete(input) && input.getRefines().isEmpty();
    }

    public Diff create(Diff input) {
        Diff ret = super.create(input);
        if (ret instanceof UMLDiff) {
            ((UMLDiff)ret).setDiscriminant(this.getDiscriminant(input));
            this.setEReference(input, (UMLDiff)ret);
        }
        return ret;
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        LinkedHashMultimap refiningCandidates = LinkedHashMultimap.create();
        Comparison comparison = ComparisonUtil.getComparison((Diff)refiningDiff);
        Set<EObject> discriminants = this.getDiscriminants(refiningDiff);
        for (EObject discriminant : discriminants) {
            this.defineRefiningCandidates(discriminant, (Multimap<Object, RefiningCandidate>)refiningCandidates);
            for (Object elt : refiningCandidates.keys()) {
                this.beRefinedByCrossReferences(comparison, elt, (UMLDiff)extension, new DifferencesOnRefiningCandidates(comparison, (SetMultimap<Object, RefiningCandidate>)refiningCandidates));
            }
        }
    }

    public Match getParentMatch(Diff input) {
        return this.getParentMatch(ComparisonUtil.getComparison((Diff)input), input);
    }

    protected Set<EObject> getDiscriminants(Diff input) {
        EObject value = input instanceof ReferenceChange && ((ReferenceChange)input).getReference().isContainment() ? ((ReferenceChange)input).getValue() : MatchUtil.getContainer((Comparison)ComparisonUtil.getComparison((Diff)input), (Diff)input);
        return this.getDiscriminants(value);
    }

    protected EStructuralFeature.Setting getInverseReferences(EObject object, Predicate<EStructuralFeature.Setting> predicate) {
        Iterator crossReferences = UML2Util.getInverseReferences((EObject)object).iterator();
        return (EStructuralFeature.Setting)Iterators.find(crossReferences, predicate, null);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getKind() == DifferenceKind.ADD && input.getReference().isContainment() && input.getValue() == this.getDiscriminant((Diff)input);
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getKind() == DifferenceKind.DELETE && input.getReference().isContainment() && input.getValue() == this.getDiscriminant((Diff)input);
    }

    protected abstract Switch<Set<EObject>> getDiscriminantsGetter();

    protected abstract EObject getDiscriminant(Diff var1);

    protected static Set<EObject> defaultCaseForDiscriminantsGetter(Switch<Set<EObject>> discriminantsGetter, EObject object) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        EObject parent = object.eContainer();
        if (parent != null) {
            result.addAll((Collection)discriminantsGetter.doSwitch(parent));
        }
        return result;
    }

    private Set<EObject> getDiscriminants(EObject value) {
        Switch<Set<EObject>> discriminantGetter = this.getDiscriminantsGetter();
        return (Set)discriminantGetter.doSwitch(value);
    }

    private void defineRefiningCandidates(EObject discriminant, Multimap<Object, RefiningCandidate> refiningCandidates) {
        refiningCandidates.put((Object)discriminant, (Object)new RefiningCandidate());
        this.defineRefiningCandidatesFrom(discriminant, refiningCandidates);
    }

    private void defineRefiningCandidatesFrom(EObject discriminant, Multimap<Object, RefiningCandidate> refiningCandidates) {
        for (EStructuralFeature outgoingFeature : discriminant.eClass().getEAllStructuralFeatures()) {
            for (Object value : ReferenceUtil.getAsList((EObject)discriminant, (EStructuralFeature)outgoingFeature)) {
                refiningCandidates.put(value, (Object)new RefiningCandidate(discriminant, outgoingFeature));
                if (!(outgoingFeature instanceof EReference) || !(value instanceof EObject)) continue;
                if (((EReference)outgoingFeature).isContainment()) {
                    this.defineRefiningCandidatesFrom((EObject)value, refiningCandidates);
                    continue;
                }
                if (((EReference)outgoingFeature).getEOpposite() == null) continue;
                refiningCandidates.put((Object)discriminant, (Object)new RefiningCandidate((EObject)value, (EStructuralFeature)((EReference)outgoingFeature).getEOpposite()));
            }
        }
    }

    private Match getParentMatch(Comparison comparison, Diff input) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE) {
            return comparison.getMatch(this.getDiscriminant(input));
        }
        return input.getMatch();
    }

    private void beRefinedByCrossReferences(Comparison comparison, Object lookup, UMLDiff refinedExtension, Predicate<Diff> p) {
        if (lookup instanceof EObject) {
            List crossReferences = this.findCrossReferences(comparison, (EObject)lookup, p);
            refinedExtension.getRefinedBy().addAll(Collections2.filter((Collection)crossReferences, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)refinedExtension.getSource())));
        }
    }

    private void setEReference(Diff input, UMLDiff umlDiff) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.ADD || this.getRelatedExtensionKind(input) == DifferenceKind.DELETE) {
            if (input instanceof ReferenceChange) {
                umlDiff.setEReference(((ReferenceChange)input).getReference());
            } else if (input instanceof ResourceAttachmentChange && umlDiff instanceof StereotypeApplicationChange) {
                EList candidates = input.getMatch().getDifferences();
                for (Diff candidate : candidates) {
                    if (!(candidate instanceof ReferenceChange)) continue;
                    umlDiff.setEReference(((ReferenceChange)candidate).getReference());
                }
            }
        }
    }

    protected boolean isChangeOnAddOrDelete(Diff input) {
        if (this.getRelatedExtensionKind(input) == DifferenceKind.CHANGE) {
            Comparison comparison = ComparisonUtil.getComparison((Diff)input);
            EObject discriminant = this.getDiscriminant(input);
            if (discriminant != null) {
                return this.isChangeOnAddOrDelete(input, comparison, discriminant);
            }
        }
        return false;
    }

    private boolean isChangeOnAddOrDelete(Diff input, Comparison comparison, EObject discriminant) {
        boolean result = false;
        Match match = comparison.getMatch(discriminant);
        if (match != null && Iterables.any((Iterable)match.getDifferences(), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class))) {
            result = true;
        }
        if (!result) {
            EList candidates = comparison.getDifferences(discriminant);
            for (Diff diff : candidates) {
                DifferenceKind relatedExtensionKind;
                if (diff == input || (relatedExtensionKind = this.getRelatedExtensionKind(diff)) != DifferenceKind.ADD && relatedExtensionKind != DifferenceKind.DELETE || this.getDiscriminant(diff) != discriminant) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private class DifferencesOnRefiningCandidates
    implements Predicate<Diff> {
        private final Comparison fComparison;
        private final SetMultimap<Object, RefiningCandidate> fRefiningCandidates;

        DifferencesOnRefiningCandidates(Comparison comparison, SetMultimap<Object, RefiningCandidate> refiningCandidates) {
            this.fComparison = comparison;
            this.fRefiningCandidates = refiningCandidates;
        }

        public boolean apply(final Diff input) {
            boolean result = false;
            Object value = MatchUtil.getValue((Diff)input);
            Set settings = this.fRefiningCandidates.get(value);
            if (settings.size() > 0) {
                result = Iterables.any((Iterable)settings, (Predicate)new Predicate<EStructuralFeature.Setting>(){

                    public boolean apply(EStructuralFeature.Setting setting) {
                        boolean res = true;
                        if (setting.getEObject() != null) {
                            boolean bl = res = input.getMatch() == DifferencesOnRefiningCandidates.this.fComparison.getMatch(setting.getEObject());
                        }
                        if (setting.getEStructuralFeature() != null) {
                            res = res && MatchUtil.getStructuralFeature((Diff)input) == setting.getEStructuralFeature();
                        } else {
                            EStructuralFeature diffFeature = MatchUtil.getStructuralFeature((Diff)input);
                            res = res && DiffUtil.isContainmentReference((EStructuralFeature)diffFeature);
                        }
                        return res;
                    }
                });
            }
            return result;
        }
    }

    protected class DiscriminantsGetter
    extends UMLSwitch<Set<EObject>> {
        protected DiscriminantsGetter() {
        }

        public Set<EObject> defaultCase(EObject object) {
            return AbstractUMLChangeFactory.defaultCaseForDiscriminantsGetter((Switch<Set<EObject>>)this, object);
        }
    }

    private class RefiningCandidate
    implements EStructuralFeature.Setting {
        private EObject holdingObject;
        private EStructuralFeature eStructuralFeature;

        RefiningCandidate() {
        }

        RefiningCandidate(EObject holdingObject, EStructuralFeature feature) {
            this.holdingObject = holdingObject;
            this.eStructuralFeature = feature;
        }

        public EObject getEObject() {
            return this.holdingObject;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public Object get(boolean resolve) {
            return null;
        }

        public void set(Object newValue) {
        }

        public boolean isSet() {
            return false;
        }

        public void unset() {
        }
    }
}

