/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IUnsetValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;

public class StringResolutionProblemWrapperCellManager
implements IUnsetValueCellManager {
    private ICellManager wrappedCellManager;

    public StringResolutionProblemWrapperCellManager(ICellManager wrappedCellManager) {
        this.wrappedCellManager = wrappedCellManager;
    }

    @Override
    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.wrappedCellManager.handles(columnElement, rowElement, tableManager);
    }

    @Override
    public Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        EList problems;
        Cell cell = tableManager.getCell(columnElement, rowElement);
        if (cell != null && (problems = cell.getProblems()).size() != 0) {
            return problems;
        }
        return this.wrappedCellManager.getValue(columnElement, rowElement, tableManager);
    }

    public Object getValueIgnoringCellProblem(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.wrappedCellManager.getValue(columnElement, rowElement, tableManager);
    }

    @Override
    public void setValue(final TransactionalEditingDomain domain, final Object columnElement, final Object rowElement, final Object newValue, final INattableModelManager tableManager) {
        final Command destroyStringProblemCommand = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (destroyStringProblemCommand != null) {
            RecordingCommand rc = new RecordingCommand(domain){

                protected void doExecute() {
                    destroyStringProblemCommand.execute();
                    StringResolutionProblemWrapperCellManager.this.wrappedCellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
                }
            };
            domain.getCommandStack().execute((Command)rc);
        } else {
            this.wrappedCellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
        }
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.wrappedCellManager.isCellEditable(columnElement, rowElement, tableManager);
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Command cmd = this.wrappedCellManager.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        Command destroyStringProblem = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (cmd != null && destroyStringProblem != null && destroyStringProblem.canExecute()) {
            return cmd.chain(destroyStringProblem);
        }
        return cmd;
    }

    @Override
    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueConverter, INattableModelManager tableManager) {
        Command createCellProblemCommand;
        CompoundCommand cc = new CompoundCommand();
        Command setValueCommand = this.wrappedCellManager.getSetStringValueCommand(domain, columnElement, rowElement, newValue, valueConverter, tableManager);
        if (setValueCommand != null && setValueCommand.canExecute()) {
            cc.append(setValueCommand);
            Command destroyExistingCellStringResolutionProblemCommand = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
            if (destroyExistingCellStringResolutionProblemCommand != null && destroyExistingCellStringResolutionProblemCommand.canExecute()) {
                cc.append(destroyExistingCellStringResolutionProblemCommand);
            }
        }
        if (setValueCommand == null && (createCellProblemCommand = CellHelper.getCreateStringResolutionProblemCommand(domain, tableManager, columnElement, rowElement, newValue, valueConverter.getConvertedValue())) != null && createCellProblemCommand.canExecute()) {
            cc.append(createCellProblemCommand);
        }
        if (cc.isEmpty() || !cc.canExecute()) {
            return null;
        }
        return cc;
    }

    @Override
    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        return this.wrappedCellManager.getOrCreateStringValueConverterClass(existingConverters, multiValueSeparator, tableManager);
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return this.wrappedCellManager.isCellEditable(columnElement, rowElement, sharedMap, tableManager);
    }

    @Override
    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        this.wrappedCellManager.setStringValue(columnElement, rowElement, valueAsString, valueConverter, sharedMap, tableManager);
        CellHelper.createStringResolutionProblem(tableManager, columnElement, rowElement, valueAsString, valueConverter.getConvertedValue(), sharedMap);
    }

    @Override
    public void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.wrappedCellManager instanceof IUnsetValueCellManager) {
            ((IUnsetValueCellManager)this.wrappedCellManager).unsetCellValue(domain, columnElement, rowElement, tableManager);
        }
    }

    @Override
    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.wrappedCellManager instanceof IUnsetValueCellManager) {
            return ((IUnsetValueCellManager)this.wrappedCellManager).getUnsetCellValueCommand(domain, columnElement, rowElement, tableManager);
        }
        return null;
    }
}

