/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.internal.accessor;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.IStreamContentAccessor;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.legacy.impl.AbstractTypedElementAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;

public class OpaqueElementBodyChangeAccessor
extends AbstractTypedElementAdapter
implements IStreamContentAccessor {
    private OpaqueElementBodyChange bodyChange;
    private final EObject eObject;

    public OpaqueElementBodyChangeAccessor(AdapterFactory adapterFactory, OpaqueElementBodyChange bodyChange, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory);
        this.bodyChange = bodyChange;
        this.eObject = MergeViewerUtil.getEObject((Match)bodyChange.getMatch(), (IMergeViewer.MergeViewerSide)side);
        if (DifferenceKind.MOVE.equals((Object)bodyChange.getKind())) {
            throw new IllegalArgumentException("This accessor handles only additions, deletions, and changes of body values.");
        }
    }

    public InputStream getContents() throws CoreException {
        String language = this.bodyChange.getLanguage();
        byte[] contents = (byte[])this.getBodyAsByte(language).or((Object)new byte[0]);
        return new ByteArrayInputStream(contents);
    }

    private Optional<byte[]> getBodyAsByte(String language) {
        List<String> languages = this.getLanguageValues();
        List<String> bodies = this.getBodyValues();
        Optional body = languages.contains(language) && bodies.size() > languages.indexOf(language) ? Optional.of((Object)bodies.get(languages.indexOf(language)).getBytes()) : Optional.absent();
        return body;
    }

    private List<String> getLanguageValues() {
        if (this.eObject == null) {
            return Collections.emptyList();
        }
        return (List)ReferenceUtil.safeEGet((EObject)this.eObject, (EStructuralFeature)this.getLanguageFeature());
    }

    private List<String> getBodyValues() {
        if (this.eObject == null) {
            return Collections.emptyList();
        }
        return (List)ReferenceUtil.safeEGet((EObject)this.eObject, (EStructuralFeature)this.getBodyFeature());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Image getImage() {
        return ExtendedImageRegistry.INSTANCE.getImage(this.getItemDelegator().getImage((Object)this.getBodyFeature()));
    }

    private EStructuralFeature getBodyFeature() {
        EAttribute bodyFeature;
        if (this.eObject instanceof OpaqueAction) {
            bodyFeature = UMLPackage.Literals.OPAQUE_ACTION__BODY;
        } else if (this.eObject instanceof OpaqueBehavior) {
            bodyFeature = UMLPackage.Literals.OPAQUE_BEHAVIOR__BODY;
        } else if (this.eObject instanceof OpaqueExpression) {
            bodyFeature = UMLPackage.Literals.OPAQUE_EXPRESSION__BODY;
        } else {
            throw new IllegalArgumentException("Cannot get body feature of the class " + this.eObject.eClass().getName());
        }
        return bodyFeature;
    }

    private EStructuralFeature getLanguageFeature() {
        return this.getLanguageFeature(this.eObject);
    }

    private EStructuralFeature getLanguageFeature(EObject object) {
        EAttribute languageFeature;
        if (object instanceof OpaqueAction) {
            languageFeature = UMLPackage.Literals.OPAQUE_ACTION__LANGUAGE;
        } else if (object instanceof OpaqueBehavior) {
            languageFeature = UMLPackage.Literals.OPAQUE_BEHAVIOR__LANGUAGE;
        } else if (object instanceof OpaqueExpression) {
            languageFeature = UMLPackage.Literals.OPAQUE_EXPRESSION__LANGUAGE;
        } else {
            throw new IllegalArgumentException("Cannot get language feature of the class " + object.eClass().getName());
        }
        return languageFeature;
    }

    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eTextDiff";
    }
}

