/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DisassemblyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<Button> fCheckBoxes = new ArrayList<Button>();
    private List<Combo> fComboBoxes = new ArrayList<Combo>();
    private ArrayList<Text> fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DisassemblyPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private Combo fAddressFormatCombo;
    private Combo fOpcodeFormatCombo;
    private static final String[] fcRadixItems = new String[]{DisassemblyMessages.DisassemblyPreferencePage_radix_octal, DisassemblyMessages.DisassemblyPreferencePage_radix_decimal, DisassemblyMessages.DisassemblyPreferencePage_radix_hexadecimal};
    private static final int[] fcRadixValues = new int[]{8, 10, 16};

    public DisassemblyPreferencePage() {
        this.setPreferenceStore(DsfUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.dsf.ui.disassembly_preference_page");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        String label = DisassemblyMessages.DisassemblyPreferencePage_addressRadix;
        this.fAddressFormatCombo = this.addComboBox(composite, label, "disassembly.addressRadix", fcRadixItems);
        this.fAddressFormatCombo.setToolTipText(DisassemblyMessages.DisassemblyPreferencePage_addressFormatTooltip);
        label = DisassemblyMessages.DisassemblyPreferencePage_showAddressRadix;
        Button showRadixCB = this.addCheckBox(composite, label, "disassembly.showAddressRadix", 0);
        showRadixCB.setToolTipText(DisassemblyMessages.DisassemblyPreferencePage_showRadixTooltip);
        label = DisassemblyMessages.DisassemblyPreferencePage_OpcodeFormat;
        this.fOpcodeFormatCombo = this.addComboBox(composite, label, "disassembly.opcodeRadix", fcRadixItems);
        this.fOpcodeFormatCombo.setToolTipText(DisassemblyMessages.DisassemblyPreferencePage_OpcodeFormatTooltip);
        label = DisassemblyMessages.DisassemblyPreferencePage_showSource;
        Button showSourceCB = this.addCheckBox(composite, label, "disassembly.showSource", 0);
        showSourceCB.setToolTipText(DisassemblyMessages.DisassemblyPreferencePage_showSourceTooltip);
        label = DisassemblyMessages.DisassemblyPreferencePage_showSymbols;
        Button showSymbolsCB = this.addCheckBox(composite, label, "disassembly.showSymbols", 0);
        showSymbolsCB.setToolTipText(DisassemblyMessages.DisassemblyPreferencePage_showSymbolsTooltip);
        Dialog.applyDialogFont((Control)parent);
        this.initialize();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 3;
        checkBox.setLayoutData((Object)gd);
        checkBox.setData((Object)key);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    private Combo addComboBox(Composite parent, String label, String key, String[] items) {
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 2;
        labelControl.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 8);
        gd = new GridData(32);
        combo.setLayoutData((Object)gd);
        combo.setItems(items);
        combo.setData((Object)key);
        this.fComboBoxes.add(combo);
        return combo;
    }

    protected Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return DisassemblyPreferencePage.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setData((Object)key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            store.setValue((String)btn.getData(), btn.getSelection());
        }
        for (Text field : this.fNumberFields) {
            store.setValue((String)field.getData(), Long.decode(field.getText()).longValue());
        }
        for (Combo combo : this.fComboBoxes) {
            store.setValue((String)combo.getData(), fcRadixValues[combo.getSelectionIndex()]);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            btn.setSelection(store.getDefaultBoolean((String)btn.getData()));
        }
        for (Text field : this.fNumberFields) {
            long value = store.getDefaultLong((String)field.getData());
            field.setText("0x" + Long.toHexString(value));
        }
        for (Combo combo : this.fComboBoxes) {
            int value = store.getDefaultInt((String)combo.getData());
            int i = 0;
            while (i < fcRadixValues.length) {
                if (fcRadixValues[i] == value) {
                    combo.select(i);
                }
                ++i;
            }
        }
        super.performDefaults();
    }

    private void initialize() {
        IPreferenceStore store = this.getPreferenceStore();
        for (Button btn : this.fCheckBoxes) {
            btn.setSelection(store.getBoolean((String)btn.getData()));
        }
        for (Text field : this.fNumberFields) {
            long value = store.getLong((String)field.getData());
            field.setText("0x" + Long.toHexString(value));
        }
        block2: for (Combo combo : this.fComboBoxes) {
            int value = store.getInt((String)combo.getData());
            int i = 0;
            while (i < fcRadixValues.length) {
                if (fcRadixValues[i] == value) {
                    combo.select(i);
                    continue block2;
                }
                ++i;
            }
        }
    }

    protected void numberFieldChanged(Text text) {
        try {
            long value = Long.decode(text.getText());
            if (value < 0L) {
                this.setErrorMessage(DisassemblyMessages.DisassemblyPreferencePage_error_negative_number);
            } else {
                this.setErrorMessage(null);
            }
        }
        catch (NumberFormatException nfe) {
            this.setErrorMessage(DisassemblyMessages.DisassemblyPreferencePage_error_not_a_number);
        }
    }
}

