/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ICheckboxModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;

public class BreakpointVMModelProxyStrategy
extends DefaultVMModelProxyStrategy
implements ICheckboxModelProxy {
    public BreakpointVMModelProxyStrategy(AbstractVMProvider provider, Object rootElement) {
        super(provider, rootElement);
    }

    public boolean setChecked(IPresentationContext context, Object viewerInput, TreePath path, boolean checked) {
        Object lastSegment = path.getLastSegment();
        if (lastSegment instanceof IBreakpointContainer) {
            IBreakpoint[] breakpoints = ((IBreakpointContainer)lastSegment).getBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                try {
                    breakpoints[i].setEnabled(checked);
                }
                catch (CoreException e) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        IBreakpoint breakpoint = (IBreakpoint)DebugPlugin.getAdapter((Object)lastSegment, IBreakpoint.class);
        if (breakpoint != null) {
            try {
                breakpoint.setEnabled(checked);
            }
            catch (CoreException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

